/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.FilterUtil;
import com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.annotations.NotNull;

public class AssignableToFilter
implements ElementFilter {
    private final PsiType myType;

    public AssignableToFilter(@NotNull PsiType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/filters/types/AssignableToFilter", "<init>"));
        }
        this.myType = type2;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        if (element == null) {
            return false;
        }
        if (element instanceof PsiType) {
            return this.myType.isAssignableFrom((PsiType)element);
        }
        PsiSubstitutor substitutor = null;
        if (element instanceof CandidateInfo) {
            CandidateInfo info = (CandidateInfo)element;
            substitutor = info.getSubstitutor();
            element = info.getElement();
        }
        PsiType typeByElement = FilterUtil.getTypeByElement((PsiElement)element, context);
        if (substitutor != null) {
            typeByElement = substitutor.substitute(typeByElement);
        }
        return typeByElement != null && typeByElement.isAssignableFrom(this.myType) && !typeByElement.equals(this.myType);
    }

    public String toString() {
        return "assignable-to(" + this.myType + ")";
    }
}

