/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatterUtil {
    public static final String REFORMAT_BEFORE_COMMIT_COMMAND_NAME = CodeInsightBundle.message((String)"process.reformat.code.before.commit", (Object[])new Object[0]);
    public static final Collection<String> FORMATTER_ACTION_NAMES = Collections.unmodifiableCollection(ContainerUtilRt.newHashSet((Object[])new String[]{ReformatCodeProcessor.COMMAND_NAME, REFORMAT_BEFORE_COMMIT_COMMAND_NAME}));

    private FormatterUtil() {
    }

    public static boolean isWhitespaceOrEmpty(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        IElementType type2 = node.getElementType();
        return type2 == TokenType.WHITE_SPACE || type2 != TokenType.ERROR_ELEMENT && node.getTextLength() == 0;
    }

    public static boolean isOneOf(@Nullable ASTNode node, IElementType ... types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/formatter/FormatterUtil", "isOneOf"));
        }
        if (node == null) {
            return false;
        }
        IElementType elementType = node.getElementType();
        for (IElementType each : types) {
            if (elementType != each) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ASTNode getPrevious(@Nullable ASTNode node, IElementType ... typesToIgnore) {
        if (typesToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesToIgnore", "com/intellij/psi/formatter/FormatterUtil", "getPrevious"));
        }
        return FormatterUtil.getNextOrPrevious(node, false, typesToIgnore);
    }

    @Nullable
    public static ASTNode getNext(@Nullable ASTNode node, IElementType ... typesToIgnore) {
        if (typesToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesToIgnore", "com/intellij/psi/formatter/FormatterUtil", "getNext"));
        }
        return FormatterUtil.getNextOrPrevious(node, true, typesToIgnore);
    }

    @Nullable
    private static ASTNode getNextOrPrevious(@Nullable ASTNode node, boolean isNext, IElementType ... typesToIgnore) {
        if (typesToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesToIgnore", "com/intellij/psi/formatter/FormatterUtil", "getNextOrPrevious"));
        }
        if (node == null) {
            return null;
        }
        ASTNode each = isNext ? node.getTreeNext() : node.getTreePrev();
        for (ASTNode parent = node.getTreeParent(); each == null && parent != null; parent = parent.getTreeParent()) {
            each = isNext ? parent.getTreeNext() : parent.getTreePrev();
        }
        if (each == null) {
            return null;
        }
        for (IElementType type2 : typesToIgnore) {
            if (each.getElementType() != type2) continue;
            return FormatterUtil.getNextOrPrevious(each, isNext, typesToIgnore);
        }
        return each;
    }

    @Nullable
    public static ASTNode getPreviousLeaf(@Nullable ASTNode node, IElementType ... typesToIgnore) {
        if (typesToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesToIgnore", "com/intellij/psi/formatter/FormatterUtil", "getPreviousLeaf"));
        }
        ASTNode prev = FormatterUtil.getPrevious(node, typesToIgnore);
        if (prev == null) {
            return null;
        }
        ASTNode result2 = prev;
        for (ASTNode lastChild = prev.getLastChildNode(); lastChild != null; lastChild = lastChild.getLastChildNode()) {
            result2 = lastChild;
        }
        for (IElementType type2 : typesToIgnore) {
            if (result2.getElementType() != type2) continue;
            return FormatterUtil.getPreviousLeaf(result2, typesToIgnore);
        }
        return result2;
    }

    @Nullable
    public static ASTNode getPreviousNonWhitespaceLeaf(@Nullable ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode treePrev = node.getTreePrev();
        if (treePrev != null) {
            ASTNode candidate = TreeUtil.getLastChild(treePrev);
            if (candidate != null && !FormatterUtil.isWhitespaceOrEmpty(candidate)) {
                return candidate;
            }
            return FormatterUtil.getPreviousNonWhitespaceLeaf(candidate);
        }
        ASTNode treeParent = node.getTreeParent();
        if (treeParent == null || treeParent.getTreeParent() == null) {
            return null;
        }
        return FormatterUtil.getPreviousNonWhitespaceLeaf(treeParent);
    }

    @Nullable
    public static ASTNode getPreviousNonWhitespaceSibling(@Nullable ASTNode node) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node == null ? null : node.getTreePrev();
        while (prevNode != null && FormatterUtil.isWhitespaceOrEmpty(prevNode)) {
            prevNode = prevNode.getTreePrev();
        }
        return prevNode;
    }

    @Nullable
    public static ASTNode getNextNonWhitespaceSibling(@Nullable ASTNode node) {
        ASTNode next;
        ASTNode aSTNode = next = node == null ? null : node.getTreeNext();
        while (next != null && FormatterUtil.isWhitespaceOrEmpty(next)) {
            next = next.getTreeNext();
        }
        return next;
    }

    public static boolean isPrecededBy(@Nullable ASTNode node, IElementType expectedType) {
        return FormatterUtil.isPrecededBy(node, expectedType, IElementType.EMPTY_ARRAY);
    }

    public static boolean isPrecededBy(@Nullable ASTNode node, IElementType expectedType, TokenSet skipTypes) {
        return FormatterUtil.isPrecededBy(node, expectedType, skipTypes.getTypes());
    }

    public static boolean isPrecededBy(@Nullable ASTNode node, IElementType expectedType, IElementType ... skipTypes) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node == null ? null : node.getTreePrev();
        while (prevNode != null && (FormatterUtil.isWhitespaceOrEmpty(prevNode) || FormatterUtil.isOneOf(prevNode, skipTypes))) {
            prevNode = prevNode.getTreePrev();
        }
        if (prevNode == null) {
            return false;
        }
        return prevNode.getElementType() == expectedType;
    }

    public static boolean isPrecededBy(@Nullable ASTNode node, TokenSet expectedTypes) {
        return FormatterUtil.isPrecededBy(node, expectedTypes, IElementType.EMPTY_ARRAY);
    }

    public static boolean isPrecededBy(@Nullable ASTNode node, TokenSet expectedTypes, TokenSet skipTypes) {
        return FormatterUtil.isPrecededBy(node, expectedTypes, skipTypes.getTypes());
    }

    public static boolean isPrecededBy(@Nullable ASTNode node, TokenSet expectedTypes, IElementType ... skipTypes) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node == null ? null : node.getTreePrev();
        while (prevNode != null && (FormatterUtil.isWhitespaceOrEmpty(prevNode) || FormatterUtil.isOneOf(prevNode, skipTypes))) {
            prevNode = prevNode.getTreePrev();
        }
        if (prevNode == null) {
            return false;
        }
        return expectedTypes.contains(prevNode.getElementType());
    }

    public static boolean hasPrecedingSiblingOfType(@Nullable ASTNode node, IElementType expectedSiblingType, IElementType ... skipTypes) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node == null ? null : node.getTreePrev();
        while (prevNode != null) {
            if (!FormatterUtil.isWhitespaceOrEmpty(prevNode) && !FormatterUtil.isOneOf(prevNode, skipTypes) && prevNode.getElementType() == expectedSiblingType) {
                return true;
            }
            prevNode = prevNode.getTreePrev();
        }
        return false;
    }

    public static boolean isFollowedBy(@Nullable ASTNode node, IElementType expectedType) {
        return FormatterUtil.isFollowedBy(node, expectedType, IElementType.EMPTY_ARRAY);
    }

    public static boolean isFollowedBy(@Nullable ASTNode node, IElementType expectedType, TokenSet skipTypes) {
        return FormatterUtil.isFollowedBy(node, expectedType, skipTypes.getTypes());
    }

    public static boolean isFollowedBy(@Nullable ASTNode node, IElementType expectedType, IElementType ... skipTypes) {
        ASTNode nextNode;
        ASTNode aSTNode = nextNode = node == null ? null : node.getTreeNext();
        while (nextNode != null && (FormatterUtil.isWhitespaceOrEmpty(nextNode) || FormatterUtil.isOneOf(nextNode, skipTypes))) {
            nextNode = nextNode.getTreeNext();
        }
        if (nextNode == null) {
            return false;
        }
        return nextNode.getElementType() == expectedType;
    }

    public static boolean isFollowedBy(@Nullable ASTNode node, @NotNull TokenSet expectedTypes, TokenSet skipTypes) {
        if (expectedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedTypes", "com/intellij/psi/formatter/FormatterUtil", "isFollowedBy"));
        }
        return FormatterUtil.isFollowedBy(node, expectedTypes, skipTypes.getTypes());
    }

    public static boolean isFollowedBy(@Nullable ASTNode node, @NotNull TokenSet expectedTypes, IElementType ... skipTypes) {
        ASTNode nextNode;
        if (expectedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedTypes", "com/intellij/psi/formatter/FormatterUtil", "isFollowedBy"));
        }
        ASTNode aSTNode = nextNode = node == null ? null : node.getTreeNext();
        while (nextNode != null && (FormatterUtil.isWhitespaceOrEmpty(nextNode) || FormatterUtil.isOneOf(nextNode, skipTypes))) {
            nextNode = nextNode.getTreeNext();
        }
        if (nextNode == null) {
            return false;
        }
        return expectedTypes.contains(nextNode.getElementType());
    }

    public static boolean isIncomplete(@Nullable ASTNode node) {
        ASTNode lastChild;
        ASTNode aSTNode = lastChild = node == null ? null : node.getLastChildNode();
        while (lastChild != null && lastChild.getElementType() == TokenType.WHITE_SPACE) {
            lastChild = lastChild.getTreePrev();
        }
        if (lastChild == null) {
            return false;
        }
        if (lastChild.getElementType() == TokenType.ERROR_ELEMENT) {
            return true;
        }
        return FormatterUtil.isIncomplete(lastChild);
    }

    public static boolean containsWhiteSpacesOnly(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        final boolean[] spacesOnly = new boolean[]{true};
        ((TreeElement)node).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitComposite(CompositeElement composite) {
                if (!FormatterUtil.spacesOnly(composite)) {
                    super.visitComposite(composite);
                }
            }

            @Override
            public void visitLeaf(LeafElement leaf) {
                if (!FormatterUtil.spacesOnly(leaf)) {
                    spacesOnly[0] = false;
                    this.stopWalking();
                }
            }
        });
        return spacesOnly[0];
    }

    private static boolean spacesOnly(@Nullable TreeElement node) {
        if (node == null) {
            return false;
        }
        if (FormatterUtil.isWhitespaceOrEmpty(node)) {
            return true;
        }
        PsiElement psi = node.getPsi();
        if (psi == null) {
            return false;
        }
        Language language = psi.getLanguage();
        return WhiteSpaceFormattingStrategyFactory.getStrategy(language).containsWhitespacesOnly(node);
    }

    public static void replaceInnerWhiteSpace(@NotNull String newWhiteSpaceText, @NotNull ASTNode holder, @NotNull TextRange whiteSpaceRange) {
        if (newWhiteSpaceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newWhiteSpaceText", "com/intellij/psi/formatter/FormatterUtil", "replaceInnerWhiteSpace"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/formatter/FormatterUtil", "replaceInnerWhiteSpace"));
        }
        if (whiteSpaceRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whiteSpaceRange", "com/intellij/psi/formatter/FormatterUtil", "replaceInnerWhiteSpace"));
        }
        CharTable charTable = SharedImplUtil.findCharTableByTree(holder);
        StringBuilder newText = FormatterUtil.createNewLeafChars(holder, whiteSpaceRange, newWhiteSpaceText);
        LeafElement newElement = Factory.createSingleLeafElement(holder.getElementType(), newText, charTable, holder.getPsi().getManager());
        holder.getTreeParent().replaceChild(holder, (ASTNode)newElement);
    }

    public static void replaceWhiteSpace(String whiteSpace, ASTNode leafElement, IElementType whiteSpaceToken, @Nullable TextRange textRange) {
        CharTable charTable = SharedImplUtil.findCharTableByTree(leafElement);
        ASTNode treePrev = FormatterUtil.findPreviousWhiteSpace(leafElement, whiteSpaceToken);
        if (treePrev == null) {
            treePrev = FormatterUtil.getWsCandidate(leafElement);
        }
        if (treePrev != null && treePrev.getText().trim().isEmpty() && treePrev.getElementType() != whiteSpaceToken && treePrev.getTextLength() > 0 && !whiteSpace.isEmpty()) {
            LeafElement whiteSpaceElement = Factory.createSingleLeafElement(treePrev.getElementType(), whiteSpace, charTable, SharedImplUtil.getManagerByTree(leafElement));
            ASTNode treeParent = treePrev.getTreeParent();
            treeParent.replaceChild(treePrev, (ASTNode)whiteSpaceElement);
        } else {
            LeafElement whiteSpaceElement = Factory.createSingleLeafElement(whiteSpaceToken, whiteSpace, charTable, SharedImplUtil.getManagerByTree(leafElement));
            if (treePrev == null) {
                if (!whiteSpace.isEmpty()) {
                    FormatterUtil.addWhiteSpace(leafElement, whiteSpaceElement);
                }
            } else if (treePrev.getElementType() != whiteSpaceToken) {
                if (!whiteSpace.isEmpty()) {
                    FormatterUtil.addWhiteSpace(treePrev, whiteSpaceElement);
                }
            } else if (treePrev.getElementType() == whiteSpaceToken) {
                CompositeElement treeParent = (CompositeElement)treePrev.getTreeParent();
                if (!whiteSpace.isEmpty()) {
                    treeParent.replaceChild(treePrev, whiteSpaceElement);
                } else {
                    treeParent.removeChild(treePrev);
                }
                ASTNode removeCandidate = FormatterUtil.findPreviousWhiteSpace(whiteSpaceElement, whiteSpaceToken);
                while (textRange != null && removeCandidate != null && removeCandidate.getStartOffset() >= textRange.getStartOffset()) {
                    treePrev = FormatterUtil.findPreviousWhiteSpace(removeCandidate, whiteSpaceToken);
                    removeCandidate.getTreeParent().removeChild(removeCandidate);
                    removeCandidate = treePrev;
                }
            }
        }
    }

    @Nullable
    private static ASTNode findPreviousWhiteSpace(ASTNode leafElement, IElementType whiteSpaceTokenType) {
        int offset = leafElement.getTextRange().getStartOffset() - 1;
        if (offset < 0) {
            return null;
        }
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(leafElement);
        if (psiElement == null) {
            return null;
        }
        PsiElement found = psiElement.getContainingFile().findElementAt(offset);
        if (found == null) {
            return null;
        }
        ASTNode treeElement = found.getNode();
        if (treeElement != null && treeElement.getElementType() == whiteSpaceTokenType) {
            return treeElement;
        }
        return null;
    }

    @Nullable
    private static ASTNode getWsCandidate(@Nullable ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode treePrev = node.getTreePrev();
        if (treePrev != null) {
            if (treePrev.getElementType() == TokenType.WHITE_SPACE) {
                return treePrev;
            }
            if (treePrev.getTextLength() == 0 && FormatterUtil.isSpaceBeforeEmptyElement(treePrev)) {
                return FormatterUtil.getWsCandidate(treePrev);
            }
            return node;
        }
        ASTNode treeParent = node.getTreeParent();
        if (treeParent == null || treeParent.getTreeParent() == null) {
            return node;
        }
        return FormatterUtil.getWsCandidate(treeParent);
    }

    private static boolean isSpaceBeforeEmptyElement(ASTNode node) {
        if (node.getElementType().isLeftBound()) {
            ASTNode parent = node.getTreeParent();
            return parent != null && parent.getFirstChildNode() == node;
        }
        return true;
    }

    private static StringBuilder createNewLeafChars(ASTNode leafElement, TextRange textRange, String whiteSpace) {
        TextRange elementRange = leafElement.getTextRange();
        String elementText = leafElement.getText();
        StringBuilder result2 = new StringBuilder();
        if (elementRange.getStartOffset() < textRange.getStartOffset()) {
            result2.append(elementText.substring(0, textRange.getStartOffset() - elementRange.getStartOffset()));
        }
        result2.append(whiteSpace);
        if (elementRange.getEndOffset() > textRange.getEndOffset()) {
            result2.append(elementText.substring(textRange.getEndOffset() - elementRange.getStartOffset()));
        }
        return result2;
    }

    private static void addWhiteSpace(ASTNode treePrev, LeafElement whiteSpaceElement) {
        for (WhiteSpaceFormattingStrategy strategy : WhiteSpaceFormattingStrategyFactory.getAllStrategies()) {
            if (!strategy.addWhitespace(treePrev, whiteSpaceElement)) continue;
            return;
        }
        ASTNode treeParent = treePrev.getTreeParent();
        treeParent.addChild((ASTNode)whiteSpaceElement, treePrev);
    }

    public static void replaceLastWhiteSpace(ASTNode astNode, String whiteSpace, TextRange textRange) {
        ASTNode lastWS = TreeUtil.findLastLeaf(astNode);
        if (lastWS == null) {
            return;
        }
        if (lastWS.getElementType() != TokenType.WHITE_SPACE) {
            lastWS = null;
        }
        if (lastWS != null && !lastWS.getTextRange().equals((Object)textRange)) {
            return;
        }
        if (whiteSpace.isEmpty() && lastWS == null) {
            return;
        }
        if (lastWS != null && whiteSpace.isEmpty()) {
            lastWS.getTreeParent().removeRange(lastWS, null);
            return;
        }
        LeafElement whiteSpaceElement = ASTFactory.whitespace(whiteSpace);
        if (lastWS == null) {
            astNode.addChild((ASTNode)whiteSpaceElement, null);
        } else {
            ASTNode treeParent = lastWS.getTreeParent();
            treeParent.replaceChild(lastWS, (ASTNode)whiteSpaceElement);
        }
    }

    public static boolean isFormatterCalledExplicitly() {
        return FORMATTER_ACTION_NAMES.contains(CommandProcessor.getInstance().getCurrentCommandName());
    }
}

