/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.AppTopics;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.EditorWindowImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.util.FileContentUtil;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDocumentManagerImpl
extends PsiDocumentManagerBase
implements SettingsSavingComponent {
    private final DocumentCommitProcessor myDocumentCommitThread;
    private final boolean myUnitTestMode;

    public PsiDocumentManagerImpl(final @NotNull Project project2, @NotNull PsiManager psiManager, @NotNull EditorFactory editorFactory, @NotNull MessageBus bus, final @NonNls @NotNull DocumentCommitProcessor documentCommitThread) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/PsiDocumentManagerImpl", "<init>"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/psi/impl/PsiDocumentManagerImpl", "<init>"));
        }
        if (editorFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorFactory", "com/intellij/psi/impl/PsiDocumentManagerImpl", "<init>"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/psi/impl/PsiDocumentManagerImpl", "<init>"));
        }
        if (documentCommitThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentCommitThread", "com/intellij/psi/impl/PsiDocumentManagerImpl", "<init>"));
        }
        super(project2, psiManager, bus, documentCommitThread);
        this.myUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myDocumentCommitThread = documentCommitThread;
        editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)this, (Disposable)project2);
        MessageBusConnection connection = bus.connect();
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentLoaded(@NotNull VirtualFile virtualFile, @NotNull Document document) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/PsiDocumentManagerImpl$1", "fileContentLoaded"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerImpl$1", "fileContentLoaded"));
                }
                PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
                    if (virtualFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/PsiDocumentManagerImpl$1", "lambda$fileContentLoaded$0"));
                    }
                    return PsiDocumentManagerImpl.this.myProject.isDisposed() || !virtualFile.isValid() ? null : PsiDocumentManagerImpl.this.getCachedPsiFile(virtualFile);
                });
                PsiDocumentManagerImpl.this.fireDocumentCreated(document, psiFile);
            }
        });
        connection.subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateFinished(@NotNull Document doc) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerImpl$2", "updateFinished"));
                }
                documentCommitThread.commitAsynchronously(project2, doc, "Bulk update finished", TransactionGuard.getInstance().getContextTransaction());
            }
        });
        Disposer.register((Disposable)project2, () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/PsiDocumentManagerImpl", "lambda$new$0"));
            }
            ((DocumentCommitThread)this.myDocumentCommitThread).cancelTasksOnProjectDispose(project2);
        });
    }

    @Override
    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        Collection projects;
        VirtualFile virtualFile;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerImpl", "getPsiFile"));
        }
        PsiFile psiFile = super.getPsiFile(document);
        if (this.myUnitTestMode && (virtualFile = FileDocumentManager.getInstance().getFile(document)) != null && virtualFile.isValid() && !(projects = ProjectLocator.getInstance().getProjectsForFile(virtualFile)).isEmpty() && !projects.contains(this.myProject)) {
            LOG.error("Trying to get PSI for an alien project. VirtualFile=" + virtualFile + ";\n myProject=" + this.myProject + ";\n projects returned: " + projects);
        }
        return psiFile;
    }

    @Override
    public void documentChanged(DocumentEvent event) {
        super.documentChanged(event);
        if (this.isUncommited(event.getDocument()) && FileDocumentManagerImpl.areTooManyDocumentsInTheQueue(this.myUncommittedDocuments)) {
            if (this.myUnitTestMode) {
                this.myStopTrackingDocuments = true;
                try {
                    LOG.error("Too many uncommitted documents for " + this.myProject + "(" + this.myUncommittedDocuments.size() + "):\n" + StringUtil.join((Iterable)this.myUncommittedDocuments, (String)"\n") + "\n\n Project creation trace: " + (String)this.myProject.getUserData(ProjectImpl.CREATION_TRACE));
                }
                finally {
                    this.clearUncommittedDocuments();
                }
            }
            if (PomModelImpl.isAllowPsiModification() && ApplicationManager.getApplication().isWriteAccessAllowed()) {
                this.commitAllDocuments();
            }
        }
    }

    @Override
    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/PsiDocumentManagerImpl", "beforeDocumentChangeOnUnlockedDocument"));
        }
        PostprocessReformattingAspect.getInstance(this.myProject).assertDocumentChangeIsAllowed(viewProvider);
        super.beforeDocumentChangeOnUnlockedDocument(viewProvider);
    }

    @Override
    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<Processor<Document>> finishProcessors, boolean synchronously) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerImpl", "finishCommitInWriteAction"));
        }
        if (finishProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishProcessors", "com/intellij/psi/impl/PsiDocumentManagerImpl", "finishCommitInWriteAction"));
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            EditorWindowImpl.disposeInvalidEditors();
        }
        return super.finishCommitInWriteAction(document, finishProcessors, synchronously);
    }

    @Override
    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerImpl", "isDocumentBlockedByPsi"));
        }
        FileViewProvider viewProvider = this.getCachedViewProvider(doc);
        return viewProvider != null && PostprocessReformattingAspect.getInstance(this.myProject).isViewProviderLocked(viewProvider);
    }

    @Override
    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/psi/impl/PsiDocumentManagerImpl", "doPostponedOperationsAndUnblockDocument"));
        }
        if (doc instanceof DocumentWindow) {
            doc = ((DocumentWindow)doc).getDelegate();
        }
        PostprocessReformattingAspect component = (PostprocessReformattingAspect)this.myProject.getComponent(PostprocessReformattingAspect.class);
        FileViewProvider viewProvider = this.getCachedViewProvider(doc);
        if (viewProvider != null && component != null) {
            component.doPostponedFormatting(viewProvider);
        }
    }

    public void save() {
        try {
            this.commitAllDocuments();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void clearUncommittedDocuments() {
        super.clearUncommittedDocuments();
        ((DocumentCommitThread)this.myDocumentCommitThread).clearQueue();
    }

    @NonNls
    public String toString() {
        return super.toString() + " for the project " + this.myProject + ".";
    }

    @Override
    public void reparseFiles(@NotNull Collection<VirtualFile> files, boolean includeOpenFiles) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/psi/impl/PsiDocumentManagerImpl", "reparseFiles"));
        }
        FileContentUtil.reparseFiles((Project)this.myProject, files, (boolean)includeOpenFiles);
    }

    @Override
    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/PsiDocumentManagerImpl", "freezeWindow"));
        }
        DocumentWindow documentWindow = MultiHostRegistrarImpl.freezeWindow((DocumentWindowImpl)document);
        if (documentWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerImpl", "freezeWindow"));
        }
        return documentWindow;
    }
}

