/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.beanProperties;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateJavaBeanPropertyFix
implements LocalQuickFix,
IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.beanProperties.CreateJavaBeanPropertyFix");
    protected final String myPropertyName;
    @NotNull
    protected final SmartPsiElementPointer<PsiClass> myPsiClass;
    @NotNull
    protected final PsiType myType;
    private final boolean myGetter;
    private final boolean mySetter;
    private final boolean myField;

    public CreateJavaBeanPropertyFix(@NotNull PsiClass psiClass, @NotNull String propertyName, @NotNull PsiType propertyType, boolean getterRequired, boolean setterRequired, boolean fieldRequired) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "<init>"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "<init>"));
        }
        if (propertyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyType", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "<init>"));
        }
        this.myPropertyName = propertyName;
        this.myPsiClass = SmartPointerManager.getInstance((Project)psiClass.getProject()).createSmartPsiElementPointer((PsiElement)psiClass);
        this.myType = propertyType;
        this.myGetter = getterRequired;
        this.mySetter = setterRequired;
        this.myField = fieldRequired;
    }

    @NotNull
    public String getName() {
        if (this.myGetter && this.mySetter && this.myField) {
            String string = QuickFixBundle.message("create.readable.writable.property.with.field", this.myPropertyName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "getName"));
            }
            return string;
        }
        if (this.myField && this.myGetter) {
            String string = QuickFixBundle.message("create.readable.property.with.field", this.myPropertyName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "getName"));
            }
            return string;
        }
        if (this.myField && this.mySetter) {
            String string = QuickFixBundle.message("create.writable.property.with.field", this.myPropertyName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "getName"));
            }
            return string;
        }
        if (!this.myField && this.myGetter) {
            String string = QuickFixBundle.message("create.readable.property", this.myPropertyName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "getName"));
            }
            return string;
        }
        if (!this.myField && this.mySetter) {
            String string = QuickFixBundle.message("create.writable.property", this.myPropertyName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "getName"));
            }
            return string;
        }
        String string = QuickFixBundle.message("create.readable.writable.property.with.field", this.myPropertyName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "getName"));
        }
        return string;
    }

    protected void doFix() throws IncorrectOperationException {
        if (this.myField) {
            this.createField();
        }
        if (this.mySetter) {
            this.createSetter(this.myField);
        }
        if (this.myGetter) {
            this.createGetter(this.myField);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "applyFix"));
        }
        this.applyFix(project2);
    }

    private void applyFix(Project project2) {
        new WriteCommandAction.Simple(project2, this.getName(), new PsiFile[]{this.myPsiClass.getContainingFile()}){

            protected void run() throws Throwable {
                try {
                    CreateJavaBeanPropertyFix.this.doFix();
                }
                catch (IncorrectOperationException e) {
                    LOG.error("Cannot create property", (Throwable)e);
                }
            }
        }.execute();
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/beanProperties/CreateJavaBeanPropertyFix", "invoke"));
        }
        this.applyFix(project2);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private String getFieldName() {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myPsiClass.getProject());
        return styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, (String)this.myPropertyName, null, (PsiType)this.myType).names[0];
    }

    private void createSetter(boolean createField) throws IncorrectOperationException {
        String text2;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory();
        String methodName = PropertyUtil.suggestSetterName((String)this.myPropertyName);
        String typeName = this.myType.getCanonicalText();
        PsiClass psiClass = (PsiClass)this.myPsiClass.getElement();
        if (psiClass == null) {
            return;
        }
        boolean isInterface = psiClass.isInterface();
        if (isInterface) {
            text2 = "public void " + methodName + "(" + typeName + " " + this.myPropertyName + ");";
        } else if (createField) {
            String fieldName = this.getFieldName();
            if (fieldName.equals(this.myPropertyName)) {
                fieldName = "this." + fieldName;
            }
            text2 = "public void " + methodName + "(" + typeName + " " + this.myPropertyName + ") {" + fieldName + "=" + this.myPropertyName + ";}";
        } else {
            text2 = "public void " + methodName + "(" + typeName + " " + this.myPropertyName + ") {}";
        }
        PsiMethod method = elementFactory.createMethodFromText(text2, null);
        PsiMethod psiElement = (PsiMethod)psiClass.add((PsiElement)method);
        if (!isInterface && !createField) {
            CreateFromUsageUtils.setupMethodBody(psiElement, psiClass);
        }
    }

    private void createGetter(boolean createField) throws IncorrectOperationException {
        String text2;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory();
        String methodName = PropertyUtil.suggestGetterName((String)this.myPropertyName, (PsiType)this.myType);
        String typeName = this.myType.getCanonicalText();
        PsiClass psiClass = (PsiClass)this.myPsiClass.getElement();
        if (psiClass == null) {
            return;
        }
        boolean isInterface = psiClass.isInterface();
        if (createField) {
            String fieldName = this.getFieldName();
            text2 = "public " + typeName + " " + methodName + "() { return " + fieldName + "; }";
        } else {
            text2 = isInterface ? typeName + " " + methodName + "();" : "public " + typeName + " " + methodName + "() { return null; }";
        }
        PsiMethod method = elementFactory.createMethodFromText(text2, null);
        PsiMethod psiElement = (PsiMethod)psiClass.add((PsiElement)method);
        if (!createField && !isInterface) {
            CreateFromUsageUtils.setupMethodBody(psiElement);
        }
    }

    private void createField() throws IncorrectOperationException {
        String fieldName = this.getFieldName();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory();
        PsiField psiField = elementFactory.createField(fieldName, this.myType);
        PsiClass psiClass = (PsiClass)this.myPsiClass.getElement();
        if (psiClass == null) {
            return;
        }
        psiClass.add((PsiElement)psiField);
    }
}

