/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.util.ArrayUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartIntToIntArrayMap {
    @Nullable
    TIntObjectHashMap<TIntArrayList> myMultipleValuesMap;
    TIntIntHashMap mySingleValueMap = new TIntIntHashMap(10, 0.9f);

    @NotNull
    public int[] keys() {
        int[] multiKeys = this.myMultipleValuesMap != null ? this.myMultipleValuesMap.keys() : ArrayUtil.EMPTY_INT_ARRAY;
        int[] singleKeys = this.mySingleValueMap.keys();
        if (singleKeys.length == 0) {
            if (multiKeys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/SmartIntToIntArrayMap", "keys"));
            }
            return multiKeys;
        }
        int[] combinedKeys = new int[multiKeys.length + singleKeys.length];
        System.arraycopy(multiKeys, 0, combinedKeys, 0, multiKeys.length);
        System.arraycopy(singleKeys, 0, combinedKeys, multiKeys.length, singleKeys.length);
        if (combinedKeys == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/SmartIntToIntArrayMap", "keys"));
        }
        return combinedKeys;
    }

    public void addOccurence(int key2, int value2) {
        if (this.myMultipleValuesMap != null && this.myMultipleValuesMap.containsKey(key2)) {
            this.addToMultimap(key2, value2);
        } else if (this.mySingleValueMap.containsKey(key2)) {
            int storedId = this.mySingleValueMap.get(key2);
            if (storedId == value2) {
                return;
            }
            this.mySingleValueMap.remove(key2);
            this.addToMultimap(key2, storedId);
            this.addToMultimap(key2, value2);
        } else {
            this.mySingleValueMap.put(key2, value2);
        }
    }

    private void addToMultimap(int key2, int value2) {
        TIntObjectHashMap<TIntArrayList> map2;
        TIntArrayList list2;
        if (this.myMultipleValuesMap == null) {
            this.myMultipleValuesMap = new TIntObjectHashMap(10, 0.9f);
        }
        if ((list2 = (TIntArrayList)(map2 = this.myMultipleValuesMap).get(key2)) == null) {
            list2 = new TIntArrayList(3);
            map2.put(key2, (Object)list2);
        }
        if (!list2.contains(value2)) {
            list2.add(value2);
        }
    }

    public void removeOccurence(int key2, int value2) {
        if (this.mySingleValueMap.containsKey(key2)) {
            this.mySingleValueMap.remove(key2);
        } else {
            this.removeFromMultiMap(key2, value2);
        }
    }

    private void removeFromMultiMap(int key2, int value2) {
        int offset;
        TIntObjectHashMap<TIntArrayList> map2 = this.myMultipleValuesMap;
        if (map2 == null) {
            return;
        }
        TIntArrayList list2 = (TIntArrayList)map2.get(key2);
        if (list2 != null && (offset = list2.indexOf(value2)) != -1) {
            list2.remove(offset);
            if (list2.isEmpty()) {
                map2.remove(key2);
            }
        }
    }

    @NotNull
    public int[] get(int key2) {
        if (this.mySingleValueMap.containsKey(key2)) {
            int id = this.mySingleValueMap.get(key2);
            int[] nArray = new int[]{id};
            if (nArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/SmartIntToIntArrayMap", "get"));
            }
            return nArray;
        }
        int[] nArray = this.getFromMultimap(key2);
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/SmartIntToIntArrayMap", "get"));
        }
        return nArray;
    }

    @NotNull
    private int[] getFromMultimap(int key2) {
        TIntArrayList res;
        TIntArrayList tIntArrayList = res = this.myMultipleValuesMap != null ? (TIntArrayList)this.myMultipleValuesMap.get(key2) : null;
        if (res == null) {
            if (ArrayUtil.EMPTY_INT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/SmartIntToIntArrayMap", "getFromMultimap"));
            }
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        int[] nArray = res.toNativeArray();
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/SmartIntToIntArrayMap", "getFromMultimap"));
        }
        return nArray;
    }
}

