/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class IndexPatternUtil {
    @NotNull
    public static IndexPatternProvider[] getIndexPatternProviders() {
        IndexPatternProvider[] indexPatternProviderArray = (IndexPatternProvider[])Extensions.getExtensions((ExtensionPointName)IndexPatternProvider.EP_NAME);
        if (indexPatternProviderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/IndexPatternUtil", "getIndexPatternProviders"));
        }
        return indexPatternProviderArray;
    }

    public static int getIndexPatternCount() {
        return Arrays.stream(IndexPatternUtil.getIndexPatternProviders()).mapToInt(provider -> provider.getIndexPatterns().length).sum();
    }

    @NotNull
    public static IndexPattern[] getIndexPatterns() {
        IndexPattern[] result2 = new IndexPattern[IndexPatternUtil.getIndexPatternCount()];
        int destIndex = 0;
        for (IndexPatternProvider provider : IndexPatternUtil.getIndexPatternProviders()) {
            for (IndexPattern pattern : provider.getIndexPatterns()) {
                result2[destIndex++] = pattern;
            }
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/IndexPatternUtil", "getIndexPatterns"));
        }
        return result2;
    }
}

