/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsEnumConstantImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsMemberImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.MethodsProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsClassImpl
extends ClsMemberImpl<PsiClassStub<?>>
implements PsiExtensibleClass,
PsiQualifiedNamedElement,
Queryable {
    public static final Key<PsiClass> DELEGATE_KEY = Key.create((String)"DELEGATE");
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache(this);

    public ClsClassImpl(PsiClassStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        ArrayList children2 = ContainerUtil.newArrayList();
        ContainerUtil.addAll((Collection)children2, (Object[])this.getChildren(new PsiElement[]{this.getDocComment(), this.getModifierList(), this.getNameIdentifier(), this.getExtendsList(), this.getImplementsList()}));
        ContainerUtil.addAll((Collection)children2, this.getOwnFields());
        ContainerUtil.addAll((Collection)children2, this.getOwnMethods());
        ContainerUtil.addAll((Collection)children2, this.getOwnInnerClasses());
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)children2);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @NotNull
    public PsiTypeParameterList getTypeParameterList() {
        PsiTypeParameterList psiTypeParameterList = (PsiTypeParameterList)((PsiClassStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.TYPE_PARAMETER_LIST).getPsi();
        if (psiTypeParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getTypeParameterList"));
        }
        return psiTypeParameterList;
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    @NotNull
    public String getQualifiedName() {
        String string = ((PsiClassStub)this.getStub()).getQualifiedName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = (PsiModifierList)((PsiClassStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST).getPsi();
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getModifierList"));
        }
        return psiModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/compiled/ClsClassImpl", "hasModifierProperty"));
        }
        return this.getModifierList().hasModifierProperty(name2);
    }

    @NotNull
    public PsiReferenceList getExtendsList() {
        PsiReferenceList psiReferenceList = (PsiReferenceList)((PsiClassStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.EXTENDS_LIST).getPsi();
        if (psiReferenceList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getExtendsList"));
        }
        return psiReferenceList;
    }

    @NotNull
    public PsiReferenceList getImplementsList() {
        PsiReferenceList psiReferenceList = (PsiReferenceList)((PsiClassStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.IMPLEMENTS_LIST).getPsi();
        if (psiReferenceList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getImplementsList"));
        }
        return psiReferenceList;
    }

    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getExtendsListTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getExtendsListTypes"));
        }
        return psiClassTypeArray;
    }

    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getImplementsListTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getImplementsListTypes"));
        }
        return psiClassTypeArray;
    }

    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass(this);
    }

    @NotNull
    public PsiClass[] getInterfaces() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getInterfaces(this);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getInterfaces"));
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClass[] getSupers() {
        if ("java.lang.Object".equals(this.getQualifiedName())) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getSupers"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = PsiClassImplUtil.getSupers(this);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getSupers"));
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClassType[] getSuperTypes() {
        if ("java.lang.Object".equals(this.getQualifiedName())) {
            if (PsiClassType.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getSuperTypes"));
            }
            return PsiClassType.EMPTY_ARRAY;
        }
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getSuperTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getSuperTypes"));
        }
        return psiClassTypeArray;
    }

    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Collection<HierarchicalMethodSignature> collection = PsiSuperMethodImplUtil.getVisibleSignatures(this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getVisibleSignatures"));
        }
        return collection;
    }

    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = this.myInnersCache.getFields();
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getConstructors();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getConstructors"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = this.myInnersCache.getInnerClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getInnerClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public List<PsiField> getOwnFields() {
        List<PsiElement> list2 = Arrays.asList(((PsiClassStub)this.getStub()).getChildrenByType(Constants.FIELD_BIT_SET, PsiField.ARRAY_FACTORY));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getOwnFields"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List<PsiElement> list2 = Arrays.asList(((PsiClassStub)this.getStub()).getChildrenByType(Constants.METHOD_BIT_SET, PsiMethod.ARRAY_FACTORY));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getOwnMethods"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        List<PsiElement> list2 = Arrays.asList(((PsiClassStub)this.getStub()).getChildrenByType((IElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getOwnInnerClasses"));
        }
        return list2;
    }

    @NotNull
    public PsiClassInitializer[] getInitializers() {
        if (PsiClassInitializer.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getInitializers"));
        }
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getTypeParameters"));
        }
        return psiTypeParameterArray;
    }

    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getAllFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses(this);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    public PsiField findFieldByName(String name2, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name2, checkBases);
    }

    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "findMethodsBySignature"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name2, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.myInnersCache.findMethodsByName(name2, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name2, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> list2 = PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name2, checkBases);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "findMethodsAndTheirSubstitutorsByName"));
        }
        return list2;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List<Pair<PsiMethod, PsiSubstitutor>> list2 = PsiClassImplUtil.getAllWithSubstitutorsByMap(this, PsiClassImplUtil.MemberType.METHOD);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getAllMethodsAndTheirSubstitutors"));
        }
        return list2;
    }

    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name2, checkBases);
    }

    public boolean isDeprecated() {
        return ((PsiClassStub)this.getStub()).isDeprecated() || PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public String getSourceFileName() {
        String sfn = ((PsiClassStub)this.getStub()).getSourceFileName();
        return sfn != null ? sfn : this.obtainSourceFileNameFromClassFileName();
    }

    @NonNls
    private String obtainSourceFileNameFromClassFileName() {
        String name2 = this.getContainingFile().getName();
        int i = name2.indexOf(36);
        if (i < 0 && (i = name2.indexOf(46)) < 0) {
            i = name2.length();
        }
        return name2.substring(0, i) + ".java";
    }

    public PsiJavaToken getLBrace() {
        return null;
    }

    public PsiJavaToken getRBrace() {
        return null;
    }

    public boolean isInterface() {
        return ((PsiClassStub)this.getStub()).isInterface();
    }

    public boolean isAnnotationType() {
        return ((PsiClassStub)this.getStub()).isAnnotationType();
    }

    public boolean isEnum() {
        return ((PsiClassStub)this.getStub()).isEnum();
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull @NonNls StringBuilder buffer) {
        int i;
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsClassImpl", "appendMirrorText"));
        }
        ClsClassImpl.appendText((PsiElement)this.getDocComment(), indentLevel, buffer, "go_to_next_line_and_indent");
        ClsClassImpl.appendText((PsiElement)this.getModifierList(), indentLevel, buffer);
        buffer.append(this.isEnum() ? "enum " : (this.isAnnotationType() ? "@interface " : (this.isInterface() ? "interface " : "class ")));
        ClsClassImpl.appendText((PsiElement)this.getNameIdentifier(), indentLevel, buffer, " ");
        ClsClassImpl.appendText((PsiElement)this.getTypeParameterList(), indentLevel, buffer, " ");
        ClsClassImpl.appendText((PsiElement)this.getExtendsList(), indentLevel, buffer, " ");
        ClsClassImpl.appendText((PsiElement)this.getImplementsList(), indentLevel, buffer, " ");
        buffer.append('{');
        int newIndentLevel = indentLevel + this.getIndentSize();
        List<PsiField> fields = this.getOwnFields();
        List<PsiMethod> methods = this.getOwnMethods();
        List<PsiClass> classes2 = this.getOwnInnerClasses();
        if (!fields.isEmpty()) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (i = 0; i < fields.size(); ++i) {
                PsiField field = fields.get(i);
                ClsClassImpl.appendText((PsiElement)field, newIndentLevel, buffer);
                if (field instanceof ClsEnumConstantImpl) {
                    if (i < fields.size() - 1 && fields.get(i + 1) instanceof ClsEnumConstantImpl) {
                        buffer.append(", ");
                        continue;
                    }
                    buffer.append(';');
                    if (i >= fields.size() - 1) continue;
                    buffer.append('\n');
                    ClsClassImpl.goNextLine(newIndentLevel, buffer);
                    continue;
                }
                if (i >= fields.size() - 1) continue;
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        } else if (this.isEnum() && methods.size() + classes2.size() > 0) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            buffer.append(";");
        }
        if (!methods.isEmpty()) {
            if (this.isEnum() || !fields.isEmpty()) {
                buffer.append('\n');
            }
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (i = 0; i < methods.size(); ++i) {
                ClsClassImpl.appendText((PsiElement)methods.get(i), newIndentLevel, buffer);
                if (i >= methods.size() - 1) continue;
                buffer.append('\n');
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        if (!classes2.isEmpty()) {
            if (fields.size() + methods.size() > 0) {
                buffer.append('\n');
            }
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (i = 0; i < classes2.size(); ++i) {
                ClsClassImpl.appendText((PsiElement)classes2.get(i), newIndentLevel, buffer);
                if (i >= classes2.size() - 1) continue;
                buffer.append('\n');
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        ClsClassImpl.goNextLine(indentLevel, buffer);
        buffer.append('}');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsClassImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, null);
        PsiClass mirror = (PsiClass)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsClassImpl.setMirrorIfPresent(this.getDocComment(), mirror.getDocComment());
        ClsClassImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsClassImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
        ClsClassImpl.setMirror(this.getTypeParameterList(), mirror.getTypeParameterList());
        ClsClassImpl.setMirror(this.getExtendsList(), mirror.getExtendsList());
        ClsClassImpl.setMirror(this.getImplementsList(), mirror.getImplementsList());
        if (mirror instanceof PsiExtensibleClass) {
            PsiExtensibleClass extMirror = (PsiExtensibleClass)mirror;
            ClsClassImpl.setMirrors(this.getOwnFields(), extMirror.getOwnFields());
            ClsClassImpl.setMirrors(this.getOwnMethods(), extMirror.getOwnMethods());
            ClsClassImpl.setMirrors(this.getOwnInnerClasses(), extMirror.getOwnInnerClasses());
        } else {
            ClsClassImpl.setMirrors(this.getOwnFields(), Arrays.asList(mirror.getFields()));
            ClsClassImpl.setMirrors(this.getOwnMethods(), Arrays.asList(mirror.getMethods()));
            ClsClassImpl.setMirrors(this.getOwnInnerClasses(), Arrays.asList(mirror.getInnerClasses()));
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/compiled/ClsClassImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClass((PsiClass)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NonNls
    public String toString() {
        return "PsiClass:" + this.getName();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/compiled/ClsClassImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/compiled/ClsClassImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/compiled/ClsClassImpl", "processDeclarations"));
        }
        if (this.isEnum() && !PsiClassImplUtil.processDeclarationsInEnum(processor2, state, this.myInnersCache)) {
            return false;
        }
        LanguageLevel level = processor2 instanceof MethodsProcessor ? ((MethodsProcessor)processor2).getLanguageLevel() : PsiUtil.getLanguageLevel((PsiElement)place);
        return PsiClassImplUtil.processDeclarationsInClass(this, processor2, state, null, lastParent, place, level, false);
    }

    public PsiElement getScope() {
        return this.getParent();
    }

    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep(this, baseClass, classToByPass);
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/compiled/ClsClassImpl", "isInheritor"));
        }
        return InheritanceImplUtil.isInheritor(this, baseClass, checkDeep);
    }

    @Nullable
    public PsiClass getSourceMirrorClass() {
        PsiClass delegate = (PsiClass)this.getUserData(DELEGATE_KEY);
        if (delegate instanceof ClsClassImpl) {
            return ((ClsClassImpl)delegate).getSourceMirrorClass();
        }
        String name2 = this.getName();
        PsiElement parent = this.getParent();
        if (parent instanceof PsiFile) {
            if (!(parent instanceof PsiClassOwner)) {
                return null;
            }
            PsiClassOwner fileNavigationElement = (PsiClassOwner)parent.getNavigationElement();
            if (fileNavigationElement == parent) {
                return null;
            }
            for (PsiClass aClass : fileNavigationElement.getClasses()) {
                if (!name2.equals(aClass.getName())) continue;
                return aClass;
            }
        } else if (parent != null) {
            PsiClass[] innerClasses;
            ClsClassImpl parentClass = (ClsClassImpl)parent;
            PsiClass parentSourceMirror = parentClass.getSourceMirrorClass();
            if (parentSourceMirror == null) {
                return null;
            }
            for (PsiClass innerClass : innerClasses = parentSourceMirror.getInnerClasses()) {
                if (!name2.equals(innerClass.getName())) continue;
                return innerClass;
            }
        } else {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        block11: {
            PsiElement psiElement;
            block10: {
                for (ClsCustomNavigationPolicy customNavigationPolicy : (ClsCustomNavigationPolicy[])Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
                    PsiElement psiElement2;
                    try {
                        PsiElement navigationElement = customNavigationPolicy.getNavigationElement(this);
                        if (navigationElement == null) continue;
                        psiElement2 = navigationElement;
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                    if (psiElement2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getNavigationElement"));
                    }
                    return psiElement2;
                }
                PsiClass aClass = this.getSourceMirrorClass();
                if (aClass == null) break block10;
                PsiElement psiElement3 = aClass.getNavigationElement();
                if (psiElement3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getNavigationElement"));
                }
                return psiElement3;
            }
            try {
                PsiElement sourceFile;
                PsiElement parent;
                if (!"package-info".equals(this.getName()) || !((parent = this.getParent()) instanceof ClsFileImpl) || !((sourceFile = parent.getNavigationElement()) instanceof PsiJavaFile)) break block11;
                psiElement = sourceFile;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getNavigationElement"));
            }
            return psiElement;
        }
        ClsClassImpl clsClassImpl = this;
        if (clsClassImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getNavigationElement"));
        }
        return clsClassImpl;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public Icon getElementIcon(int flags) {
        return PsiClassImplUtil.getClassIcon(flags, this);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiClassImplUtil.getClassUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsClassImpl", "getUseScope"));
        }
        return searchScope;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/impl/compiled/ClsClassImpl", "putInfo"));
        }
        PsiClassImpl.putInfo(this, info);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }
}

