/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaModuleReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsJavaModuleImpl
extends ClsRepositoryPsiElement<PsiJavaModuleStub>
implements PsiJavaModule {
    private final PsiJavaModuleReferenceElement myReference;

    public ClsJavaModuleImpl(PsiJavaModuleStub stub) {
        super(stub);
        this.myReference = new ClsJavaModuleReferenceElementImpl((PsiElement)this, stub.getName());
    }

    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        JBIterable jBIterable = JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.REQUIRES_STATEMENT, (PsiElement[])PsiRequiresStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getRequires"));
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        JBIterable jBIterable = JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.EXPORTS_STATEMENT, (PsiElement[])PsiPackageAccessibilityStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getExports"));
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        JBIterable jBIterable = JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.OPENS_STATEMENT, (PsiElement[])PsiPackageAccessibilityStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getOpens"));
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        JBIterable jBIterable = JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.USES_STATEMENT, (PsiElement[])PsiUsesStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getUses"));
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        JBIterable jBIterable = JBIterable.of((Object[])((PsiJavaModuleStub)this.getStub()).getChildrenByType(JavaElementType.PROVIDES_STATEMENT, (PsiElement[])PsiProvidesStatement.EMPTY_ARRAY));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getProvides"));
        }
        return jBIterable;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "appendMirrorText"));
        }
        ClsJavaModuleImpl.appendText((PsiElement)this.getModifierList(), indentLevel, buffer);
        buffer.append("module ").append(this.getName()).append(" {\n");
        int newIndentLevel = indentLevel + this.getIndentSize();
        int start = buffer.length();
        ClsJavaModuleImpl.appendChildren(this.getRequires(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getExports(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getOpens(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getUses(), buffer, newIndentLevel, start);
        ClsJavaModuleImpl.appendChildren(this.getProvides(), buffer, newIndentLevel, start);
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indentLevel);
        buffer.append('}');
    }

    private static void appendChildren(Iterable<? extends PsiElement> children2, StringBuilder buffer, int indentLevel, int start) {
        ArrayList statements = ContainerUtil.newArrayList(children2);
        if (!statements.isEmpty()) {
            if (buffer.length() > start) {
                buffer.append('\n');
            }
            for (PsiElement statement2 : statements) {
                ClsJavaModuleImpl.appendText(statement2, indentLevel, buffer);
            }
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaElementType.MODULE);
        PsiJavaModule mirror = (PsiJavaModule)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsJavaModuleImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
        ClsJavaModuleImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsJavaModuleImpl.setMirrors(this.getRequires(), mirror.getRequires());
        ClsJavaModuleImpl.setMirrors(this.getExports(), mirror.getExports());
        ClsJavaModuleImpl.setMirrors(this.getOpens(), mirror.getOpens());
        ClsJavaModuleImpl.setMirrors(this.getUses(), mirror.getUses());
        ClsJavaModuleImpl.setMirrors(this.getProvides(), mirror.getProvides());
    }

    private static <T extends PsiElement> void setMirrors(Iterable<T> stubs, Iterable<T> mirrors) {
        ClsJavaModuleImpl.setMirrors(ContainerUtil.newArrayList(stubs), ContainerUtil.newArrayList(mirrors));
    }

    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        PsiJavaModuleReferenceElement psiJavaModuleReferenceElement = this.myReference;
        if (psiJavaModuleReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getNameIdentifier"));
        }
        return psiJavaModuleReferenceElement;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myReference.getReferenceText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "setName"));
        }
        throw ClsJavaModuleImpl.cannotModifyException(this);
    }

    public PsiModifierList getModifierList() {
        StubElement childStub = ((PsiJavaModuleStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        return childStub != null ? (PsiModifierList)childStub.getPsi() : null;
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "hasModifierProperty"));
        }
        PsiModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(name2);
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiJavaModuleReferenceElement psiJavaModuleReferenceElement = this.getNameIdentifier();
        if (psiJavaModuleReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "getNavigationElement"));
        }
        return psiJavaModuleReferenceElement;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/compiled/ClsJavaModuleImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModule((PsiJavaModule)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }
}

