/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaModuleStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiModifierListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiPackageAccessibilityStatementStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiProvidesStatementStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiRequiresStatementStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiUsesStatementStubImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;

public class ModuleStubBuildingVisitor
extends ClassVisitor {
    private static final Function<String, String> NAME_MAPPER = name1 -> name1.replace('/', '.');
    private final PsiJavaFileStub myParent;
    private PsiJavaModuleStub myResult;
    private PsiModifierListStubImpl myModList;

    public ModuleStubBuildingVisitor(PsiJavaFileStub parent) {
        super(393216);
        this.myParent = parent;
    }

    public PsiJavaModuleStub getResult() {
        return this.myResult;
    }

    public ModuleVisitor visitModule(String name2, int access, String version) {
        this.myResult = new PsiJavaModuleStubImpl((StubElement)this.myParent, name2);
        this.myModList = new PsiModifierListStubImpl(this.myResult, ModuleStubBuildingVisitor.moduleFlags(access));
        return new ModuleVisitor(393216){

            public void visitRequire(String module2, int access, String version) {
                if (!ModuleStubBuildingVisitor.isGenerated(access)) {
                    PsiRequiresStatementStubImpl statementStub = new PsiRequiresStatementStubImpl(ModuleStubBuildingVisitor.this.myResult, module2);
                    new PsiModifierListStubImpl(statementStub, ModuleStubBuildingVisitor.requiresFlags(access));
                }
            }

            public void visitExport(String packageName, int access, String ... modules) {
                if (!ModuleStubBuildingVisitor.isGenerated(access)) {
                    new PsiPackageAccessibilityStatementStubImpl(ModuleStubBuildingVisitor.this.myResult, (IStubElementType)JavaStubElementTypes.EXPORTS_STATEMENT, (String)NAME_MAPPER.fun((Object)packageName), modules == null ? null : Arrays.asList(modules));
                }
            }

            public void visitOpen(String packageName, int access, String ... modules) {
                if (!ModuleStubBuildingVisitor.isGenerated(access)) {
                    new PsiPackageAccessibilityStatementStubImpl(ModuleStubBuildingVisitor.this.myResult, (IStubElementType)JavaStubElementTypes.OPENS_STATEMENT, (String)NAME_MAPPER.fun((Object)packageName), modules == null ? null : Arrays.asList(modules));
                }
            }

            public void visitUse(String service) {
                new PsiUsesStatementStubImpl(ModuleStubBuildingVisitor.this.myResult, (String)NAME_MAPPER.fun((Object)service));
            }

            public void visitProvide(String service, String ... providers2) {
                PsiProvidesStatementStubImpl statementStub = new PsiProvidesStatementStubImpl(ModuleStubBuildingVisitor.this.myResult, (String)NAME_MAPPER.fun((Object)service));
                new PsiClassReferenceListStubImpl(JavaStubElementTypes.PROVIDES_WITH_LIST, statementStub, (String[])ContainerUtil.map2Array((Object[])providers2, String.class, (Function)NAME_MAPPER));
            }
        };
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return StubBuildingVisitor.getAnnotationTextCollector(desc, (Consumer<String>)((Consumer)text2 -> new PsiAnnotationStubImpl(this.myModList, (String)text2)));
    }

    private static boolean isGenerated(int access) {
        return BitUtil.isSet((int)access, (int)4096) || BitUtil.isSet((int)access, (int)32768);
    }

    private static int moduleFlags(int access) {
        return BitUtil.isSet((int)access, (int)32) ? 8192 : 0;
    }

    private static int requiresFlags(int access) {
        int flags = 0;
        if (BitUtil.isSet((int)access, (int)32)) {
            flags |= 0x4000;
        }
        if (BitUtil.isSet((int)access, (int)64)) {
            flags |= 8;
        }
        return flags;
    }
}

