/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.codeInsight.completion.scope.JavaCompletionHints;
import com.intellij.core.CoreJavaDirectoryService;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.file.PsiPackageBase;
import com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPackageImpl
extends PsiPackageBase
implements PsiPackage,
Queryable {
    private static final Logger LOG = Logger.getInstance(PsiPackageImpl.class);
    private volatile CachedValue<PsiModifierList> myAnnotationList;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectories;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectoriesWithLibSources;
    private volatile SoftReference<Map<String, PsiClass[]>> myClassCache;
    private volatile SoftReference<Map<GlobalSearchScope, Map<String, PsiClass[]>>> myDumbModeFullCache;
    private volatile SoftReference<Map<Pair<GlobalSearchScope, String>, PsiClass[]>> myDumbModePartialCache;

    public PsiPackageImpl(PsiManager manager, String qualifiedName) {
        super(manager, qualifiedName);
    }

    @Override
    protected Collection<PsiDirectory> getAllDirectories(boolean includeLibrarySources) {
        if (includeLibrarySources) {
            if (this.myDirectoriesWithLibSources == null) {
                this.myDirectoriesWithLibSources = this.createCachedDirectories(true);
            }
            return (Collection)this.myDirectoriesWithLibSources.getValue();
        }
        if (this.myDirectories == null) {
            this.myDirectories = this.createCachedDirectories(false);
        }
        return (Collection)this.myDirectories.getValue();
    }

    @NotNull
    private CachedValue<Collection<PsiDirectory>> createCachedDirectories(boolean includeLibrarySources) {
        CachedValue cachedValue = CachedValuesManager.getManager((Project)this.myManager.getProject()).createCachedValue(() -> {
            ArrayList result2 = new ArrayList();
            Processor processor2 = Processors.cancelableCollectProcessor(result2);
            this.getFacade().processPackageDirectories(this, this.allScope(), (Processor<PsiDirectory>)processor2, includeLibrarySources);
            return CachedValueProvider.Result.create(result2, (Object[])PsiPackageImplementationHelper.getInstance().getDirectoryCachedValueDependencies(this));
        }, false);
        if (cachedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "createCachedDirectories"));
        }
        return cachedValue;
    }

    @Override
    protected PsiElement findPackage(String qName) {
        return this.getFacade().findPackage(qName);
    }

    public void handleQualifiedNameChange(@NotNull String newQualifiedName) {
        if (newQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newQualifiedName", "com/intellij/psi/impl/file/PsiPackageImpl", "handleQualifiedNameChange"));
        }
        PsiPackageImplementationHelper.getInstance().handleQualifiedNameChange(this, newQualifiedName);
    }

    @NotNull
    public VirtualFile[] occursInPackagePrefixes() {
        VirtualFile[] virtualFileArray = PsiPackageImplementationHelper.getInstance().occursInPackagePrefixes(this);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "occursInPackagePrefixes"));
        }
        return virtualFileArray;
    }

    @Override
    public PsiPackageImpl getParentPackage() {
        return (PsiPackageImpl)super.getParentPackage();
    }

    @Override
    protected PsiPackageImpl createInstance(PsiManager manager, String qName) {
        return new PsiPackageImpl(this.myManager, qName);
    }

    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getLanguage"));
        }
        return javaLanguage;
    }

    @Override
    public boolean isValid() {
        return !this.myManager.getProject().isDisposed() && (PsiPackageImplementationHelper.getInstance().packagePrefixExists(this) || !this.getAllDirectories(true).isEmpty());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/file/PsiPackageImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPackage((PsiPackage)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiPackage:" + this.getQualifiedName();
    }

    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getClasses(this.allScope());
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    protected GlobalSearchScope allScope() {
        GlobalSearchScope globalSearchScope = PsiPackageImplementationHelper.getInstance().adjustAllScope(this, GlobalSearchScope.allScope((Project)this.getProject()));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "allScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        PsiClass[] psiClassArray = this.getFacade().getClasses(this, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    public PsiFile[] getFiles(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/PsiPackageImpl", "getFiles"));
        }
        PsiFile[] psiFileArray = this.getFacade().getPackageFiles(this, scope);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getFiles"));
        }
        return psiFileArray;
    }

    @Nullable
    public PsiModifierList getAnnotationList() {
        if (this.myAnnotationList == null) {
            this.myAnnotationList = CachedValuesManager.getManager((Project)this.myManager.getProject()).createCachedValue((CachedValueProvider)new PackageAnnotationValueProvider(), false);
        }
        return (PsiModifierList)this.myAnnotationList.getValue();
    }

    @NotNull
    public PsiPackage[] getSubPackages() {
        PsiPackage[] psiPackageArray = this.getSubPackages(this.allScope());
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        PsiPackage[] psiPackageArray = this.getFacade().getSubPackages(this, scope);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    private JavaPsiFacadeImpl getFacade() {
        return (JavaPsiFacadeImpl)JavaPsiFacade.getInstance((Project)this.myManager.getProject());
    }

    @NotNull
    private PsiClass[] getCachedClassesByName(@NotNull String name2, GlobalSearchScope scope) {
        PsiClass[] classes2;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
        }
        if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
            PsiClass[] psiClassArray = this.getCachedClassInDumbMode(name2, scope);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
            }
            return psiClassArray;
        }
        Map map2 = (Map)SoftReference.dereference(this.myClassCache);
        if (map2 == null) {
            map2 = ContainerUtil.createConcurrentSoftValueMap();
            this.myClassCache = new SoftReference((Object)map2);
        }
        if ((classes2 = (PsiClass[])map2.get(name2)) != null) {
            if (classes2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
            }
            return classes2;
        }
        String qName = this.getQualifiedName();
        String classQName = !qName.isEmpty() ? qName + "." + name2 : name2;
        classes2 = this.getFacade().findClasses(classQName, (GlobalSearchScope)new EverythingGlobalScope(this.getProject()));
        map2.put(name2, classes2);
        if (classes2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
        }
        return classes2;
    }

    @NotNull
    private PsiClass[] getCachedClassInDumbMode(String name2, GlobalSearchScope scope) {
        PsiClass[] classes2;
        HashMap<String, PsiClass[]> map2;
        Map scopeMap = (Map)SoftReference.dereference(this.myDumbModeFullCache);
        if (scopeMap == null) {
            scopeMap = ContainerUtil.newConcurrentMap();
            this.myDumbModeFullCache = new SoftReference((Object)scopeMap);
        }
        if ((map2 = (HashMap<String, PsiClass[]>)scopeMap.get(scope)) == null) {
            PsiClass[] array = this.findClassesHeuristically(name2, scope);
            if (array != null) {
                if (array == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassInDumbMode"));
                }
                return array;
            }
            map2 = new HashMap<String, PsiClass[]>();
            for (PsiClass psiClass : this.getClasses(scope)) {
                PsiClass[] psiClassArray;
                String psiClassName = psiClass.getName();
                if (psiClassName == null) continue;
                Object[] existing = (PsiClass[])map2.get(psiClassName);
                if (existing == null) {
                    PsiClass[] psiClassArray2 = new PsiClass[1];
                    psiClassArray = psiClassArray2;
                    psiClassArray2[0] = psiClass;
                } else {
                    psiClassArray = (PsiClass[])ArrayUtil.append((Object[])existing, (Object)psiClass);
                }
                map2.put(psiClassName, psiClassArray);
            }
            scopeMap.put(scope, map2);
        }
        PsiClass[] psiClassArray = (classes2 = (PsiClass[])map2.get(name2)) == null ? PsiClass.EMPTY_ARRAY : classes2;
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassInDumbMode"));
        }
        return psiClassArray;
    }

    @Nullable
    private PsiClass[] findClassesHeuristically(String name2, GlobalSearchScope scope) {
        PsiClass[] result2;
        if (this.findSubPackageByName(name2) != null) {
            return PsiClass.EMPTY_ARRAY;
        }
        Map partial = (Map)SoftReference.dereference(this.myDumbModePartialCache);
        if (partial == null) {
            partial = ContainerUtil.newConcurrentMap();
            this.myDumbModePartialCache = new SoftReference((Object)partial);
        }
        if ((result2 = (PsiClass[])partial.get(Pair.create((Object)scope, (Object)name2))) == null) {
            ArrayList fastClasses = ContainerUtil.newArrayList();
            for (PsiDirectory directory : this.getDirectories(scope)) {
                List sameNamed = ContainerUtil.filter((Object[])directory.getFiles(), file2 -> file2.getName().contains(name2));
                Collections.addAll(fastClasses, CoreJavaDirectoryService.getPsiClasses(directory, sameNamed.toArray(new PsiFile[sameNamed.size()])));
            }
            if (!fastClasses.isEmpty()) {
                result2 = fastClasses.toArray(new PsiClass[fastClasses.size()]);
                partial.put(Pair.create((Object)scope, (Object)name2), result2);
            }
        }
        return result2;
    }

    public boolean containsClassNamed(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/PsiPackageImpl", "containsClassNamed"));
        }
        return this.getCachedClassesByName(name2, (GlobalSearchScope)new EverythingGlobalScope(this.getProject())).length > 0;
    }

    @NotNull
    public PsiClass[] findClassByShortName(@NotNull String name2, @NotNull GlobalSearchScope scope) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        Object[] allClasses = this.getCachedClassesByName(name2, scope);
        if (allClasses.length == 0) {
            if (allClasses == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
            }
            return allClasses;
        }
        if (allClasses.length == 1) {
            Object[] objectArray = PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)allClasses[0]) ? allClasses : PsiClass.EMPTY_ARRAY;
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
            }
            return objectArray;
        }
        PsiClass[] array = (PsiClass[])ContainerUtil.findAllAsArray((Object[])allClasses, aClass -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/PsiPackageImpl", "lambda$findClassByShortName$2"));
            }
            return PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)aClass);
        });
        Arrays.sort(array, PsiClassUtil.createScopeComparator((GlobalSearchScope)scope));
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        return array;
    }

    @Nullable
    private PsiPackage findSubPackageByName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/PsiPackageImpl", "findSubPackageByName"));
        }
        String qName = this.getQualifiedName();
        String subpackageQName = qName.isEmpty() ? name2 : qName + "." + name2;
        return this.getFacade().findPackage(subpackageQName);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiClass[] classes2;
        String providedName;
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        GlobalSearchScope scope = place.getResolveScope();
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        ElementClassHint classHint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        Condition nameCondition = (Condition)processor2.getHint(JavaCompletionHints.NAME_FILTER);
        NameHint providedNameHint = (NameHint)processor2.getHint(NameHint.KEY);
        String string = providedName = providedNameHint == null ? null : providedNameHint.getName(state);
        if ((classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && (providedName != null ? !PsiPackageImpl.processClasses(processor2, state, classes2 = this.findClassByShortName(providedName, scope), (Condition<String>)Conditions.alwaysTrue()) : !PsiPackageImpl.processClasses(processor2, state, classes2 = this.getClasses(scope), (Condition<String>)(nameCondition != null ? nameCondition : Conditions.alwaysTrue())))) {
            return false;
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE)) {
            if (providedName != null) {
                PsiPackage aPackage = this.findSubPackageByName(providedName);
                if (aPackage != null && !processor2.execute((PsiElement)aPackage, state)) {
                    return false;
                }
            } else {
                PsiPackage[] packs;
                for (PsiPackage pack : packs = this.getSubPackages(scope)) {
                    String packageName = pack.getName();
                    if (packageName == null || !PsiNameHelper.getInstance((Project)this.myManager.getProject()).isIdentifier(packageName, PsiUtil.getLanguageLevel((PsiElement)this)) || processor2.execute((PsiElement)pack, state)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processClasses(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @NotNull PsiClass[] classes2, @NotNull Condition<String> nameCondition) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/file/PsiPackageImpl", "processClasses"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/file/PsiPackageImpl", "processClasses"));
        }
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/impl/file/PsiPackageImpl", "processClasses"));
        }
        if (nameCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameCondition", "com/intellij/psi/impl/file/PsiPackageImpl", "processClasses"));
        }
        for (PsiClass aClass : classes2) {
            String name2 = aClass.getName();
            if (name2 == null || !nameCondition.value((Object)name2)) continue;
            try {
                if (processor2.execute((PsiElement)aClass, state)) continue;
                return false;
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return true;
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiPackageImplementationHelper.getInstance().navigate(this, requestFocus);
    }

    @Nullable
    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/file/PsiPackageImpl", "hasModifierProperty"));
        }
        return false;
    }

    private class PackageAnnotationValueProvider
    implements CachedValueProvider<PsiModifierList> {
        private PackageAnnotationValueProvider() {
        }

        public CachedValueProvider.Result<PsiModifierList> compute() {
            ArrayList modifiers = ContainerUtil.newArrayList();
            for (PsiDirectory psiDirectory : PsiPackageImpl.this.getDirectories()) {
                PsiFile file2 = psiDirectory.findFile("package-info.java");
                PsiPackageStatement stmt = file2 == null ? null : (PsiPackageStatement)PsiTreeUtil.getChildOfType((PsiElement)file2, PsiPackageStatement.class);
                PsiModifierList modifierList = stmt == null ? null : stmt.getAnnotationList();
                ContainerUtil.addIfNotNull((Collection)modifiers, (Object)modifierList);
            }
            for (PsiDirectory psiDirectory : PsiPackageImpl.this.getFacade().findClasses(PsiPackageImpl.this.getQualifiedName() + ".package-info", PsiPackageImpl.this.allScope())) {
                ContainerUtil.addIfNotNull((Collection)modifiers, (Object)psiDirectory.getModifierList());
            }
            PsiCompositeModifierList result2 = modifiers.isEmpty() ? null : new PsiCompositeModifierList(PsiPackageImpl.this.getManager(), modifiers);
            return new CachedValueProvider.Result((Object)result2, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        }
    }
}

