/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.include;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeInfoImpl;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileIncludeIndex
extends FileBasedIndexExtension<Key, List<FileIncludeInfoImpl>> {
    public static final ID<Key, List<FileIncludeInfoImpl>> INDEX_ID = ID.create((String)"fileIncludes");
    private static final int BASE_VERSION = 5;

    public static List<FileIncludeInfoImpl> getIncludes(VirtualFile file2, GlobalSearchScope scope) {
        ArrayList<FileIncludeInfoImpl> result2 = new ArrayList<FileIncludeInfoImpl>();
        FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)new FileKey(file2), file2, (file1, value2) -> {
            result2.addAll((Collection<FileIncludeInfoImpl>)value2);
            return true;
        }, scope);
        return result2;
    }

    public static MultiMap<VirtualFile, FileIncludeInfoImpl> getIncludingFileCandidates(String fileName, GlobalSearchScope scope) {
        MultiMap result2 = new MultiMap();
        FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)new IncludeKey(fileName), null, (file2, value2) -> {
            result2.put((Object)file2, (Collection)value2);
            return true;
        }, scope);
        return result2;
    }

    @NotNull
    public ID<Key, List<FileIncludeInfoImpl>> getName() {
        ID<Key, List<FileIncludeInfoImpl>> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/include/FileIncludeIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Key, List<FileIncludeInfoImpl>, FileContent> getIndexer() {
        DataIndexer<Key, List<FileIncludeInfoImpl>, FileContent> dataIndexer = new DataIndexer<Key, List<FileIncludeInfoImpl>, FileContent>(){

            @NotNull
            public Map<Key, List<FileIncludeInfoImpl>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/impl/include/FileIncludeIndex$1", "map"));
                }
                FactoryMap<Key, List<FileIncludeInfoImpl>> map2 = new FactoryMap<Key, List<FileIncludeInfoImpl>>(){

                    protected List<FileIncludeInfoImpl> create(Key key2) {
                        return new ArrayList<FileIncludeInfoImpl>();
                    }
                };
                for (FileIncludeProvider provider : Holder.myProviders) {
                    FileIncludeInfo[] infos;
                    if (!provider.acceptFile(inputData.getFile()) || (infos = provider.getIncludeInfos(inputData)).length == 0) continue;
                    List infoList = (List)map2.get(new FileKey(inputData.getFile()));
                    for (FileIncludeInfo info : infos) {
                        FileIncludeInfoImpl impl = new FileIncludeInfoImpl(info.path, info.offset, info.runtimeOnly, provider.getId());
                        ((List)map2.get(new IncludeKey(info.fileName))).add(impl);
                        infoList.add(impl);
                    }
                }
                FactoryMap<Key, List<FileIncludeInfoImpl>> factoryMap = map2;
                if (factoryMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/include/FileIncludeIndex$1", "map"));
                }
                return factoryMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/include/FileIncludeIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<Key> getKeyDescriptor() {
        KeyDescriptor<Key> keyDescriptor = new KeyDescriptor<Key>(){

            public int getHashCode(Key value2) {
                return value2.hashCode();
            }

            public boolean isEqual(Key val1, Key val2) {
                return val1.equals(val2);
            }

            public void save(@NotNull DataOutput out, Key value2) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/impl/include/FileIncludeIndex$2", "save"));
                }
                out.writeBoolean(value2.isInclude());
                value2.writeValue(out);
            }

            public Key read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/impl/include/FileIncludeIndex$2", "read"));
                }
                boolean isInclude = in.readBoolean();
                return isInclude ? new IncludeKey(IOUtil.readUTF((DataInput)in)) : new FileKey(in.readInt());
            }
        };
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/include/FileIncludeIndex", "getKeyDescriptor"));
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<List<FileIncludeInfoImpl>> getValueExternalizer() {
        DataExternalizer<List<FileIncludeInfoImpl>> dataExternalizer = new DataExternalizer<List<FileIncludeInfoImpl>>(){

            public void save(@NotNull DataOutput out, List<FileIncludeInfoImpl> value2) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/impl/include/FileIncludeIndex$3", "save"));
                }
                out.writeInt(value2.size());
                for (FileIncludeInfoImpl info : value2) {
                    IOUtil.writeUTF((DataOutput)out, (String)info.path);
                    out.writeInt(info.offset);
                    out.writeBoolean(info.runtimeOnly);
                    IOUtil.writeUTF((DataOutput)out, (String)info.providerId);
                }
            }

            public List<FileIncludeInfoImpl> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/impl/include/FileIncludeIndex$3", "read"));
                }
                int size = in.readInt();
                ArrayList<FileIncludeInfoImpl> infos = new ArrayList<FileIncludeInfoImpl>(size);
                for (int i = 0; i < size; ++i) {
                    infos.add(new FileIncludeInfoImpl(IOUtil.readUTF((DataInput)in), in.readInt(), in.readBoolean(), IOUtil.readUTF((DataInput)in)));
                }
                return infos;
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/include/FileIncludeIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.FileTypeSpecificInputFilter fileTypeSpecificInputFilter = new FileBasedIndex.FileTypeSpecificInputFilter(){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/include/FileIncludeIndex$4", "acceptInput"));
                }
                if (file2.getFileSystem() == JarFileSystem.getInstance()) {
                    return false;
                }
                for (FileIncludeProvider provider : Holder.myProviders) {
                    if (!provider.acceptFile(file2)) continue;
                    return true;
                }
                return false;
            }

            public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
                if (fileTypeSink == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "com/intellij/psi/impl/include/FileIncludeIndex$4", "registerFileTypesUsedForIndexing"));
                }
                for (FileIncludeProvider provider : Holder.myProviders) {
                    provider.registerFileTypesUsedForIndexing(fileTypeSink);
                }
            }
        };
        if (fileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/include/FileIncludeIndex", "getInputFilter"));
        }
        return fileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        int version = 5;
        for (FileIncludeProvider provider : Holder.myProviders) {
            version = version * 31 + (provider.getVersion() ^ provider.getClass().getName().hashCode());
        }
        return version;
    }

    private static class FileKey
    implements Key {
        private final int myFileId;

        private FileKey(int fileId) {
            this.myFileId = fileId;
        }

        private FileKey(VirtualFile file2) {
            this.myFileId = FileBasedIndex.getFileId((VirtualFile)file2);
        }

        @Override
        public boolean isInclude() {
            return false;
        }

        @Override
        public void writeValue(DataOutput out) throws IOException {
            out.writeInt(this.myFileId);
        }

        public int hashCode() {
            return this.myFileId;
        }

        public boolean equals(Object obj) {
            return obj instanceof FileKey && ((FileKey)obj).myFileId == this.myFileId;
        }
    }

    private static class IncludeKey
    implements Key {
        private final String myFileName;

        public IncludeKey(String fileName) {
            this.myFileName = fileName;
        }

        @Override
        public boolean isInclude() {
            return true;
        }

        @Override
        public void writeValue(DataOutput out) throws IOException {
            IOUtil.writeUTF((DataOutput)out, (String)this.myFileName);
        }

        public int hashCode() {
            return this.myFileName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof IncludeKey && ((IncludeKey)obj).myFileName.equals(this.myFileName);
        }
    }

    static interface Key {
        public boolean isInclude();

        public void writeValue(DataOutput var1) throws IOException;
    }

    private static class Holder {
        private static final FileIncludeProvider[] myProviders = (FileIncludeProvider[])Extensions.getExtensions(FileIncludeProvider.EP_NAME);

        private Holder() {
        }
    }
}

