/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaNullMethodArgumentIndex
extends ScalarIndexExtension<MethodCallData>
implements PsiDependentIndex {
    private static final Logger LOG = Logger.getInstance(JavaNullMethodArgumentIndex.class);
    public static final ID<MethodCallData, Void> INDEX_ID = ID.create((String)"java.null.method.argument");
    private static final TokenSet CALL_TYPES = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.METHOD_CALL_EXPRESSION, JavaElementType.NEW_EXPRESSION, JavaElementType.ANONYMOUS_CLASS});
    private boolean myOfflineMode = ApplicationManager.getApplication().isCommandLine() && !ApplicationManager.getApplication().isUnitTestMode();

    @NotNull
    public ID<MethodCallData, Void> getName() {
        ID<MethodCallData, Void> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<MethodCallData, Void, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            if (this.myOfflineMode) {
                return Collections.emptyMap();
            }
            int[] nullOffsets = new StringSearcher("null", true, true).findAllOccurrences(inputData.getContentAsText());
            if (nullOffsets.length == 0) {
                return Collections.emptyMap();
            }
            LighterAST lighterAst = ((FileContentImpl)((Object)inputData)).getLighterASTForPsiDependentIndex();
            Set<LighterASTNode> calls = JavaNullMethodArgumentIndex.findCallsWithNulls(lighterAst, nullOffsets);
            if (calls.isEmpty()) {
                return Collections.emptyMap();
            }
            THashMap result2 = new THashMap();
            for (LighterASTNode element : calls) {
                String name2;
                IntArrayList indices2 = JavaNullMethodArgumentIndex.getNullParameterIndices(lighterAst, element);
                if (indices2 == null || (name2 = JavaNullMethodArgumentIndex.getMethodName(lighterAst, element, element.getTokenType())) == null) continue;
                for (int i2 = 0; i2 < indices2.size(); ++i2) {
                    result2.put(new MethodCallData(name2, indices2.get(i2)), null);
                }
            }
            return result2;
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    private static Set<LighterASTNode> findCallsWithNulls(LighterAST lighterAst, int[] nullOffsets) {
        HashSet<LighterASTNode> calls = new HashSet<LighterASTNode>();
        for (int offset : nullOffsets) {
            LighterASTNode exprList;
            LighterASTNode literal;
            LighterASTNode leaf = LightTreeUtil.findLeafElementAt(lighterAst, offset);
            LighterASTNode lighterASTNode = literal = leaf == null ? null : lighterAst.getParent(leaf);
            if (!JavaNullMethodArgumentIndex.isNullLiteral(lighterAst, literal) || (exprList = lighterAst.getParent(literal)) == null || exprList.getTokenType() != JavaElementType.EXPRESSION_LIST) continue;
            ContainerUtil.addIfNotNull(calls, (Object)LightTreeUtil.getParentOfType(lighterAst, exprList, CALL_TYPES, ElementType.MEMBER_BIT_SET));
        }
        HashSet<LighterASTNode> hashSet = calls;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex", "findCallsWithNulls"));
        }
        return hashSet;
    }

    @Nullable
    private static IntArrayList getNullParameterIndices(LighterAST lighterAst, @NotNull LighterASTNode methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex", "getNullParameterIndices"));
        }
        LighterASTNode node = LightTreeUtil.firstChildOfType(lighterAst, methodCall, JavaElementType.EXPRESSION_LIST);
        if (node == null) {
            return null;
        }
        List<LighterASTNode> parameters2 = JavaLightTreeUtil.getExpressionChildren(lighterAst, node);
        IntArrayList indices2 = new IntArrayList(1);
        for (int idx = 0; idx < parameters2.size(); ++idx) {
            if (!JavaNullMethodArgumentIndex.isNullLiteral(lighterAst, parameters2.get(idx))) continue;
            indices2.add(idx);
        }
        return indices2;
    }

    private static boolean isNullLiteral(LighterAST lighterAst, @Nullable LighterASTNode expr) {
        return expr != null && expr.getTokenType() == JavaElementType.LITERAL_EXPRESSION && ((LighterASTNode)lighterAst.getChildren(expr).get(0)).getTokenType() == JavaTokenType.NULL_KEYWORD;
    }

    @Nullable
    private static String getMethodName(LighterAST lighterAst, @NotNull LighterASTNode call, IElementType elementType) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex", "getMethodName"));
        }
        if (elementType == JavaElementType.NEW_EXPRESSION || elementType == JavaElementType.ANONYMOUS_CLASS) {
            List<LighterASTNode> refs = LightTreeUtil.getChildrenOfType(lighterAst, call, JavaElementType.JAVA_CODE_REFERENCE);
            if (refs.isEmpty()) {
                return null;
            }
            LighterASTNode lastRef = refs.get(refs.size() - 1);
            return JavaLightTreeUtil.getNameIdentifierText(lighterAst, lastRef);
        }
        LOG.assertTrue(elementType == JavaElementType.METHOD_CALL_EXPRESSION);
        LighterASTNode methodReference = (LighterASTNode)lighterAst.getChildren(call).get(0);
        if (methodReference.getTokenType() == JavaElementType.REFERENCE_EXPRESSION) {
            return JavaLightTreeUtil.getNameIdentifierText(lighterAst, methodReference);
        }
        return null;
    }

    @NotNull
    public KeyDescriptor<MethodCallData> getKeyDescriptor() {
        KeyDescriptor<MethodCallData> keyDescriptor = new KeyDescriptor<MethodCallData>(){

            public int getHashCode(MethodCallData value2) {
                return value2.hashCode();
            }

            public boolean isEqual(MethodCallData val1, MethodCallData val2) {
                return val1.equals(val2);
            }

            public void save(@NotNull DataOutput out, MethodCallData value2) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$1", "save"));
                }
                EnumeratorStringDescriptor.INSTANCE.save(out, value2.getMethodName());
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.getNullParameterIndex());
            }

            public MethodCallData read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$1", "read"));
                }
                return new MethodCallData(EnumeratorStringDescriptor.INSTANCE.read(in), DataInputOutputUtil.readINT((DataInput)in));
            }
        };
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex", "getKeyDescriptor"));
        }
        return keyDescriptor;
    }

    public int getVersion() {
        return 0;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$2", "acceptInput"));
                }
                return JavaStubElementTypes.JAVA_FILE.shouldBuildStubFor(file2);
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static final class MethodCallData {
        @NotNull
        private final String myMethodName;
        private final int myNullParameterIndex;

        public MethodCallData(@NotNull String name2, int index) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$MethodCallData", "<init>"));
            }
            this.myMethodName = name2;
            this.myNullParameterIndex = index;
        }

        @NotNull
        public String getMethodName() {
            String string = this.myMethodName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$MethodCallData", "getMethodName"));
            }
            return string;
        }

        public int getNullParameterIndex() {
            return this.myNullParameterIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodCallData data = (MethodCallData)o;
            if (this.myNullParameterIndex != data.myNullParameterIndex) {
                return false;
            }
            return this.myMethodName.equals(data.myMethodName);
        }

        public int hashCode() {
            int result2 = this.myMethodName.hashCode();
            result2 = 31 * result2 + this.myNullParameterIndex;
            return result2;
        }

        public String toString() {
            return "MethodCallData{myMethodName='" + this.myMethodName + '\'' + ", myNullParameterIndex=" + this.myNullParameterIndex + '}';
        }
    }
}

