/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.psi.PsiType;
import com.intellij.psi.SmartTypePointer;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypePointerBase<T extends PsiType>
implements SmartTypePointer {
    private Reference<T> myTypeRef;

    public TypePointerBase(@NotNull T type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/TypePointerBase", "<init>"));
        }
        this.myTypeRef = new SoftReference(type2);
    }

    public T getType() {
        Object myType = (PsiType)SoftReference.dereference(this.myTypeRef);
        if (myType != null && myType.isValid()) {
            return (T)myType;
        }
        myType = this.calcType();
        this.myTypeRef = myType == null ? null : new SoftReference(myType);
        return (T)myType;
    }

    @Nullable
    protected abstract T calcType();
}

