/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleSchemesImpl
extends CodeStyleSchemes {
    @NonNls
    static final String CODE_STYLES_DIR_PATH = "codestyles";
    protected final SchemeManager<CodeStyleScheme> mySchemeManager;

    public CodeStyleSchemesImpl(@NotNull SchemeManagerFactory schemeManagerFactory) {
        if (schemeManagerFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeManagerFactory", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "<init>"));
        }
        this.mySchemeManager = schemeManagerFactory.create(CODE_STYLES_DIR_PATH, new LazySchemeProcessor<CodeStyleScheme, CodeStyleSchemeImpl>(){

            @Override
            @NotNull
            public CodeStyleSchemeImpl createScheme(@NotNull SchemeDataHolder<? super CodeStyleSchemeImpl> dataHolder, @NotNull String name2, @NotNull Function<String, String> attributeProvider2, boolean isBundled) {
                if (dataHolder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "createScheme"));
                }
                if (name2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "createScheme"));
                }
                if (attributeProvider2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeProvider", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "createScheme"));
                }
                CodeStyleSchemeImpl codeStyleSchemeImpl = new CodeStyleSchemeImpl(attributeProvider2.apply("name"), attributeProvider2.apply("parent"), dataHolder);
                if (codeStyleSchemeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl$1", "createScheme"));
                }
                return codeStyleSchemeImpl;
            }
        });
        this.mySchemeManager.loadSchemes();
        this.setCurrentScheme(this.getDefaultScheme());
    }

    public CodeStyleScheme getCurrentScheme() {
        return this.mySchemeManager.getCurrentScheme();
    }

    public void setCurrentScheme(CodeStyleScheme scheme2) {
        this.mySchemeManager.setCurrent(scheme2);
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        return new CodeStyleSchemeImpl(SchemeNameGenerator.getUniqueName(preferredName, (Scheme)parentScheme, name2 -> this.mySchemeManager.findSchemeByName((String)name2) != null), false, parentScheme);
    }

    public void deleteScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "deleteScheme"));
        }
        if (scheme2.isDefault()) {
            throw new IllegalArgumentException("Unable to delete default scheme!");
        }
        CodeStyleSchemeImpl currentScheme = (CodeStyleSchemeImpl)this.getCurrentScheme();
        if (currentScheme == scheme2) {
            CodeStyleScheme newCurrentScheme = this.getDefaultScheme();
            if (newCurrentScheme == null) {
                throw new IllegalStateException("Unable to load default scheme!");
            }
            this.setCurrentScheme(newCurrentScheme);
        }
        this.mySchemeManager.removeScheme(scheme2);
    }

    public CodeStyleScheme getDefaultScheme() {
        CodeStyleScheme defaultScheme = this.mySchemeManager.findSchemeByName("Default");
        if (defaultScheme == null) {
            defaultScheme = new CodeStyleSchemeImpl("Default", true, null);
            this.addScheme(defaultScheme);
        }
        return defaultScheme;
    }

    @Nullable
    public CodeStyleScheme findSchemeByName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "findSchemeByName"));
        }
        return this.mySchemeManager.findSchemeByName(name2);
    }

    public void addScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "addScheme"));
        }
        this.mySchemeManager.addScheme(scheme2);
    }

    @NotNull
    public static SchemeManager<CodeStyleScheme> getSchemeManager() {
        SchemeManager<CodeStyleScheme> schemeManager2 = ((CodeStyleSchemesImpl)CodeStyleSchemes.getInstance()).mySchemeManager;
        if (schemeManager2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/CodeStyleSchemesImpl", "getSchemeManager"));
        }
        return schemeManager2;
    }
}

