/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.formatting.IndentInfo;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDComment {
    protected final CommentFormatter myFormatter;
    private String myDescription;
    private List<String> myUnknownList;
    private List<String> mySeeAlsoList;
    private List<String> mySinceList;
    private String myDeprecated;
    private boolean myMultiLineComment;
    private String myFirstLine;
    private String myEndLine;

    public JDComment(@NotNull CommentFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "<init>"));
        }
        this.myFirstLine = "/**";
        this.myEndLine = "*/";
        this.myFormatter = formatter;
    }

    protected static boolean isNull(@Nullable String s) {
        return s == null || s.trim().isEmpty();
    }

    protected static boolean isNull(@Nullable List<?> l) {
        return l == null || l.isEmpty();
    }

    public void setMultiLine(boolean value2) {
        this.myMultiLineComment = value2;
    }

    @NotNull
    protected String javadocContinuationIndent() {
        if (!this.myFormatter.getSettings().JD_INDENT_ON_CONTINUATION) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "javadocContinuationIndent"));
            }
            return "";
        }
        String string = this.continuationIndent();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "javadocContinuationIndent"));
        }
        return string;
    }

    @NotNull
    protected String continuationIndent() {
        CodeStyleSettings settings = this.myFormatter.getSettings();
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)JavaFileType.INSTANCE);
        String string = new IndentInfo(0, indentOptions.CONTINUATION_INDENT_SIZE, 0).generateNewWhiteSpace(indentOptions);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "continuationIndent"));
        }
        return string;
    }

    @Nullable
    public String generate(@NotNull String indent) {
        StringBuilder tagDescription;
        JDTag tag;
        if (indent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "generate"));
        }
        String prefix = this.myFormatter.getSettings().JD_LEADING_ASTERISKS_ARE_ENABLED ? indent + " * " : indent;
        StringBuilder sb = new StringBuilder();
        int start = sb.length();
        if (!JDComment.isNull(this.myDescription)) {
            sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(this.myDescription, prefix));
            if (this.myFormatter.getSettings().JD_ADD_BLANK_AFTER_DESCRIPTION) {
                sb.append(prefix);
                sb.append('\n');
            }
        }
        this.generateSpecial(prefix, sb);
        String continuationPrefix = prefix + this.javadocContinuationIndent();
        if (!JDComment.isNull(this.myUnknownList) && this.myFormatter.getSettings().JD_KEEP_INVALID_TAGS) {
            for (String string : this.myUnknownList) {
                sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(string, prefix, continuationPrefix));
            }
        }
        if (!JDComment.isNull(this.mySeeAlsoList)) {
            tag = JDTag.SEE;
            for (String aSeeAlsoList : this.mySeeAlsoList) {
                tagDescription = this.myFormatter.getParser().formatJDTagDescription(aSeeAlsoList, prefix + tag.getWithEndWhitespace(), continuationPrefix);
                sb.append((CharSequence)tagDescription);
            }
        }
        if (!JDComment.isNull(this.mySinceList)) {
            tag = JDTag.SINCE;
            for (String since : this.mySinceList) {
                tagDescription = this.myFormatter.getParser().formatJDTagDescription(since, prefix + tag.getWithEndWhitespace(), continuationPrefix);
                sb.append((CharSequence)tagDescription);
            }
        }
        if (this.myDeprecated != null) {
            tag = JDTag.DEPRECATED;
            StringBuilder stringBuilder = this.myFormatter.getParser().formatJDTagDescription(this.myDeprecated, prefix + tag.getWithEndWhitespace(), continuationPrefix);
            sb.append((CharSequence)stringBuilder);
        }
        if (sb.length() == start) {
            return null;
        }
        int nlen = sb.length() - prefix.length() - 1;
        if (sb.substring(nlen, sb.length()).equals(prefix + "\n")) {
            sb.delete(nlen, sb.length());
        }
        if (this.myMultiLineComment && this.myFormatter.getSettings().JD_DO_NOT_WRAP_ONE_LINE_COMMENTS || !this.myFormatter.getSettings().JD_DO_NOT_WRAP_ONE_LINE_COMMENTS || sb.indexOf("\n") != sb.length() - 1) {
            sb.insert(0, this.myFirstLine + '\n');
            sb.append(indent);
        } else {
            sb.replace(0, prefix.length(), this.myFirstLine + " ");
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(' ').append(this.myEndLine);
        return sb.toString();
    }

    protected void generateSpecial(@NotNull String prefix, @NotNull StringBuilder sb) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "generateSpecial"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "generateSpecial"));
        }
    }

    public void setFirstCommentLine(@NotNull String firstCommentLine) {
        if (firstCommentLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstCommentLine", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "setFirstCommentLine"));
        }
        this.myFirstLine = firstCommentLine;
    }

    public void setLastCommentLine(@NotNull String lastCommentLine) {
        if (lastCommentLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommentLine", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "setLastCommentLine"));
        }
        this.myEndLine = lastCommentLine;
    }

    public void addSeeAlso(@NotNull String seeAlso) {
        if (seeAlso == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seeAlso", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "addSeeAlso"));
        }
        if (this.mySeeAlsoList == null) {
            this.mySeeAlsoList = new ArrayList<String>();
        }
        this.mySeeAlsoList.add(seeAlso);
    }

    public void addUnknownTag(@NotNull String unknownTag) {
        if (unknownTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unknownTag", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "addUnknownTag"));
        }
        if (this.myUnknownList == null) {
            this.myUnknownList = new ArrayList<String>();
        }
        this.myUnknownList.add(unknownTag);
    }

    public void addSince(@NotNull String since) {
        if (since == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "since", "com/intellij/psi/impl/source/codeStyle/javadoc/JDComment", "addSince"));
        }
        if (this.mySinceList == null) {
            this.mySinceList = new ArrayList<String>();
        }
        this.mySinceList.add(since);
    }

    public void setDeprecated(@Nullable String deprecated) {
        this.myDeprecated = deprecated;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = description;
    }
}

