/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import com.intellij.psi.impl.source.codeStyle.javadoc.TagDescription;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDParamListOwnerComment
extends JDComment {
    protected List<TagDescription> myParamsList;

    public JDParamListOwnerComment(@NotNull CommentFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParamListOwnerComment", "<init>"));
        }
        super(formatter);
    }

    @Override
    protected void generateSpecial(@NotNull String prefix, @NotNull StringBuilder sb) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParamListOwnerComment", "generateSpecial"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParamListOwnerComment", "generateSpecial"));
        }
        if (this.myParamsList != null) {
            int before = sb.length();
            this.generateList(prefix, sb, this.myParamsList, JDTag.PARAM.getWithEndWhitespace(), this.myFormatter.getSettings().JD_ALIGN_PARAM_COMMENTS, this.myFormatter.getSettings().JD_KEEP_EMPTY_PARAMETER, this.myFormatter.getSettings().JD_PARAM_DESCRIPTION_ON_NEW_LINE);
            int size = sb.length() - before;
            if (size > 0 && this.myFormatter.getSettings().JD_ADD_BLANK_AFTER_PARM_COMMENTS) {
                sb.append(prefix);
                sb.append('\n');
            }
        }
    }

    @Nullable
    public TagDescription getParameter(@Nullable String name2) {
        return JDParamListOwnerComment.getNameDesc(name2, this.myParamsList);
    }

    public void addParameter(@NotNull String name2, @Nullable String description) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParamListOwnerComment", "addParameter"));
        }
        if (this.myParamsList == null) {
            this.myParamsList = ContainerUtilRt.newArrayList();
        }
        this.myParamsList.add(new TagDescription(name2, description));
    }

    @Nullable
    private static TagDescription getNameDesc(@Nullable String name2, @Nullable List<TagDescription> list2) {
        if (list2 == null) {
            return null;
        }
        for (TagDescription aList : list2) {
            if (!aList.name.equals(name2)) continue;
            return aList;
        }
        return null;
    }

    protected void generateList(@NotNull String prefix, @NotNull StringBuilder sb, @NotNull List<TagDescription> tagBlocks, @NotNull String tag, boolean align_comments, boolean generate_empty_tags, boolean descriptionOnNewLine) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParamListOwnerComment", "generateList"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParamListOwnerComment", "generateList"));
        }
        if (tagBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagBlocks", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParamListOwnerComment", "generateList"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParamListOwnerComment", "generateList"));
        }
        int maxNameLength = JDParamListOwnerComment.maxTagDescriptionNameLength(tagBlocks, align_comments, generate_empty_tags, descriptionOnNewLine);
        StringBuilder fill = new StringBuilder(prefix.length() + tag.length() + maxNameLength + 1);
        fill.append(prefix);
        StringUtil.repeatSymbol((Appendable)fill, (char)' ', (int)(maxNameLength + 1 + tag.length()));
        for (TagDescription nd : tagBlocks) {
            if (JDParamListOwnerComment.isNull(nd.desc) && !generate_empty_tags) continue;
            if (descriptionOnNewLine && !JDParamListOwnerComment.isNull(nd.desc)) {
                sb.append(prefix).append(tag).append(nd.name).append("\n");
                sb.append((CharSequence)this.formatJDTagDescription(nd.desc, prefix + this.continuationIndent()));
                continue;
            }
            if (align_comments) {
                int spacesNumber = maxNameLength + 1 - nd.name.length();
                String spaces = StringUtil.repeatSymbol((char)' ', (int)Math.max(0, spacesNumber));
                String firstLinePrefix = prefix + tag + nd.name + spaces;
                sb.append((CharSequence)this.formatJDTagDescription(nd.desc, firstLinePrefix, fill));
                continue;
            }
            String description = nd.desc == null ? "" : nd.desc;
            StringBuilder tagDescription = this.formatJDTagDescription(tag + nd.name + " " + description, prefix, prefix + this.javadocContinuationIndent());
            sb.append((CharSequence)tagDescription);
        }
    }

    private static int maxTagDescriptionNameLength(@NotNull List<TagDescription> tagBlocks, boolean align_comments, boolean generate_empty_tags, boolean descriptionOnNewLine) {
        if (tagBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagBlocks", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParamListOwnerComment", "maxTagDescriptionNameLength"));
        }
        int max = 0;
        if (align_comments && !descriptionOnNewLine) {
            for (TagDescription tagDescription : tagBlocks) {
                int current = tagDescription.name.length();
                if (JDParamListOwnerComment.isNull(tagDescription.desc) && !generate_empty_tags || current <= max) continue;
                max = current;
            }
        }
        return max;
    }

    private StringBuilder formatJDTagDescription(@Nullable String description, @NotNull CharSequence firstLinePrefix, @NotNull CharSequence continuationPrefix) {
        if (firstLinePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstLinePrefix", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParamListOwnerComment", "formatJDTagDescription"));
        }
        if (continuationPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "continuationPrefix", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParamListOwnerComment", "formatJDTagDescription"));
        }
        return this.myFormatter.getParser().formatJDTagDescription(description, firstLinePrefix, continuationPrefix);
    }

    private StringBuilder formatJDTagDescription(@Nullable String description, @NotNull CharSequence prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/impl/source/codeStyle/javadoc/JDParamListOwnerComment", "formatJDTagDescription"));
        }
        return this.formatJDTagDescription(description, prefix, prefix);
    }
}

