/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiDocTagImpl
extends CompositePsiElement
implements PsiDocTag,
Constants {
    private static final TokenSet TAG_VALUE_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{DOC_TAG_VALUE_ELEMENT, DOC_METHOD_OR_FIELD_REF, DOC_PARAMETER_REF});
    private static final TokenSet VALUE_BIT_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TAG_VALUE_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{DOC_TAG_VALUE_TOKEN, JAVA_CODE_REFERENCE, DOC_COMMENT_DATA, DOC_INLINE_TAG, DOC_REFERENCE_HOLDER})});

    public PsiDocTagImpl() {
        super(DOC_TAG);
    }

    public PsiDocComment getContainingComment() {
        return (PsiDocComment)this.getParent();
    }

    public PsiElement getNameElement() {
        return this.findPsiChildByType(DOC_TAG_NAME);
    }

    public PsiDocTagValue getValueElement() {
        return (PsiDocTagValue)this.findPsiChildByType(TAG_VALUE_BIT_SET);
    }

    @NotNull
    public PsiElement[] getDataElements() {
        PsiElement[] psiElementArray = this.getChildrenAsPsiElements(VALUE_BIT_SET, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/javadoc/PsiDocTagImpl", "getDataElements"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.getNameElement() == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/javadoc/PsiDocTagImpl", "getName"));
            }
            return "";
        }
        String string = this.getNameElement().getText().substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/javadoc/PsiDocTagImpl", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/javadoc/PsiDocTagImpl", "setName"));
        }
        PsiImplUtil.setName(this.getNameElement(), name2);
        return this;
    }

    @Override
    public int getChildRole(ASTNode child) {
        assert (child.getTreeParent() == this) : child.getTreeParent();
        IElementType i = child.getElementType();
        if (i == DOC_TAG_NAME) {
            return 105;
        }
        if (i == JavaDocElementType.DOC_COMMENT || i == DOC_INLINE_TAG) {
            return 106;
        }
        if (i == DOC_COMMENT_LEADING_ASTERISKS) {
            return 107;
        }
        if (TAG_VALUE_BIT_SET.contains(i)) {
            return 242;
        }
        return 0;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/javadoc/PsiDocTagImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/javadoc/PsiDocTagImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDocTag((PsiDocTag)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiDocTag:" + this.getNameElement().getText();
    }
}

