/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CheckedExceptionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private static final Logger LOG = Logger.getInstance(CheckedExceptionCompatibilityConstraint.class);
    private final PsiExpression myExpression;
    private PsiType myT;

    public CheckedExceptionCompatibilityConstraint(PsiExpression expression2, PsiType t) {
        this.myExpression = expression2;
        this.myT = t;
    }

    @Override
    public boolean reduce(InferenceSession session2, List<ConstraintFormula> constraints) {
        block18: {
            Object exceptions;
            PsiExpression body2;
            PsiType type3;
            if (!PsiPolyExpressionUtil.isPolyExpression((PsiExpression)this.myExpression)) {
                return true;
            }
            if (this.myExpression instanceof PsiParenthesizedExpression) {
                constraints.add(new CheckedExceptionCompatibilityConstraint(((PsiParenthesizedExpression)this.myExpression).getExpression(), this.myT));
                return true;
            }
            if (this.myExpression instanceof PsiConditionalExpression) {
                PsiExpression elseExpression2;
                PsiExpression thenExpression2 = ((PsiConditionalExpression)this.myExpression).getThenExpression();
                if (thenExpression2 != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(thenExpression2, this.myT));
                }
                if ((elseExpression2 = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(elseExpression2, this.myT));
                }
                return true;
            }
            if (!(this.myExpression instanceof PsiLambdaExpression) && !(this.myExpression instanceof PsiMethodReferenceExpression)) break block18;
            if (!LambdaUtil.isFunctionalType((PsiType)this.myT)) {
                session2.registerIncompatibleErrorMessage(session2.getPresentableText(this.myT) + " is not a functional interface");
                return false;
            }
            PsiType groundTargetType = this.myExpression instanceof PsiLambdaExpression ? FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT, (PsiLambdaExpression)this.myExpression, false) : FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)groundTargetType);
            if (interfaceMethod == null) {
                session2.registerIncompatibleErrorMessage("No valid function type can be found for " + session2.getPresentableText(this.myT));
                return false;
            }
            PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)PsiUtil.resolveGenericsClassInType((PsiType)groundTargetType));
            if (this.myExpression instanceof PsiLambdaExpression && !((PsiLambdaExpression)this.myExpression).hasFormalParameterTypes() || this.myExpression instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)this.myExpression).isExact()) {
                for (PsiParameter parameter : interfaceMethod.getParameterList().getParameters()) {
                    PsiType type4 = substitutor.substitute(parameter.getType());
                    if (session2.isProperType(type4)) continue;
                    session2.registerIncompatibleErrorMessage("Parameter type is not yet inferred: " + session2.getPresentableText(type4));
                    return false;
                }
            }
            PsiType returnType = interfaceMethod.getReturnType();
            if (!(!(this.myExpression instanceof PsiLambdaExpression) && ((PsiMethodReferenceExpression)this.myExpression).isExact() || session2.isProperType(type3 = substitutor.substitute(returnType)))) {
                session2.registerIncompatibleErrorMessage("Return type is not yet inferred: " + session2.getPresentableText(type3));
                return false;
            }
            List expectedThrownTypes = ContainerUtil.map((Object[])interfaceMethod.getThrowsList().getReferencedTypes(), type2 -> session2.substituteWithInferenceVariables(substitutor.substitute(type2)));
            ArrayList<PsiType> expectedNonProperThrownTypes = new ArrayList<PsiType>();
            for (PsiType type4 : expectedThrownTypes) {
                if (session2.isProperType(type4)) continue;
                expectedNonProperThrownTypes.add(type4);
            }
            ArrayList thrownTypes = new ArrayList();
            Object object = body2 = this.myExpression instanceof PsiLambdaExpression ? ((PsiLambdaExpression)this.myExpression).getBody() : this.myExpression;
            if (body2 != null && (exceptions = ExceptionUtil.getUnhandledExceptions(new PsiElement[]{body2})) != null) {
                thrownTypes.addAll(ContainerUtil.filter((Collection)exceptions, type2 -> !ExceptionUtil.isUncheckedException(type2)));
            }
            if (expectedNonProperThrownTypes.isEmpty()) {
                for (PsiType thrownType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedThrownTypes, thrownType)) continue;
                    session2.registerIncompatibleErrorMessage("Unhandled exception: " + session2.getPresentableText(thrownType));
                    return false;
                }
            } else {
                ArrayList<PsiType> expectedProperTypes = new ArrayList<PsiType>(expectedThrownTypes);
                expectedProperTypes.removeAll(expectedNonProperThrownTypes);
                for (PsiType thrownType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedProperTypes, thrownType)) continue;
                    for (PsiType expectedNonProperThrownType : expectedNonProperThrownTypes) {
                        constraints.add(new StrictSubtypingConstraint(expectedNonProperThrownType, thrownType));
                    }
                }
                for (PsiType expectedNonProperThrownType : expectedNonProperThrownTypes) {
                    InferenceVariable variable = session2.getInferenceVariable(expectedNonProperThrownType);
                    if (variable == null) continue;
                    variable.setThrownBound();
                }
            }
        }
        return true;
    }

    private static boolean isAddressed(List<PsiType> expectedThrownTypes, PsiType thrownType) {
        for (PsiType expectedThrownType : expectedThrownTypes) {
            if (!TypeConversionUtil.isAssignable((PsiType)expectedThrownType, (PsiType)thrownType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    protected PsiType getT() {
        return this.myT;
    }

    @Override
    protected void setT(PsiType t) {
        this.myT = t;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type2, PsiExpression expression2) {
        return new CheckedExceptionCompatibilityConstraint(expression2, type2);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session2, PsiExpression psiExpression, PsiType returnType, Set<InferenceVariable> result2) {
        session2.collectDependencies(returnType, result2);
    }
}

