/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.reflectiveAccess.JavaReflectionInvocationInspection;
import com.intellij.codeInspection.reflectiveAccess.JavaReflectionMemberAccessInspection;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLangClassMemberReference
extends PsiReferenceBase<PsiLiteralExpression>
implements InsertHandler<LookupElement> {
    private final PsiExpression myContext;

    public JavaLangClassMemberReference(@NotNull PsiLiteralExpression literal, @NotNull PsiExpression context) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "<init>"));
        }
        super((PsiElement)literal);
        this.myContext = context;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "bindToElement"));
        }
        return element;
    }

    public PsiElement resolve() {
        Object value2 = ((PsiLiteralExpression)this.myElement).getValue();
        if (value2 instanceof String) {
            PsiClass psiClass;
            String name2 = (String)value2;
            String type2 = JavaReflectionReferenceUtil.getMemberType(this.myElement);
            if (type2 != null && (psiClass = this.getPsiClass()) != null) {
                switch (type2) {
                    case "getField": {
                        return psiClass.findFieldByName(name2, true);
                    }
                    case "getDeclaredField": {
                        PsiField field = psiClass.findFieldByName(name2, false);
                        return JavaLangClassMemberReference.isPotentiallyAccessible((PsiMember)field, psiClass) ? field : null;
                    }
                    case "getMethod": {
                        Object[] methods = psiClass.findMethodsByName(name2, true);
                        if (methods.length > 1 && (methods = ContainerUtil.filter((Object[])methods, method -> JavaReflectionReferenceUtil.isRegularMethod(method) && JavaReflectionReferenceUtil.isPublic((PsiMember)method)).toArray(PsiMethod.EMPTY_ARRAY)).length > 1) {
                            return this.findOverloadedMethod((PsiMethod[])methods);
                        }
                        return methods.length != 0 ? methods[0] : null;
                    }
                    case "getDeclaredMethod": {
                        Object[] methods = psiClass.findMethodsByName(name2, false);
                        if (methods.length > 1 && (methods = ContainerUtil.filter((Object[])methods, method -> JavaReflectionReferenceUtil.isRegularMethod(method) && JavaLangClassMemberReference.isPotentiallyAccessible((PsiMember)method, psiClass)).toArray(PsiMethod.EMPTY_ARRAY)).length > 1) {
                            return this.findOverloadedMethod((PsiMethod[])methods);
                        }
                        return methods.length != 0 ? methods[0] : null;
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private PsiClass getPsiClass() {
        return JavaReflectionReferenceUtil.getReflectiveClass(this.myContext);
    }

    @NotNull
    public Object[] getVariants() {
        PsiClass psiClass;
        String type2 = JavaReflectionReferenceUtil.getMemberType(this.myElement);
        if (type2 != null && (psiClass = this.getPsiClass()) != null) {
            switch (type2) {
                case "getDeclaredField": {
                    Object[] objectArray = Arrays.stream(psiClass.getFields()).filter(field -> field.getName() != null).sorted(Comparator.comparing(PomNamedTarget::getName)).map(field -> JavaReflectionReferenceUtil.lookupField(field)).toArray();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "getField": {
                    THashSet uniqueNames = new THashSet();
                    Object[] objectArray = Arrays.stream(psiClass.getAllFields()).filter(arg_0 -> JavaLangClassMemberReference.lambda$getVariants$4(psiClass, (Set)uniqueNames, arg_0)).sorted(Comparator.comparingInt(field -> JavaReflectionReferenceUtil.isPublic((PsiMember)field) ? 0 : 1).thenComparing(PomNamedTarget::getName)).map(field -> JavaReflectionReferenceUtil.withPriority(JavaReflectionReferenceUtil.lookupField(field), JavaReflectionReferenceUtil.isPublic((PsiMember)field))).toArray();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "getDeclaredMethod": {
                    Object[] objectArray = Arrays.stream(psiClass.getMethods()).filter(method -> JavaReflectionReferenceUtil.isRegularMethod(method)).sorted(Comparator.comparing(PsiMethod::getName)).map(method -> JavaReflectionReferenceUtil.lookupMethod(method, this)).filter(Objects::nonNull).toArray();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "getMethod": {
                    Object[] objectArray = psiClass.getVisibleSignatures().stream().map(MethodSignatureBackedByPsiMethod::getMethod).filter(method -> JavaReflectionReferenceUtil.isRegularMethod(method) && JavaLangClassMemberReference.isPotentiallyAccessible((PsiMember)method, psiClass)).sorted(Comparator.comparingInt(method -> JavaReflectionReferenceUtil.getMethodSortOrder(method)).thenComparing(PsiMethod::getName)).map(method -> JavaReflectionReferenceUtil.withPriority(JavaReflectionReferenceUtil.lookupMethod(method, this), -JavaReflectionReferenceUtil.getMethodSortOrder(method))).filter(Objects::nonNull).toArray();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                    }
                    return objectArray;
                }
            }
        }
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    @Contract(value="null, _ -> false")
    private static boolean isPotentiallyAccessible(PsiMember member, PsiClass psiClass) {
        return member != null && (member.getContainingClass() == psiClass || JavaReflectionReferenceUtil.isPublic(member));
    }

    @Nullable
    private PsiElement findOverloadedMethod(PsiMethod[] methods) {
        List<JavaReflectionReferenceUtil.ReflectiveType> parameterTypes;
        PsiMethodCallExpression definitionCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiMethodCallExpression.class);
        if (definitionCall != null && (parameterTypes = JavaReflectionInvocationInspection.getReflectionMethodParameterTypes(definitionCall, 1)) != null) {
            return JavaReflectionMemberAccessInspection.matchMethod(methods, parameterTypes);
        }
        return null;
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        Object object = item.getObject();
        if (object instanceof JavaReflectionReferenceUtil.ReflectiveSignature) {
            JavaReflectionReferenceUtil.ReflectiveSignature signature = (JavaReflectionReferenceUtil.ReflectiveSignature)object;
            String text2 = signature.getText(false, false, type2 -> type2 + ".class");
            JavaReflectionReferenceUtil.replaceText(context, text2.isEmpty() ? "" : ", " + text2);
        }
    }

    private static /* synthetic */ boolean lambda$getVariants$4(PsiClass psiClass, Set uniqueNames, PsiField field) {
        return JavaLangClassMemberReference.isPotentiallyAccessible((PsiMember)field, psiClass) && field.getName() != null && uniqueNames.add(field.getName());
    }
}

