/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodHandleCompletionContributor
extends CompletionContributor {
    private static final Set<String> METHOD_HANDLE_FACTORY_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"findConstructor", "findVirtual", "findStatic", "findSpecial"});
    private static final PsiJavaElementPattern.Capture<PsiElement> METHOD_TYPE_ARGUMENT_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{","})).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiExpression().methodCallParameter(1, (ElementPattern)JavaMethodHandleCompletionContributor.methodPattern("findConstructor")), PsiJavaPatterns.psiExpression().methodCallParameter(2, (ElementPattern)JavaMethodHandleCompletionContributor.methodPattern("findVirtual", "findStatic", "findSpecial"))}));
    private static final Set<String> FIELD_HANDLE_FACTORY_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"findGetter", "findSetter", "findStaticGetter", "findStaticSetter", "findVarHandle", "findStaticVarHandle"});
    private static final PsiJavaElementPattern.Capture<PsiElement> FIELD_TYPE_ARGUMENT_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{","})).withParent((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(2, (ElementPattern)JavaMethodHandleCompletionContributor.methodPattern(ArrayUtil.toStringArray(FIELD_HANDLE_FACTORY_NAMES))));

    @NotNull
    private static PsiMethodPattern methodPattern(String ... methodNames) {
        PsiMethodPattern psiMethodPattern = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(methodNames)).definedInClass("java.lang.invoke.MethodHandles.Lookup");
        if (psiMethodPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "methodPattern"));
        }
        return psiMethodPattern;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement position = parameters2.getPosition();
        if (!JavaCompletionContributor.isInJavaContext(position)) {
            return;
        }
        if (METHOD_TYPE_ARGUMENT_PATTERN.accepts((Object)position)) {
            JavaMethodHandleCompletionContributor.addMethodHandleVariants(position, (Consumer<LookupElement>)result2);
        } else if (FIELD_TYPE_ARGUMENT_PATTERN.accepts((Object)position)) {
            JavaMethodHandleCompletionContributor.addFieldHandleVariants(position, (Consumer<LookupElement>)result2);
        }
    }

    private static void addMethodHandleVariants(@NotNull PsiElement position, @NotNull Consumer<LookupElement> result2) {
        String methodName;
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addMethodHandleVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addMethodHandleVariants"));
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class);
        if (methodCall != null && (methodName = methodCall.getMethodExpression().getReferenceName()) != null && METHOD_HANDLE_FACTORY_NAMES.contains(methodName)) {
            PsiClass psiClass;
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            PsiClass psiClass2 = psiClass = arguments.length != 0 ? JavaReflectionReferenceUtil.getReflectiveClass(arguments[0]) : null;
            if (psiClass != null) {
                switch (methodName) {
                    case "findConstructor": {
                        JavaMethodHandleCompletionContributor.addConstructorSignatures(psiClass, position, result2);
                        break;
                    }
                    case "findVirtual": 
                    case "findStatic": 
                    case "findSpecial": {
                        String name2;
                        String string = name2 = arguments.length > 1 ? JavaReflectionReferenceUtil.computeConstantExpression(arguments[1], String.class) : null;
                        if (StringUtil.isEmpty(name2)) break;
                        JavaMethodHandleCompletionContributor.addMethodSignatures(psiClass, name2, "findStatic".equals(methodName), position, result2);
                    }
                }
            }
        }
    }

    private static void addConstructorSignatures(@NotNull PsiClass psiClass, @NotNull PsiElement context, @NotNull Consumer<LookupElement> result2) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addConstructorSignatures"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addConstructorSignatures"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addConstructorSignatures"));
        }
        String className = psiClass.getName();
        if (className != null) {
            PsiMethod[] constructors = psiClass.getConstructors();
            if (constructors.length != 0) {
                JavaMethodHandleCompletionContributor.lookupMethodTypes(Arrays.stream(constructors), context, result2);
            } else {
                result2.consume((Object)JavaMethodHandleCompletionContributor.lookupSignature(JavaReflectionReferenceUtil.ReflectiveSignature.NO_ARGUMENT_CONSTRUCTOR_SIGNATURE, context));
            }
        }
    }

    private static void addMethodSignatures(@NotNull PsiClass psiClass, @NotNull String methodName, boolean isStaticExpected, @NotNull PsiElement context, @NotNull Consumer<LookupElement> result2) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addMethodSignatures"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addMethodSignatures"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addMethodSignatures"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addMethodSignatures"));
        }
        PsiMethod[] methods = psiClass.findMethodsByName(methodName, false);
        if (methods.length != 0) {
            Stream<PsiMethod> methodStream = Arrays.stream(methods).filter(method -> method.hasModifierProperty("static") == isStaticExpected);
            JavaMethodHandleCompletionContributor.lookupMethodTypes(methodStream, context, result2);
        }
    }

    private static void lookupMethodTypes(@NotNull Stream<PsiMethod> methods, @NotNull PsiElement context, @NotNull Consumer<LookupElement> result2) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "lookupMethodTypes"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "lookupMethodTypes"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "lookupMethodTypes"));
        }
        methods.map(JavaReflectionReferenceUtil::getMethodSignature).filter(Objects::nonNull).sorted(JavaReflectionReferenceUtil.ReflectiveSignature::compareTo).map(signature -> {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "lambda$lookupMethodTypes$1"));
            }
            return JavaMethodHandleCompletionContributor.lookupSignature(signature, context);
        }).forEach(arg_0 -> result2.consume(arg_0));
    }

    @NotNull
    private static LookupElement lookupSignature(@NotNull JavaReflectionReferenceUtil.ReflectiveSignature signature, @NotNull PsiElement context) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "lookupSignature"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "lookupSignature"));
        }
        String expressionText = JavaReflectionReferenceUtil.getMethodTypeExpressionText(signature);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        PsiExpression expression2 = factory.createExpressionFromText(expressionText, context);
        String shortTypes = signature.getText(true, type2 -> PsiNameHelper.getShortClassName((String)type2) + ".class");
        String presentableText = PsiNameHelper.getShortClassName((String)"java.lang.invoke.MethodType") + "." + "methodType" + shortTypes;
        String lookupText = "methodType" + signature.getText(true, PsiNameHelper::getShortClassName);
        LookupElement lookupElement = JavaMethodHandleCompletionContributor.lookupExpression(expression2, PlatformIcons.METHOD_ICON, presentableText, lookupText);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "lookupSignature"));
        }
        return lookupElement;
    }

    private static void addFieldHandleVariants(@NotNull PsiElement position, @NotNull Consumer<LookupElement> result2) {
        PsiClass psiClass;
        String fieldName;
        PsiExpression[] arguments;
        String methodName;
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addFieldHandleVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addFieldHandleVariants"));
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class);
        if (methodCall != null && (methodName = methodCall.getMethodExpression().getReferenceName()) != null && FIELD_HANDLE_FACTORY_NAMES.contains(methodName) && (arguments = methodCall.getArgumentList().getExpressions()).length > 2 && !StringUtil.isEmpty((String)(fieldName = JavaReflectionReferenceUtil.computeConstantExpression(arguments[1], String.class))) && (psiClass = JavaReflectionReferenceUtil.getReflectiveClass(arguments[0])) != null) {
            JavaMethodHandleCompletionContributor.addFieldType(psiClass, fieldName, position, result2);
        }
    }

    private static void addFieldType(@NotNull PsiClass psiClass, @NotNull String fieldName, @NotNull PsiElement context, @NotNull Consumer<LookupElement> result2) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addFieldType"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addFieldType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addFieldType"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "addFieldType"));
        }
        PsiField field = psiClass.findFieldByName(fieldName, false);
        if (field != null) {
            String typeText = JavaReflectionReferenceUtil.getTypeText(field.getType());
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
            PsiExpression expression2 = factory.createExpressionFromText(typeText + ".class", context);
            String shortType = PsiNameHelper.getShortClassName((String)typeText);
            result2.consume((Object)JavaMethodHandleCompletionContributor.lookupExpression(expression2, PlatformIcons.CLASS_ICON, shortType + ".class", shortType));
        }
    }

    @NotNull
    private static LookupElement lookupExpression(@NotNull PsiExpression expression2, @Nullable Icon icon, @NotNull String presentableText, @NotNull String lookupText) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "lookupExpression"));
        }
        if (presentableText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableText", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "lookupExpression"));
        }
        if (lookupText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupText", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "lookupExpression"));
        }
        ExpressionLookupItem element = new ExpressionLookupItem(expression2, icon, presentableText, new String[]{lookupText}){

            @Override
            public void handleInsert(InsertionContext context) {
                context.getDocument().deleteString(context.getStartOffset(), context.getTailOffset());
                context.commitDocument();
                JavaReflectionReferenceUtil.replaceText(context, this.getObject().getText());
            }
        };
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)element, (double)1.0);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaMethodHandleCompletionContributor", "lookupExpression"));
        }
        return lookupElement;
    }
}

