/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReflectionReferenceUtil {
    public static final String JAVA_LANG_INVOKE_METHOD_HANDLES_LOOKUP = "java.lang.invoke.MethodHandles.Lookup";
    public static final String JAVA_LANG_INVOKE_METHOD_TYPE = "java.lang.invoke.MethodType";
    public static final String METHOD_TYPE = "methodType";
    public static final String GENERIC_METHOD_TYPE = "genericMethodType";
    public static final String FIND_VIRTUAL = "findVirtual";
    public static final String FIND_STATIC = "findStatic";
    public static final String FIND_SPECIAL = "findSpecial";
    public static final String FIND_GETTER = "findGetter";
    public static final String FIND_SETTER = "findSetter";
    public static final String FIND_STATIC_GETTER = "findStaticGetter";
    public static final String FIND_STATIC_SETTER = "findStaticSetter";
    public static final String FIND_VAR_HANDLE = "findVarHandle";
    public static final String FIND_STATIC_VAR_HANDLE = "findStaticVarHandle";
    public static final String FIND_CONSTRUCTOR = "findConstructor";
    public static final String FIND_CLASS = "findClass";
    public static final String[] HANDLE_FACTORY_METHOD_NAMES = new String[]{"findVirtual", "findStatic", "findSpecial", "findGetter", "findSetter", "findStaticGetter", "findStaticSetter", "findVarHandle", "findStaticVarHandle"};
    public static final String GET_FIELD = "getField";
    public static final String GET_DECLARED_FIELD = "getDeclaredField";
    public static final String GET_METHOD = "getMethod";
    public static final String GET_DECLARED_METHOD = "getDeclaredMethod";
    public static final String GET_CONSTRUCTOR = "getConstructor";
    public static final String GET_DECLARED_CONSTRUCTOR = "getDeclaredConstructor";
    public static final String JAVA_LANG_CLASS_LOADER = "java.lang.ClassLoader";
    public static final String FOR_NAME = "forName";
    public static final String LOAD_CLASS = "loadClass";
    public static final String GET_CLASS = "getClass";
    public static final String NEW_INSTANCE = "newInstance";
    public static final String TYPE = "TYPE";
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"JavaLangClassMemberReference");

    @Nullable
    public static ReflectiveType getReflectiveType(@Nullable PsiExpression context) {
        PsiExpression definition;
        PsiElement resolved;
        PsiType type2;
        if ((context = ParenthesesUtils.stripParentheses(context)) == null) {
            return null;
        }
        if (context instanceof PsiClassObjectAccessExpression) {
            PsiTypeElement operand2 = ((PsiClassObjectAccessExpression)context).getOperand();
            return ReflectiveType.create(operand2.getType());
        }
        if (context instanceof PsiMethodCallExpression) {
            PsiMethod method;
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)context;
            String methodReferenceName = methodCall.getMethodExpression().getReferenceName();
            if (FOR_NAME.equals(methodReferenceName)) {
                PsiExpression argument;
                String className;
                PsiExpression[] expressions2;
                method = methodCall.resolveMethod();
                if (method != null && JavaReflectionReferenceUtil.isJavaLangClass(method.getContainingClass()) && (expressions2 = methodCall.getArgumentList().getExpressions()).length == 1 && (className = JavaReflectionReferenceUtil.computeConstantExpression(argument = JavaReflectionReferenceUtil.findDefinition(ParenthesesUtils.stripParentheses(expressions2[0])), String.class)) != null) {
                    return ReflectiveType.create(JavaReflectionReferenceUtil.findClass(className, (PsiElement)context));
                }
            } else if (GET_CLASS.equals(methodReferenceName) && methodCall.getArgumentList().getExpressions().length == 0 && (method = methodCall.resolveMethod()) != null && JavaReflectionReferenceUtil.isJavaLangObject(method.getContainingClass())) {
                PsiExpression definition2;
                PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodCall.getMethodExpression().getQualifierExpression());
                if (qualifier instanceof PsiReferenceExpression && (definition2 = JavaReflectionReferenceUtil.findVariableDefinition((PsiReferenceExpression)qualifier)) != null) {
                    return JavaReflectionReferenceUtil.getClassInstanceType(definition2);
                }
                if (qualifier != null) {
                    return JavaReflectionReferenceUtil.getClassInstanceType(qualifier);
                }
            }
        }
        if ((type2 = context.getType()) instanceof PsiClassType) {
            PsiType typeArgument;
            PsiType erasure;
            PsiClass argumentClass;
            PsiPrimitiveType unboxedType;
            PsiField field;
            PsiElement resolved2;
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type2).resolveGenerics();
            PsiClass resolvedElement = resolveResult.getElement();
            if (!JavaReflectionReferenceUtil.isJavaLangClass(resolvedElement)) {
                return null;
            }
            if (context instanceof PsiReferenceExpression && TYPE.equals(((PsiReferenceExpression)context).getReferenceName()) && (resolved2 = ((PsiReferenceExpression)context).resolve()) instanceof PsiField && (field = (PsiField)resolved2).hasModifierProperty("final") && field.hasModifierProperty("static") && (unboxedType = JavaReflectionReferenceUtil.tryUnbox(field.getContainingClass(), (PsiClassType)type2)) != null) {
                return ReflectiveType.create((PsiType)unboxedType);
            }
            PsiTypeParameter[] parameters2 = resolvedElement.getTypeParameters();
            if (parameters2.length == 1 && (argumentClass = PsiTypesUtil.getPsiClass((PsiType)(erasure = TypeConversionUtil.erasure((PsiType)(typeArgument = resolveResult.getSubstitutor().substitute(parameters2[0])))))) != null && !JavaReflectionReferenceUtil.isJavaLangObject(argumentClass)) {
                return ReflectiveType.create(argumentClass);
            }
        }
        if (context instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)context).resolve()) instanceof PsiVariable && (definition = JavaReflectionReferenceUtil.findVariableDefinition((PsiReferenceExpression)context, (PsiVariable)resolved)) != null) {
            return (ReflectiveType)ourGuard.doPreventingRecursion((Object)resolved, false, () -> JavaReflectionReferenceUtil.getReflectiveType(definition));
        }
        return null;
    }

    @Nullable
    private static ReflectiveType getClassInstanceType(@Nullable PsiExpression expression2) {
        PsiMethod method;
        PsiMethodCallExpression methodCall;
        String methodReferenceName;
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
            return null;
        }
        if (expression2 instanceof PsiMethodCallExpression && NEW_INSTANCE.equals(methodReferenceName = (methodCall = (PsiMethodCallExpression)expression2).getMethodExpression().getReferenceName()) && (method = methodCall.resolveMethod()) != null) {
            PsiExpression typeExpression;
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            if (arguments.length == 0 && JavaReflectionReferenceUtil.isClassWithName(method.getContainingClass(), "java.lang.Class")) {
                PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
                if (qualifier != null) {
                    return (ReflectiveType)ourGuard.doPreventingRecursion((Object)qualifier, false, () -> JavaReflectionReferenceUtil.getReflectiveType(qualifier));
                }
            } else if (arguments.length > 1 && JavaReflectionReferenceUtil.isClassWithName(method.getContainingClass(), "java.lang.reflect.Array") && (typeExpression = arguments[0]) != null) {
                ReflectiveType itemType = (ReflectiveType)ourGuard.doPreventingRecursion((Object)typeExpression, false, () -> JavaReflectionReferenceUtil.getReflectiveType(typeExpression));
                return ReflectiveType.arrayOf(itemType);
            }
        }
        return ReflectiveType.create(expression2.getType());
    }

    @Contract(value="null,_->null")
    @Nullable
    public static <T> T computeConstantExpression(@Nullable PsiExpression expression2, @NotNull Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "computeConstantExpression"));
        }
        expression2 = ParenthesesUtils.stripParentheses(expression2);
        Object computed = JavaConstantExpressionEvaluator.computeConstantExpression(expression2, false);
        return (T)ObjectUtils.tryCast((Object)computed, expectedType);
    }

    @Nullable
    public static PsiClass getReflectiveClass(PsiExpression context) {
        ReflectiveType reflectiveType = JavaReflectionReferenceUtil.getReflectiveType(context);
        return reflectiveType != null ? reflectiveType.getPsiClass() : null;
    }

    @Nullable
    public static PsiExpression findDefinition(@Nullable PsiExpression expression2) {
        int preventEndlessLoop = 5;
        while (expression2 instanceof PsiReferenceExpression) {
            if (--preventEndlessLoop == 0) {
                return null;
            }
            expression2 = JavaReflectionReferenceUtil.findVariableDefinition((PsiReferenceExpression)expression2);
        }
        return expression2;
    }

    @Nullable
    private static PsiExpression findVariableDefinition(@NotNull PsiReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "findVariableDefinition"));
        }
        PsiElement resolved = referenceExpression.resolve();
        return resolved instanceof PsiVariable ? JavaReflectionReferenceUtil.findVariableDefinition(referenceExpression, (PsiVariable)resolved) : null;
    }

    @Nullable
    private static PsiExpression findVariableDefinition(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable variable) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "findVariableDefinition"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "findVariableDefinition"));
        }
        if (variable.hasModifierProperty("final")) {
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                return initializer;
            }
            if (variable instanceof PsiField) {
                return JavaReflectionReferenceUtil.findFinalFieldDefinition(referenceExpression, (PsiField)variable);
            }
        }
        return DeclarationSearchUtils.findDefinition(referenceExpression, variable);
    }

    @Nullable
    private static PsiExpression findFinalFieldDefinition(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiField field) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "findFinalFieldDefinition"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "findFinalFieldDefinition"));
        }
        if (!field.hasModifierProperty("final")) {
            return null;
        }
        PsiClass psiClass = (PsiClass)ObjectUtils.tryCast((Object)field.getParent(), PsiClass.class);
        if (psiClass != null) {
            boolean isStatic = field.hasModifierProperty("static");
            List initializers = ContainerUtil.filter((Object[])psiClass.getInitializers(), initializer -> initializer.hasModifierProperty("static") == isStatic);
            for (PsiClassInitializer initializer2 : initializers) {
                PsiExpression assignedExpression = JavaReflectionReferenceUtil.getAssignedExpression((PsiMember)initializer2, field);
                if (assignedExpression == null) continue;
                return assignedExpression;
            }
            if (!isStatic) {
                PsiMethod[] constructors = psiClass.getConstructors();
                if (constructors.length == 1) {
                    return JavaReflectionReferenceUtil.getAssignedExpression((PsiMember)constructors[0], field);
                }
                for (PsiMethod constructor : constructors) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)constructor, (PsiElement)referenceExpression, (boolean)true)) continue;
                    return JavaReflectionReferenceUtil.getAssignedExpression((PsiMember)constructor, field);
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiExpression getAssignedExpression(@NotNull PsiMember maybeContainsAssignment, @NotNull PsiField field) {
        if (maybeContainsAssignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maybeContainsAssignment", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "getAssignedExpression"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "getAssignedExpression"));
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)SyntaxTraverser.psiTraverser((PsiElement)maybeContainsAssignment).filter(PsiAssignmentExpression.class).find(expression2 -> {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "lambda$getAssignedExpression$4"));
            }
            return VariableAccessUtils.evaluatesToVariable(expression2.getLExpression(), (PsiVariable)field);
        });
        return assignment != null ? assignment.getRExpression() : null;
    }

    @Nullable
    private static PsiPrimitiveType tryUnbox(@Nullable PsiClass psiClass, @NotNull PsiClassType originalType) {
        PsiElementFactory factory;
        PsiClassType classType;
        PsiPrimitiveType unboxedType;
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "tryUnbox"));
        }
        if (psiClass != null && TypeConversionUtil.isPrimitiveWrapper((String)psiClass.getQualifiedName()) && (unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)(classType = (factory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory()).createType(psiClass, PsiSubstitutor.EMPTY, originalType.getLanguageLevel())))) != null) {
            return unboxedType;
        }
        return null;
    }

    private static PsiClass findClass(@NotNull String qualifiedName, @NotNull PsiElement context) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", FIND_CLASS));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", FIND_CLASS));
        }
        Project project2 = context.getProject();
        return JavaPsiFacade.getInstance((Project)project2).findClass(qualifiedName, GlobalSearchScope.allScope((Project)project2));
    }

    @Contract(value="null -> false")
    static boolean isJavaLangClass(@Nullable PsiClass aClass) {
        return JavaReflectionReferenceUtil.isClassWithName(aClass, "java.lang.Class");
    }

    @Contract(value="null -> false")
    static boolean isJavaLangObject(@Nullable PsiClass aClass) {
        return JavaReflectionReferenceUtil.isClassWithName(aClass, "java.lang.Object");
    }

    @Contract(value="null, _ -> false")
    public static boolean isClassWithName(@Nullable PsiClass aClass, @NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "isClassWithName"));
        }
        return aClass != null && name2.equals(aClass.getQualifiedName());
    }

    @Contract(value="null -> false")
    static boolean isRegularMethod(@Nullable PsiMethod method) {
        return method != null && !method.isConstructor();
    }

    static boolean isPublic(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "isPublic"));
        }
        return member.hasModifierProperty("public");
    }

    @Nullable
    static String getParameterTypesText(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "getParameterTypesText"));
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            String typeText = JavaReflectionReferenceUtil.getTypeText(parameter.getType());
            joiner.add(typeText + ".class");
        }
        return joiner.toString();
    }

    static void shortenArgumentsClassReferences(@NotNull InsertionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "shortenArgumentsClassReferences"));
        }
        PsiElement parameter = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset());
        PsiExpressionList parameterList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiExpressionList.class);
        if (parameterList != null && parameterList.getParent() instanceof PsiMethodCallExpression) {
            JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)parameterList);
        }
    }

    @NotNull
    static LookupElement withPriority(@NotNull LookupElement lookupElement, boolean hasPriority) {
        if (lookupElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupElement", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "withPriority"));
        }
        LookupElement lookupElement2 = hasPriority ? lookupElement : PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)-1.0);
        if (lookupElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "withPriority"));
        }
        return lookupElement2;
    }

    @Nullable
    static LookupElement withPriority(@Nullable LookupElement lookupElement, int priority) {
        return priority == 0 || lookupElement == null ? lookupElement : PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)priority);
    }

    static int getMethodSortOrder(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "getMethodSortOrder"));
        }
        return JavaReflectionReferenceUtil.isJavaLangObject(method.getContainingClass()) ? 1 : (JavaReflectionReferenceUtil.isPublic((PsiMember)method) ? -1 : 0);
    }

    @Nullable
    static String getMemberType(@Nullable PsiElement element) {
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        return methodCall != null ? methodCall.getMethodExpression().getReferenceName() : null;
    }

    @NotNull
    static LookupElement lookupField(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "lookupField"));
        }
        LookupElementBuilder lookupElementBuilder = JavaLookupElementBuilder.forField(field);
        if (lookupElementBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "lookupField"));
        }
        return lookupElementBuilder;
    }

    @Nullable
    static LookupElement lookupMethod(@NotNull PsiMethod method, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "lookupMethod"));
        }
        ReflectiveSignature signature = JavaReflectionReferenceUtil.getMethodSignature(method);
        return signature != null ? LookupElementBuilder.create((Object)signature, (String)method.getName()).withIcon(signature.getIcon()).withTailText(signature.getShortArgumentTypes()).withInsertHandler(insertHandler) : null;
    }

    static void replaceText(@NotNull InsertionContext context, @NotNull String text2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "replaceText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "replaceText"));
        }
        PsiElement newElement = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset());
        PsiElement params = newElement.getParent().getParent();
        int end = params.getTextRange().getEndOffset() - 1;
        int start = Math.min(newElement.getTextRange().getEndOffset(), end);
        context.getDocument().replaceString(start, end, (CharSequence)text2);
        context.commitDocument();
        JavaReflectionReferenceUtil.shortenArgumentsClassReferences(context);
    }

    @NotNull
    public static String getTypeText(@NotNull PsiType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "getTypeText"));
        }
        ReflectiveType reflectiveType = ReflectiveType.create(type2);
        String string = reflectiveType.getQualifiedName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "getTypeText"));
        }
        return string;
    }

    @Nullable
    public static String getTypeText(@Nullable PsiExpression argument) {
        ReflectiveType reflectiveType = JavaReflectionReferenceUtil.getReflectiveType(argument);
        return reflectiveType != null ? reflectiveType.getQualifiedName() : null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static ReflectiveSignature getMethodSignature(@Nullable PsiMethod method) {
        if (method != null) {
            ArrayList<String> types = new ArrayList<String>();
            PsiType returnType = method.getReturnType();
            types.add(JavaReflectionReferenceUtil.getTypeText((PsiType)(returnType != null ? returnType : PsiType.VOID)));
            for (PsiParameter parameter : method.getParameterList().getParameters()) {
                types.add(JavaReflectionReferenceUtil.getTypeText(parameter.getType()));
            }
            Icon icon = method.getIcon(1);
            return ReflectiveSignature.create(icon, types);
        }
        return null;
    }

    @NotNull
    public static String getMethodTypeExpressionText(@NotNull ReflectiveSignature signature) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "getMethodTypeExpressionText"));
        }
        String types = signature.getText(true, type2 -> type2 + ".class");
        String string = "java.lang.invoke.MethodType.methodType" + types;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "getMethodTypeExpressionText"));
        }
        return string;
    }

    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression methodCall, @NotNull String className, @NotNull String methodName) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "isCallToMethod"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "isCallToMethod"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil", "isCallToMethod"));
        }
        return MethodCallUtils.isCallToMethod(methodCall, className, null, methodName, (PsiType[])null);
    }

    public static class ReflectiveSignature
    implements Comparable<ReflectiveSignature> {
        public static final ReflectiveSignature NO_ARGUMENT_CONSTRUCTOR_SIGNATURE = new ReflectiveSignature(null, "void", ArrayUtil.EMPTY_STRING_ARRAY);
        private final Icon myIcon;
        @NotNull
        private final String myReturnType;
        @NotNull
        private final String[] myArgumentTypes;

        @Nullable
        public static ReflectiveSignature create(@NotNull List<String> typeTexts) {
            if (typeTexts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeTexts", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveSignature", "create"));
            }
            return ReflectiveSignature.create(null, typeTexts);
        }

        @Nullable
        public static ReflectiveSignature create(@Nullable Icon icon, @NotNull List<String> typeTexts) {
            if (typeTexts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeTexts", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveSignature", "create"));
            }
            if (!typeTexts.isEmpty() && !typeTexts.contains(null)) {
                String[] argumentTypes = ArrayUtil.toStringArray(typeTexts.subList(1, typeTexts.size()));
                return new ReflectiveSignature(icon, typeTexts.get(0), argumentTypes);
            }
            return null;
        }

        private ReflectiveSignature(@Nullable Icon icon, @NotNull String returnType, @NotNull String[] argumentTypes) {
            if (returnType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveSignature", "<init>"));
            }
            if (argumentTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveSignature", "<init>"));
            }
            this.myIcon = icon;
            this.myReturnType = returnType;
            this.myArgumentTypes = argumentTypes;
        }

        public String getText(boolean withReturnType, @NotNull Function<String, String> transformation) {
            if (transformation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformation", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveSignature", "getText"));
            }
            return this.getText(withReturnType, true, transformation);
        }

        public String getText(boolean withReturnType, boolean withParentheses, @NotNull Function<String, String> transformation) {
            if (transformation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformation", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveSignature", "getText"));
            }
            StringJoiner joiner = new StringJoiner(", ", withParentheses ? "(" : "", withParentheses ? ")" : "");
            if (withReturnType) {
                joiner.add(transformation.apply(this.myReturnType));
            }
            for (String argumentType : this.myArgumentTypes) {
                joiner.add(transformation.apply(argumentType));
            }
            return joiner.toString();
        }

        @NotNull
        public String getShortReturnType() {
            String string = PsiNameHelper.getShortClassName((String)this.myReturnType);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveSignature", "getShortReturnType"));
            }
            return string;
        }

        @NotNull
        public String getShortArgumentTypes() {
            String string = this.getText(false, PsiNameHelper::getShortClassName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveSignature", "getShortArgumentTypes"));
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon != null ? this.myIcon : PlatformIcons.METHOD_ICON;
        }

        @Override
        public int compareTo(@NotNull ReflectiveSignature other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveSignature", "compareTo"));
            }
            int c = this.myArgumentTypes.length - other.myArgumentTypes.length;
            if (c != 0) {
                return c;
            }
            c = ArrayUtil.lexicographicCompare((String[])this.myArgumentTypes, (String[])other.myArgumentTypes);
            if (c != 0) {
                return c;
            }
            return this.myReturnType.compareTo(other.myReturnType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReflectiveSignature)) {
                return false;
            }
            ReflectiveSignature other = (ReflectiveSignature)o;
            return Objects.equals(this.myReturnType, other.myReturnType) && Arrays.equals(this.myArgumentTypes, other.myArgumentTypes);
        }

        public int hashCode() {
            return Objects.hash(this.myReturnType, this.myArgumentTypes);
        }

        public String toString() {
            return this.myReturnType + " " + Arrays.toString(this.myArgumentTypes);
        }
    }

    public static class ReflectiveType {
        final PsiType myType;

        private ReflectiveType(@NotNull PsiType erasedType) {
            if (erasedType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "erasedType", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveType", "<init>"));
            }
            this.myType = erasedType;
        }

        @NotNull
        public String getQualifiedName() {
            String string = this.myType.getCanonicalText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveType", "getQualifiedName"));
            }
            return string;
        }

        public String toString() {
            return this.myType.getCanonicalText();
        }

        public boolean isEqualTo(@Nullable PsiType otherType) {
            return otherType != null && this.myType.equals(ReflectiveType.erasure(otherType));
        }

        public boolean isAssignableFrom(@NotNull PsiType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveType", "isAssignableFrom"));
            }
            return this.myType.isAssignableFrom(type2);
        }

        public boolean isPrimitive() {
            return this.myType instanceof PsiPrimitiveType;
        }

        @NotNull
        public PsiType getType() {
            PsiType psiType = this.myType;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveType", "getType"));
            }
            return psiType;
        }

        @Nullable
        public PsiClass getPsiClass() {
            return PsiTypesUtil.getPsiClass((PsiType)this.myType);
        }

        @Contract(value="!null -> !null; null -> null")
        @Nullable
        public static ReflectiveType create(@Nullable PsiType originalType) {
            if (originalType != null) {
                return new ReflectiveType(ReflectiveType.erasure(originalType));
            }
            return null;
        }

        @Contract(value="!null -> !null; null -> null")
        @Nullable
        public static ReflectiveType create(@Nullable PsiClass psiClass) {
            if (psiClass != null) {
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
                return new ReflectiveType((PsiType)factory.createType(psiClass));
            }
            return null;
        }

        @Contract(value="!null -> !null; null -> null")
        @Nullable
        public static ReflectiveType arrayOf(@Nullable ReflectiveType itemType) {
            if (itemType != null) {
                return new ReflectiveType((PsiType)itemType.myType.createArrayType());
            }
            return null;
        }

        @NotNull
        private static PsiType erasure(@NotNull PsiType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveType", "erasure"));
            }
            PsiType erasure = TypeConversionUtil.erasure((PsiType)type2);
            if (erasure instanceof PsiEllipsisType) {
                PsiType psiType = ((PsiEllipsisType)erasure).toArrayType();
                if (psiType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveType", "erasure"));
                }
                return psiType;
            }
            PsiType psiType = erasure;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaReflectionReferenceUtil$ReflectiveType", "erasure"));
            }
            return psiType;
        }
    }
}

