/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackagePrefixFileSystemItemImpl;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathReferenceProvider
extends PsiReferenceProvider {
    private final boolean myEndingSlashNotAllowed;

    public FilePathReferenceProvider() {
        this(true);
    }

    public FilePathReferenceProvider(boolean endingSlashNotAllowed) {
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, String text2, int offset, boolean soft) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = this.getReferencesByElement(element, text2, offset, soft, Module.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, String text2, int offset, final boolean soft, final Module ... forModules) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider", "getReferencesByElement"));
        }
        if (forModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forModules", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new FileReferenceSet(text2, element, offset, this, true, this.myEndingSlashNotAllowed){

            @Override
            protected boolean isSoft() {
                return soft;
            }

            @Override
            public boolean isAbsolutePathReference() {
                return true;
            }

            @Override
            public boolean couldBeConvertedTo(boolean relative) {
                return !relative;
            }

            @Override
            public boolean absoluteUrlNeedsStartSlash() {
                String s = this.getPathString();
                return s != null && !s.isEmpty() && s.charAt(0) == '/';
            }

            @Override
            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                if (forModules.length > 0) {
                    LinkedHashSet rootsForModules = ContainerUtil.newLinkedHashSet();
                    for (Module forModule : forModules) {
                        rootsForModules.addAll(FilePathReferenceProvider.getRoots(forModule, true));
                    }
                    LinkedHashSet linkedHashSet = rootsForModules;
                    if (linkedHashSet == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider$1", "computeDefaultContexts"));
                    }
                    return linkedHashSet;
                }
                Collection<PsiFileSystemItem> collection = FilePathReferenceProvider.getRoots(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()), true);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider$1", "computeDefaultContexts"));
                }
                return collection;
            }

            @Override
            public FileReference createFileReference(TextRange range, int index, String text2) {
                return FilePathReferenceProvider.this.createFileReference(this, range, index, text2);
            }

            @Override
            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return element1 -> FilePathReferenceProvider.this.isPsiElementAccepted((PsiElement)element1);
            }
        }.getAllReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public boolean acceptsTarget(@NotNull PsiElement target2) {
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider", "acceptsTarget"));
        }
        return target2 instanceof PsiFileSystemItem;
    }

    protected boolean isPsiElementAccepted(PsiElement element) {
        return !(element instanceof PsiJavaFile) || !(element instanceof PsiCompiledElement);
    }

    protected FileReference createFileReference(FileReferenceSet referenceSet, TextRange range, int index, String text2) {
        return new FileReference(referenceSet, range, index, text2);
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Object value2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider", "getReferencesByElement"));
        }
        String text2 = null;
        if (element instanceof PsiLiteralExpression && (value2 = ((PsiLiteralExpression)element).getValue()) instanceof String) {
            text2 = (String)value2;
        }
        if (text2 == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = this.getReferencesByElement(element, text2, 1, true);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public static Collection<PsiFileSystemItem> getRoots(@Nullable Module thisModule, boolean includingClasses) {
        PsiDirectory directory;
        if (thisModule == null) {
            List<PsiFileSystemItem> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider", "getRoots"));
            }
            return list2;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)thisModule);
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        PsiManager psiManager = PsiManager.getInstance((Project)thisModule.getProject());
        if (includingClasses) {
            VirtualFile[] libraryUrls;
            for (VirtualFile file2 : libraryUrls = moduleRootManager.orderEntries().getAllLibrariesAndSdkClassesRoots()) {
                directory = psiManager.findDirectory(file2);
                if (directory == null) continue;
                result2.add(directory);
            }
        }
        VirtualFile[] sourceRoots = moduleRootManager.orderEntries().recursively().withoutSdk().withoutLibraries().sources().usingCache().getRoots();
        for (VirtualFile root : sourceRoots) {
            directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage != null && aPackage.getName() != null) {
                result2.add(PackagePrefixFileSystemItemImpl.create(directory));
                continue;
            }
            result2.add(directory);
        }
        LinkedHashSet linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FilePathReferenceProvider", "getRoots"));
        }
        return linkedHashSet;
    }
}

