/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PackagePrefixFileSystemItem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PackagePrefixFileSystemItemImpl
extends PsiElementBase
implements PsiFileSystemItem,
PackagePrefixFileSystemItem {
    @NotNull
    private final PsiDirectory myDirectory;
    private final int myIndex;
    private final PsiPackage[] myPackages;

    public static PackagePrefixFileSystemItemImpl create(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "create"));
        }
        ArrayList<PsiPackage> packages = new ArrayList<PsiPackage>();
        for (PsiPackage cur = JavaDirectoryService.getInstance().getPackage(directory); cur != null; cur = cur.getParentPackage()) {
            packages.add(0, cur);
        }
        return new PackagePrefixFileSystemItemImpl(directory, 0, packages.toArray(new PsiPackage[packages.size()]));
    }

    private PackagePrefixFileSystemItemImpl(@NotNull PsiDirectory directory, int index, PsiPackage[] packages) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "<init>"));
        }
        this.myDirectory = directory;
        this.myIndex = index;
        this.myPackages = packages;
    }

    @Override
    @NotNull
    public String getName() {
        String string = StringUtil.notNullize((String)this.myPackages[this.myIndex].getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "setName"));
        }
        throw new IncorrectOperationException();
    }

    public void checkSetName(String name2) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public boolean isDirectory() {
        return true;
    }

    public PsiFileSystemItem getParent() {
        return this.myIndex > 0 ? new PackagePrefixFileSystemItemImpl(this.myDirectory, this.myIndex - 1, this.myPackages) : this.myDirectory.getParent();
    }

    @Override
    public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
        return null;
    }

    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return 0;
    }

    public int getTextLength() {
        return 0;
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return 0;
    }

    @NonNls
    public String getText() {
        return "";
    }

    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "textToCharArray"));
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull @NonNls CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "textMatches"));
        }
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "textMatches"));
        }
        return false;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "accept"));
        }
    }

    @Override
    public PsiElement copy() {
        return null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "add"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "addBefore"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "addAfter"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "checkAdd"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "replace"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isValid() {
        return this.myDirectory.isValid();
    }

    @Override
    public boolean isWritable() {
        VirtualFile file2 = this.getVirtualFile();
        return file2 != null && file2.isWritable();
    }

    @Override
    public boolean isPhysical() {
        VirtualFile file2 = this.getVirtualFile();
        return file2 != null && !(file2.getFileSystem() instanceof NonPhysicalFileSystem);
    }

    @Nullable
    public ASTNode getNode() {
        return null;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        if (this.myIndex == this.myPackages.length - 1) {
            return this.myDirectory.processChildren(processor2);
        }
        return processor2.execute((PsiElement)new PackagePrefixFileSystemItemImpl(this.myDirectory, this.myIndex + 1, this.myPackages));
    }

    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "getLanguage"));
        }
        return language;
    }

    @Override
    public PsiManager getManager() {
        return this.myDirectory.getManager();
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        if (this.myIndex == this.myPackages.length - 1) {
            psiElementArray = this.myDirectory.getChildren();
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = new PackagePrefixFileSystemItemImpl(this.myDirectory, this.myIndex + 1, this.myPackages);
        }
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public boolean canNavigate() {
        return this.getVirtualFile() != null;
    }

    public VirtualFile getVirtualFile() {
        if (this.myIndex == this.myPackages.length - 1) {
            return this.myDirectory.getVirtualFile();
        }
        return null;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return this.myDirectory.getIcon(flags);
    }

    @NotNull
    public PsiDirectory getDirectory() {
        PsiDirectory psiDirectory = this.myDirectory;
        if (psiDirectory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PackagePrefixFileSystemItemImpl", "getDirectory"));
        }
        return psiDirectory;
    }
}

