/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiPackageReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    private final PackageReferenceSet myReferenceSet;
    protected final int myIndex;

    public PsiPackageReference(PackageReferenceSet set2, TextRange range, int index) {
        super(set2.getElement(), range, set2.isSoft());
        this.myReferenceSet = set2;
        this.myIndex = index;
    }

    @NotNull
    protected Set<PsiPackage> getContext() {
        if (this.myIndex == 0) {
            Set<PsiPackage> set2 = this.myReferenceSet.getInitialContext();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference", "getContext"));
            }
            return set2;
        }
        HashSet<PsiPackage> psiPackages = new HashSet<PsiPackage>();
        for (ResolveResult resolveResult : ((PsiPackageReference)this.myReferenceSet.getReference(this.myIndex - 1)).doMultiResolve()) {
            PsiElement psiElement = resolveResult.getElement();
            if (!(psiElement instanceof PsiPackage)) continue;
            psiPackages.add((PsiPackage)psiElement);
        }
        HashSet<PsiPackage> hashSet = psiPackages;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference", "getContext"));
        }
        return hashSet;
    }

    @NotNull
    public Object[] getVariants() {
        HashSet<PsiPackage> subPackages = new HashSet<PsiPackage>();
        for (PsiPackage psiPackage : this.getContext()) {
            subPackages.addAll(Arrays.asList(psiPackage.getSubPackages(this.myReferenceSet.getResolveScope())));
        }
        Object[] objectArray = subPackages.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = JavaErrorMessages.message("cannot.resolve.package", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = this.doMultiResolve();
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    protected ResolveResult[] doMultiResolve() {
        HashSet<PsiPackage> packages = new HashSet<PsiPackage>();
        for (PsiPackage parentPackage : this.getContext()) {
            packages.addAll(this.myReferenceSet.resolvePackageName(parentPackage, this.getValue()));
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(packages);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference", "doMultiResolve"));
        }
        return resolveResultArray;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiPackageReference", "bindToElement"));
        }
        if (!(element instanceof PsiPackage)) {
            throw new IncorrectOperationException("Cannot bind to " + element);
        }
        TextRange range = new TextRange(((PsiPackageReference)this.getReferenceSet().getReference(0)).getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset());
        String newName = ((PsiPackage)element).getQualifiedName();
        return ElementManipulators.getManipulator((PsiElement)this.getElement()).handleContentChange(this.getElement(), range, newName);
    }

    public PackageReferenceSet getReferenceSet() {
        return this.myReferenceSet;
    }
}

