/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.annotations.NotNull;

public class ASTStructure
implements FlyweightCapableTreeStructure<ASTNode> {
    private final ASTNode myRoot;

    public ASTStructure(@NotNull ASTNode root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/impl/source/tree/ASTStructure", "<init>"));
        }
        this.myRoot = root;
    }

    @NotNull
    public ASTNode getRoot() {
        ASTNode aSTNode = this.myRoot;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/ASTStructure", "getRoot"));
        }
        return aSTNode;
    }

    public ASTNode getParent(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/ASTStructure", "getParent"));
        }
        return node.getTreeParent();
    }

    public int getChildren(@NotNull ASTNode astNode, @NotNull Ref<ASTNode[]> into) {
        if (astNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/psi/impl/source/tree/ASTStructure", "getChildren"));
        }
        if (into == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "into", "com/intellij/psi/impl/source/tree/ASTStructure", "getChildren"));
        }
        ASTNode child = astNode.getFirstChildNode();
        if (child == null) {
            return 0;
        }
        ASTNode[] store = (ASTNode[])into.get();
        if (store == null) {
            store = new ASTNode[10];
            into.set((Object)store);
        }
        int count = 0;
        while (child != null) {
            if (count >= store.length) {
                ASTNode[] newStore = new ASTNode[count * 3 / 2];
                System.arraycopy(store, 0, newStore, 0, count);
                into.set((Object)newStore);
                store = newStore;
            }
            store[count++] = child;
            child = child.getTreeNext();
        }
        return count;
    }

    public void disposeChildren(ASTNode[] nodes, int count) {
    }

    @NotNull
    public CharSequence toString(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/ASTStructure", "toString"));
        }
        CharSequence charSequence = node.getChars();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/ASTStructure", "toString"));
        }
        return charSequence;
    }

    public int getStartOffset(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/ASTStructure", "getStartOffset"));
        }
        return node.getStartOffset();
    }

    public int getEndOffset(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/ASTStructure", "getEndOffset"));
        }
        return node.getStartOffset() + node.getTextLength();
    }
}

