/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.injected.Place;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;

class LeafPatcher
extends RecursiveTreeElementWalkingVisitor {
    private int shredNo;
    private String hostText;
    private TextRange rangeInHost;
    private final Place myShreds;
    private final List<LiteralTextEscaper<? extends PsiLanguageInjectionHost>> myEscapers;
    final Map<LeafElement, String> newTexts = new THashMap();
    final StringBuilder catLeafs = new StringBuilder();
    static final Key<String> UNESCAPED_TEXT = Key.create((String)"INJECTED_UNESCAPED_TEXT");

    LeafPatcher(Place shreds, List<LiteralTextEscaper<? extends PsiLanguageInjectionHost>> escapers) {
        this.myShreds = shreds;
        this.myEscapers = escapers;
    }

    @Override
    public void visitLeaf(LeafElement leaf) {
        String leafText = leaf instanceof ForeignLeafPsiElement ? "" : leaf.getText();
        this.catLeafs.append(leafText);
        TextRange leafRange = leaf.getTextRange();
        StringBuilder leafEncodedText = this.constructTextFromHostPSI(leafRange.getStartOffset(), leafRange.getEndOffset());
        if (!Comparing.equal((CharSequence)leafText, (CharSequence)leafEncodedText)) {
            this.newTexts.put(leaf, leafEncodedText.toString());
            LeafPatcher.storeUnescapedTextFor(leaf, leafText);
        }
    }

    private StringBuilder constructTextFromHostPSI(int startOffset, int endOffset) {
        boolean firstTimer = false;
        PsiLanguageInjectionHost.Shred current = (PsiLanguageInjectionHost.Shred)this.myShreds.get(this.shredNo);
        if (this.hostText == null) {
            this.hostText = current.getHost().getText();
            this.rangeInHost = current.getRangeInsideHost();
            firstTimer = true;
        }
        StringBuilder text2 = new StringBuilder(endOffset - startOffset);
        while (startOffset < endOffset) {
            TextRange shredRange = current.getRange();
            String prefix = current.getPrefix();
            if (startOffset >= shredRange.getEndOffset()) {
                current = (PsiLanguageInjectionHost.Shred)this.myShreds.get(++this.shredNo);
                this.hostText = current.getHost().getText();
                this.rangeInHost = current.getRangeInsideHost();
                firstTimer = true;
                continue;
            }
            assert (startOffset >= shredRange.getStartOffset());
            if (startOffset - shredRange.getStartOffset() < prefix.length()) {
                TextRange rangeInPrefix = new TextRange(startOffset - shredRange.getStartOffset(), Math.min(prefix.length(), endOffset - shredRange.getStartOffset()));
                text2.append(prefix, rangeInPrefix.getStartOffset(), rangeInPrefix.getEndOffset());
                startOffset += rangeInPrefix.getLength();
                continue;
            }
            String suffix = current.getSuffix();
            if (startOffset < shredRange.getEndOffset() - suffix.length()) {
                int startOffsetInHost = this.myEscapers.get(this.shredNo).getOffsetInHost(startOffset - shredRange.getStartOffset() - prefix.length(), this.rangeInHost);
                int endOffsetCut = Math.min(endOffset, shredRange.getEndOffset() - suffix.length());
                int endOffsetInHost = this.myEscapers.get(this.shredNo).getOffsetInHost(endOffsetCut - shredRange.getStartOffset() - prefix.length(), this.rangeInHost);
                if (endOffsetInHost != -1) {
                    if (firstTimer) {
                        text2.append(this.hostText, this.rangeInHost.getStartOffset(), startOffsetInHost);
                    }
                    text2.append(this.hostText, startOffsetInHost, endOffsetInHost);
                    startOffset = endOffsetCut;
                    continue;
                }
            }
            TextRange rangeInSuffix = new TextRange(suffix.length() - shredRange.getEndOffset() + startOffset, Math.min(suffix.length(), endOffset + suffix.length() - shredRange.getEndOffset()));
            text2.append(suffix, rangeInSuffix.getStartOffset(), rangeInSuffix.getEndOffset());
            startOffset += rangeInSuffix.getLength();
        }
        return text2;
    }

    private static void storeUnescapedTextFor(LeafElement leaf, String leafText) {
        PsiElement psi = leaf.getPsi();
        if (psi != null) {
            psi.putCopyableUserData(UNESCAPED_TEXT, (Object)leafText);
        }
    }
}

