/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.impl.source.xml.PossiblePrefixReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.xml.XmlExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaPrefixReference
extends PsiReferenceBase<XmlElement>
implements PossiblePrefixReference,
ResolvingHint {
    private final SchemaPrefix myPrefix;
    private final String myName;
    @Nullable
    private final TagNameReference myTagNameReference;

    public SchemaPrefixReference(XmlElement element, TextRange range, String name2, @Nullable TagNameReference reference) {
        super((PsiElement)element, range);
        this.myName = name2;
        this.myTagNameReference = reference;
        this.myPrefix = this.myElement instanceof XmlAttribute && ((XmlAttribute)this.myElement).isNamespaceDeclaration() ? new SchemaPrefix((XmlAttribute)this.myElement, this.getRangeInElement(), this.myName) : (this.myElement instanceof XmlAttributeValue && ((XmlAttribute)((XmlElement)this.myElement).getParent()).getLocalName().equals("prefix") ? SchemaPrefix.createJspPrefix((XmlAttributeValue)this.myElement, this.myName) : null);
    }

    public String getNamespacePrefix() {
        return this.myName;
    }

    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        return ReflectionUtil.isAssignable(XmlElement.class, elementClass);
    }

    public SchemaPrefix resolve() {
        return this.myPrefix == null ? SchemaPrefixReference.resolvePrefix(this.myElement, this.myName) : this.myPrefix;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/SchemaPrefixReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof SchemaPrefix) || !this.myName.equals(((SchemaPrefix)element).getName())) {
            return false;
        }
        return super.isReferenceTo(element);
    }

    public PsiElement handleElementRename(String name2) throws IncorrectOperationException {
        if (this.myElement instanceof XmlAttribute) {
            XmlAttribute attr = (XmlAttribute)this.myElement;
            return "xmlns".equals(attr.getNamespacePrefix()) ? attr.setName(attr.getNamespacePrefix() + ":" + name2) : attr.setName(name2 + ":" + attr.getLocalName());
        }
        if (this.myElement instanceof XmlTag) {
            XmlTag tag = (XmlTag)this.myElement;
            return tag.setName(name2 + ":" + tag.getLocalName());
        }
        return super.handleElementRename(name2);
    }

    @Nullable
    public static SchemaPrefix resolvePrefix(PsiElement element, String name2) {
        XmlExtension extension = XmlExtension.getExtension(element.getContainingFile());
        return extension.getPrefixDeclaration((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false), name2);
    }

    public boolean isSoft() {
        return true;
    }

    @Override
    public boolean isPrefixReference() {
        return true;
    }

    @Nullable
    public TagNameReference getTagNameReference() {
        return this.myTagNameReference;
    }
}

