/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.FileNameIndexService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilenameIndex {
    @Deprecated
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"FilenameIndex");

    @NotNull
    public static String[] getAllFilenames(Project project2) {
        THashSet names = new THashSet();
        FilenameIndex.getService().processAllFileNames((Processor<String>)((Processor)arg_0 -> FilenameIndex.lambda$getAllFilenames$0((Set)names, arg_0)), (GlobalSearchScope)(project2 == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope((Project)project2)), null);
        String[] stringArray = ArrayUtil.toStringArray((Collection)names);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilenames"));
        }
        return stringArray;
    }

    public static void processAllFileNames(Processor<String> processor2, GlobalSearchScope scope, IdFilter filter) {
        FilenameIndex.getService().processAllFileNames(processor2, scope, filter);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project2, String name2, GlobalSearchScope scope) {
        return FilenameIndex.getService().getVirtualFilesByName(project2, name2, scope, null);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project2, String name2, boolean caseSensitively, GlobalSearchScope scope) {
        if (caseSensitively) {
            return FilenameIndex.getVirtualFilesByName(project2, name2, scope);
        }
        return FilenameIndex.getVirtualFilesByNameIgnoringCase(name2, scope, project2, null);
    }

    @NotNull
    public static PsiFile[] getFilesByName(Project project2, String name2, GlobalSearchScope scope) {
        PsiFile[] psiFileArray = (PsiFile[])FilenameIndex.getFilesByName(project2, name2, scope, false);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getFilesByName"));
        }
        return psiFileArray;
    }

    public static boolean processFilesByName(@NotNull String name2, boolean includeDirs, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project2, @Nullable IdFilter idFilter) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        return FilenameIndex.processFilesByName(name2, includeDirs, true, processor2, scope, project2, idFilter);
    }

    public static boolean processFilesByName(@NotNull String name2, boolean includeDirs, boolean caseSensitively, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project2, @Nullable IdFilter idFilter) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "processFilesByName"));
        }
        Collection<VirtualFile> files = caseSensitively ? FilenameIndex.getService().getVirtualFilesByName(project2, name2, scope, idFilter) : FilenameIndex.getVirtualFilesByNameIgnoringCase(name2, scope, project2, idFilter);
        if (files.isEmpty()) {
            return false;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        int processedFiles = 0;
        for (VirtualFile file2 : files) {
            PsiDirectory dir;
            if (!file2.isValid()) continue;
            if (!includeDirs && !file2.isDirectory()) {
                PsiFile psiFile = psiManager.findFile(file2);
                if (psiFile == null) continue;
                if (!processor2.process((Object)psiFile)) {
                    return true;
                }
                ++processedFiles;
                continue;
            }
            if (!includeDirs || !file2.isDirectory() || (dir = psiManager.findDirectory(file2)) == null) continue;
            if (!processor2.process((Object)dir)) {
                return true;
            }
            ++processedFiles;
        }
        return processedFiles > 0;
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesByNameIgnoringCase(@NotNull String name2, @NotNull GlobalSearchScope scope, @NotNull Project project2, @Nullable IdFilter idFilter) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        THashSet keys = new THashSet();
        FileNameIndexService fileNameIndexService = FilenameIndex.getService();
        fileNameIndexService.processAllFileNames((Processor<String>)((Processor)arg_0 -> FilenameIndex.lambda$getVirtualFilesByNameIgnoringCase$1(name2, (Set)keys, arg_0)), scope, idFilter);
        THashSet files = new THashSet();
        for (String each : keys) {
            files.addAll(fileNameIndexService.getVirtualFilesByName(project2, each, scope, idFilter));
        }
        THashSet tHashSet = files;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getVirtualFilesByNameIgnoringCase"));
        }
        return tHashSet;
    }

    @NotNull
    public static PsiFileSystemItem[] getFilesByName(Project project2, String name2, @NotNull GlobalSearchScope scope, boolean includeDirs) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FilenameIndex", "getFilesByName"));
        }
        SmartList result2 = new SmartList();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)result2);
        FilenameIndex.processFilesByName(name2, includeDirs, (Processor<? super PsiFileSystemItem>)processor2, scope, project2, null);
        if (includeDirs) {
            PsiFileSystemItem[] psiFileSystemItemArray = (PsiFileSystemItem[])ArrayUtil.toObjectArray((Collection)result2, PsiFileSystemItem.class);
            if (psiFileSystemItemArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getFilesByName"));
            }
            return psiFileSystemItemArray;
        }
        PsiFileSystemItem[] psiFileSystemItemArray = (PsiFileSystemItem[])result2.toArray((Object[])new PsiFile[result2.size()]);
        if (psiFileSystemItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getFilesByName"));
        }
        return psiFileSystemItemArray;
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project2, @NotNull String ext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (ext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        Collection<VirtualFile> collection = FilenameIndex.getAllFilesByExt(project2, ext, GlobalSearchScope.allScope((Project)project2));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        return collection;
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project2, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (ext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        int len = ext.length();
        if (len == 0) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
            }
            return list2;
        }
        ext = "." + ext;
        ++len;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String name2 : FilenameIndex.getAllFilenames(project2)) {
            int length = name2.length();
            if (length <= len || !name2.substring(length - len).equalsIgnoreCase(ext)) continue;
            files.addAll(FilenameIndex.getVirtualFilesByName(project2, name2, searchScope));
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FilenameIndex", "getAllFilesByExt"));
        }
        return arrayList;
    }

    static FileNameIndexService getService() {
        return (FileNameIndexService)ServiceManager.getService(FileNameIndexService.class);
    }

    private static /* synthetic */ boolean lambda$getVirtualFilesByNameIgnoringCase$1(@NotNull String name2, Set keys, String value2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/FilenameIndex", "lambda$getVirtualFilesByNameIgnoringCase$1"));
        }
        if (name2.equalsIgnoreCase(value2)) {
            keys.add(value2);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getAllFilenames$0(Set names, String s) {
        names.add(s);
        return true;
    }
}

