/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GlobalSearchScopeUtil {
    @NotNull
    public static GlobalSearchScope toGlobalSearchScope(@NotNull SearchScope scope, @NotNull Project project2) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScopeUtil", "toGlobalSearchScope"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopeUtil", "toGlobalSearchScope"));
        }
        if (scope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)scope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopeUtil", "toGlobalSearchScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)ReadAction.compute(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScopeUtil", "lambda$toGlobalSearchScope$0"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScopeUtil", "lambda$toGlobalSearchScope$0"));
            }
            return GlobalSearchScope.filesScope((Project)project2, GlobalSearchScopeUtil.getLocalScopeFiles((LocalSearchScope)scope));
        });
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopeUtil", "toGlobalSearchScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static Set<VirtualFile> getLocalScopeFiles(@NotNull LocalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScopeUtil", "getLocalScopeFiles"));
        }
        Set set2 = (Set)ReadAction.compute(() -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScopeUtil", "lambda$getLocalScopeFiles$1"));
            }
            LinkedHashSet files = new LinkedHashSet();
            for (PsiElement element : scope.getScope()) {
                PsiFile file2 = element.getContainingFile();
                if (file2 == null) continue;
                ContainerUtil.addIfNotNull(files, (Object)file2.getVirtualFile());
                ContainerUtil.addIfNotNull(files, (Object)file2.getNavigationElement().getContainingFile().getVirtualFile());
            }
            return files;
        });
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScopeUtil", "getLocalScopeFiles"));
        }
        return set2;
    }
}

