/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.lexer.Lexer;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetParserExtension;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.psi.search.scope.packageSet.PatternPackageSet;
import com.intellij.psi.search.scope.packageSet.lexer.ScopeTokenTypes;

public class PatternPackageSetParserExtension
implements PackageSetParserExtension {
    @Override
    public PackageSet parsePackageSet(Lexer lexer, String scope, String modulePattern) throws ParsingException {
        if (scope != "" && scope != "lib" && scope != "problem" && scope != "src" && scope != "test") {
            return null;
        }
        return new PatternPackageSet(PatternPackageSetParserExtension.parseAspectJPattern(lexer), scope, modulePattern);
    }

    @Override
    public String parseScope(Lexer lexer) {
        if (lexer.getTokenType() != ScopeTokenTypes.IDENTIFIER) {
            return "";
        }
        String id = PatternPackageSetParserExtension.getTokenText(lexer);
        String scope = "";
        if ("src".equals(id)) {
            scope = "src";
        } else if ("test".equals(id)) {
            scope = "test";
        } else if ("problem".equals(id)) {
            scope = "problem";
        } else if ("lib".equals(id)) {
            scope = "lib";
        } else if (!id.trim().isEmpty()) {
            scope = null;
        }
        CharSequence buf = lexer.getBufferSequence();
        int end = lexer.getTokenEnd();
        int bufferEnd = lexer.getBufferEnd();
        if (scope == "" || end >= bufferEnd || buf.charAt(end) != ':' && buf.charAt(end) != '[') {
            return "";
        }
        if (scope != null) {
            lexer.advance();
        }
        return scope;
    }

    private static String parseAspectJPattern(Lexer lexer) throws ParsingException {
        StringBuffer pattern = new StringBuffer();
        boolean wasIdentifier = false;
        while (true) {
            if (lexer.getTokenType() == ScopeTokenTypes.DOT) {
                pattern.append('.');
                wasIdentifier = false;
            } else if (lexer.getTokenType() == ScopeTokenTypes.ASTERISK) {
                pattern.append('*');
                wasIdentifier = false;
            } else {
                if (lexer.getTokenType() != ScopeTokenTypes.IDENTIFIER) break;
                if (wasIdentifier) {
                    PatternPackageSetParserExtension.error(AnalysisScopeBundle.message((String)"error.package.set.token.expectations", (Object[])new Object[]{PatternPackageSetParserExtension.getTokenText(lexer)}), lexer);
                }
                wasIdentifier = true;
                pattern.append(PatternPackageSetParserExtension.getTokenText(lexer));
            }
            lexer.advance();
        }
        if (pattern.length() == 0) {
            PatternPackageSetParserExtension.error(AnalysisScopeBundle.message((String)"error.package.set.pattern.expectations", (Object[])new Object[0]), lexer);
        }
        return pattern.toString();
    }

    private static String getTokenText(Lexer lexer) {
        int start = lexer.getTokenStart();
        int end = lexer.getTokenEnd();
        return lexer.getBufferSequence().subSequence(start, end).toString();
    }

    private static void error(String message2, Lexer lexer) throws ParsingException {
        throw new ParsingException(AnalysisScopeBundle.message((String)"error.package.set.position.parsing.error", (Object[])new Object[]{message2, lexer.getTokenStart() + 1}));
    }
}

