/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiMatcherExpression;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class PsiMatchers {
    private PsiMatchers() {
    }

    @NotNull
    public static PsiMatcherExpression hasName(final @NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/util/PsiMatchers", "hasName"));
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element instanceof PsiNamedElement && name2.equals(((PsiNamedElement)element).getName())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        if (psiMatcherExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiMatchers", "hasName"));
        }
        return psiMatcherExpression;
    }

    @NotNull
    public static PsiMatcherExpression hasText(final @NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/util/PsiMatchers", "hasText"));
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element.getTextLength() != text2.length()) {
                    return Boolean.FALSE;
                }
                return text2.equals(element.getText());
            }
        };
        if (psiMatcherExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiMatchers", "hasText"));
        }
        return psiMatcherExpression;
    }

    @NotNull
    public static PsiMatcherExpression hasText(final String ... texts) {
        if (texts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "texts", "com/intellij/psi/util/PsiMatchers", "hasText"));
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                String text2 = element.getText();
                return ArrayUtil.find((Object[])texts, (Object)text2) != -1;
            }
        };
        if (psiMatcherExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiMatchers", "hasText"));
        }
        return psiMatcherExpression;
    }

    @NotNull
    public static PsiMatcherExpression hasClass(final @NotNull Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiMatchers", "hasClass"));
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (aClass.isAssignableFrom(element.getClass())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        if (psiMatcherExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiMatchers", "hasClass"));
        }
        return psiMatcherExpression;
    }

    @NotNull
    public static PsiMatcherExpression hasClass(final Class ... classes2) {
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/util/PsiMatchers", "hasClass"));
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                for (Class aClass : classes2) {
                    if (!aClass.isAssignableFrom(element.getClass())) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        if (psiMatcherExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiMatchers", "hasClass"));
        }
        return psiMatcherExpression;
    }
}

