/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.PsiNavigateUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ClassRefactoringHandlerBase
implements RefactoringActionHandler,
ElementsHandler {
    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && this.acceptsElement(elements[0]);
    }

    protected static void navigate(PsiElement element) {
        PsiNavigateUtil.navigate((PsiElement)element);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        PsiElement position;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/ClassRefactoringHandlerBase", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = position = file2.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)this.getInvalidPositionMessage());
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)this.getTitle(), (String)this.getHelpId());
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)element)) {
                return;
            }
            if (this.acceptsElement(element)) {
                this.invoke(project2, new PsiElement[]{position}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/ClassRefactoringHandlerBase", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/ClassRefactoringHandlerBase", "invoke"));
        }
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        this.showDialog(project2, elements[0], editor, file2, dataContext);
    }

    protected abstract boolean acceptsElement(PsiElement var1);

    protected abstract void showDialog(Project var1, PsiElement var2, Editor var3, PsiFile var4, DataContext var5);

    protected abstract String getHelpId();

    protected abstract String getTitle();

    protected abstract String getInvalidPositionMessage();
}

