/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.introduce.IntroduceTarget;
import com.intellij.refactoring.introduce.PsiIntroduceTarget;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IntroduceTargetChooser {
    private IntroduceTargetChooser() {
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<T> expressions2, @NotNull Pass<T> callback, @NotNull Function<T, String> renderer) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (expressions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        IntroduceTargetChooser.showChooser(editor, expressions2, callback, renderer, "Expressions");
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<T> expressions2, @NotNull Pass<T> callback, @NotNull Function<T, String> renderer, @NotNull @Nls String title) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (expressions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        IntroduceTargetChooser.showChooser(editor, expressions2, callback, renderer, title, ScopeHighlighter.NATURAL_RANGER);
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<T> expressions2, @NotNull Pass<T> callback, @NotNull Function<T, String> renderer, @NotNull @Nls String title, @NotNull NotNullFunction<PsiElement, TextRange> ranger) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (expressions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (ranger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranger", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        IntroduceTargetChooser.showChooser(editor, expressions2, callback, renderer, title, -1, ranger);
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<T> expressions2, final @NotNull Pass<T> callback, @NotNull Function<T, String> renderer, @NotNull @Nls String title, int selection, @NotNull NotNullFunction<PsiElement, TextRange> ranger) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (expressions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        if (ranger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranger", "com/intellij/refactoring/IntroduceTargetChooser", "showChooser"));
        }
        List targets = ContainerUtil.map(expressions2, t -> {
            if (ranger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranger", "com/intellij/refactoring/IntroduceTargetChooser", "lambda$showChooser$0"));
            }
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/refactoring/IntroduceTargetChooser", "lambda$showChooser$0"));
            }
            return new MyIntroduceTarget<PsiElement>((PsiElement)t, ranger, (Function<PsiElement, String>)renderer);
        });
        Pass callbackWrapper = new Pass<MyIntroduceTarget<T>>(){

            public void pass(MyIntroduceTarget<T> target2) {
                callback.pass(target2.getPlace());
            }
        };
        IntroduceTargetChooser.showIntroduceTargetChooser(editor, targets, callbackWrapper, title, selection);
    }

    public static <T extends IntroduceTarget> void showIntroduceTargetChooser(@NotNull Editor editor, @NotNull List<T> expressions2, @NotNull Pass<T> callback, @NotNull @Nls String title, int selection) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/IntroduceTargetChooser", "showIntroduceTargetChooser"));
        }
        if (expressions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/refactoring/IntroduceTargetChooser", "showIntroduceTargetChooser"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/refactoring/IntroduceTargetChooser", "showIntroduceTargetChooser"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/refactoring/IntroduceTargetChooser", "showIntroduceTargetChooser"));
        }
        final AtomicReference<ScopeHighlighter> highlighter = new AtomicReference<ScopeHighlighter>(new ScopeHighlighter(editor));
        CollectionListModel model = new CollectionListModel(expressions2);
        JBList list2 = new JBList((ListModel)model);
        AccessibleContextUtil.setName((JComponent)list2, (String)title);
        list2.getSelectionModel().setSelectionMode(0);
        if (selection > -1) {
            list2.setSelectedIndex(selection);
        }
        list2.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                IntroduceTarget expr = (IntroduceTarget)value2;
                if (expr.isValid()) {
                    String text2;
                    int firstNewLinePos = (text2 = expr.render()).indexOf(10);
                    String trimmedText = text2.substring(0, firstNewLinePos != -1 ? firstNewLinePos : Math.min(100, text2.length()));
                    if (trimmedText.length() != text2.length()) {
                        trimmedText = trimmedText + " ...";
                    }
                    this.setText(trimmedText);
                } else {
                    this.setForeground((Color)JBColor.RED);
                    this.setText("Invalid");
                }
                return rendererComponent;
            }
        });
        list2.addListSelectionListener(e -> {
            ScopeHighlighter h = (ScopeHighlighter)highlighter.get();
            if (h == null) {
                return;
            }
            h.dropHighlight();
            IntroduceTarget expr = (IntroduceTarget)list2.getSelectedValue();
            if (expr != null && expr.isValid()) {
                TextRange range = expr.getTextRange();
                h.highlight((Pair<TextRange, List<TextRange>>)Pair.create((Object)range, Collections.singletonList(range)));
            }
        });
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/refactoring/IntroduceTargetChooser", "lambda$showIntroduceTargetChooser$2"));
            }
            IntroduceTarget expr = (IntroduceTarget)list2.getSelectedValue();
            if (expr != null && expr.isValid()) {
                callback.pass((Object)expr);
            }
        }).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                ((ScopeHighlighter)highlighter.getAndSet(null)).dropHighlight();
            }
        }).createPopup();
        popup.showInBestPositionFor(editor);
        Project project2 = editor.getProject();
        if (project2 != null) {
            NavigationUtil.hidePopupIfDumbModeStarts(popup, project2);
        }
    }

    private static class MyIntroduceTarget<T extends PsiElement>
    extends PsiIntroduceTarget<T> {
        private final NotNullFunction<PsiElement, TextRange> myRanger;
        private final Function<T, String> myRenderer;

        public MyIntroduceTarget(@NotNull T psi, @NotNull NotNullFunction<PsiElement, TextRange> ranger, @NotNull Function<T, String> renderer) {
            if (psi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/refactoring/IntroduceTargetChooser$MyIntroduceTarget", "<init>"));
            }
            if (ranger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranger", "com/intellij/refactoring/IntroduceTargetChooser$MyIntroduceTarget", "<init>"));
            }
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/refactoring/IntroduceTargetChooser$MyIntroduceTarget", "<init>"));
            }
            super(psi);
            this.myRanger = ranger;
            this.myRenderer = renderer;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = (TextRange)this.myRanger.fun(this.getPlace());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/IntroduceTargetChooser$MyIntroduceTarget", "getTextRange"));
            }
            return textRange;
        }

        @Override
        @NotNull
        public String render() {
            String string = (String)this.myRenderer.fun(this.getPlace());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/IntroduceTargetChooser$MyIntroduceTarget", "render"));
            }
            return string;
        }
    }
}

