/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.chainCall;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.refactoring.chainCall.ChainCallExtractor;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;

public class GuavaFluentIterableChainCallExtractor
implements ChainCallExtractor {
    public static final String FLUENT_ITERABLE = "com.google.common.collect.FluentIterable";
    private static final CallMatcher NEXT_CALL = CallMatcher.instanceCall("com.google.common.collect.FluentIterable", "transform", "firstMatch", "transformAndConcat", "anyMatch", "allMatch").parameterCount(1);

    @Override
    public boolean canExtractChainCall(@NotNull PsiMethodCallExpression call, PsiExpression expression2, PsiType expressionType) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/refactoring/chainCall/GuavaFluentIterableChainCallExtractor", "canExtractChainCall"));
        }
        if (expressionType instanceof PsiPrimitiveType) {
            return false;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        return NEXT_CALL.test(call) || "forEach".equals(call.getMethodExpression().getReferenceName()) && InheritanceUtil.isInheritor((PsiType)qualifier.getType(), (String)FLUENT_ITERABLE);
    }

    @Override
    public String getMethodName(PsiVariable variable, PsiExpression expression2, PsiType expressionType) {
        return "transform";
    }
}

