/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.daemon.impl.quickfix.DefineParamsDefaultValueAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.JavaMethodDescriptor;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.inplace.InplaceChangeSignature;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetectedJavaChangeInfo
extends JavaChangeInfoImpl {
    private PsiMethod mySuperMethod;
    private final String[] myModifiers;

    DetectedJavaChangeInfo(@PsiModifier.ModifierConstant String newVisibility, PsiMethod method, CanonicalTypes.Type newType, @NotNull ParameterInfoImpl[] newParms, ThrownExceptionInfo[] newExceptions, String newName, String oldName, boolean delegate) {
        if (newParms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParms", "com/intellij/refactoring/changeSignature/DetectedJavaChangeInfo", "<init>"));
        }
        super(newVisibility, method, newName, newType, newParms, newExceptions, delegate, new HashSet<PsiMethod>(), new HashSet<PsiMethod>(), oldName);
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        this.myModifiers = new String[parameters2.length];
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            String text2;
            PsiParameter parameter = parameters2[i2];
            PsiModifierList modifierList = parameter.getModifierList();
            if (modifierList == null) continue;
            this.myModifiers[i2] = text2 = modifierList.getText();
        }
    }

    @Nullable
    static DetectedJavaChangeInfo createFromMethod(PsiMethod method, boolean delegate) {
        ParameterInfoImpl[] parameterInfos;
        String newVisibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
        PsiType returnType = method.getReturnType();
        CanonicalTypes.Type newReturnType = returnType != null ? CanonicalTypes.createTypeWrapper(returnType) : null;
        for (ParameterInfoImpl parameterInfo : parameterInfos = ParameterInfoImpl.fromMethod(method)) {
            if (parameterInfo.getTypeWrapper().isValid()) continue;
            return null;
        }
        DetectedJavaChangeInfo fromMethod = new DetectedJavaChangeInfo(newVisibility, method, newReturnType, parameterInfos, null, method.getName(), method.getName(), delegate);
        PsiMethod deepestSuperMethod = method.findDeepestSuperMethod();
        if (deepestSuperMethod != null && !deepestSuperMethod.getManager().isInProject((PsiElement)deepestSuperMethod)) {
            return null;
        }
        fromMethod.setSuperMethod(deepestSuperMethod);
        return fromMethod;
    }

    @Override
    protected void setupPropagationEnabled(PsiParameter[] parameters2, ParameterInfoImpl[] newParams) {
        this.isPropagationEnabled = false;
    }

    public PsiMethod getSuperMethod() {
        if (this.mySuperMethod == null) {
            return this.getMethod();
        }
        return this.mySuperMethod;
    }

    public void setSuperMethod(PsiMethod superMethod) {
        this.mySuperMethod = superMethod;
    }

    public String[] getModifiers() {
        return this.myModifiers;
    }

    @Override
    protected boolean checkMethodEquality() {
        return false;
    }

    @Nullable
    DetectedJavaChangeInfo createNextInfo(PsiMethod method, boolean delegate) {
        DetectedJavaChangeInfo fromMethod = DetectedJavaChangeInfo.createFromMethod(method, delegate);
        if (fromMethod == null) {
            return null;
        }
        if (!this.equals(fromMethod)) {
            String visibility;
            if (!this.createParametersInfo(fromMethod.newParms)) {
                return null;
            }
            if (!(!(fromMethod.newReturnType != null && this.getNewReturnType() == null || fromMethod.newReturnType == null && this.getNewReturnType() != null) && (fromMethod.newReturnType == null || this.getNewReturnType() == null || Comparing.strEqual((String)this.getNewReturnType().getTypeText(), (String)fromMethod.newReturnType.getTypeText())) || !Comparing.strEqual((String)(visibility = this.getNewVisibility()), (String)"private") || this.isArrayToVarargs() || this.isExceptionSetOrOrderChanged() || this.isExceptionSetChanged() || this.isNameChanged() || this.isParameterSetOrOrderChanged() || this.isParameterNamesChanged() || this.isParameterTypesChanged())) {
                return null;
            }
            try {
                DetectedJavaChangeInfo javaChangeInfo = new DetectedJavaChangeInfo(fromMethod.getNewVisibility(), this.getMethod(), fromMethod.newReturnType, fromMethod.newParms, this.getNewExceptions(), method.getName(), this.getOldName(), delegate){

                    @Override
                    protected void fillOldParams(PsiMethod method) {
                        this.oldParameterNames = DetectedJavaChangeInfo.this.getOldParameterNames();
                        this.oldParameterTypes = DetectedJavaChangeInfo.this.getOldParameterTypes();
                        if (!method.isConstructor()) {
                            try {
                                this.isReturnTypeChanged = this.isReturnTypeChanged || (DetectedJavaChangeInfo.this.getNewReturnType() != null ? !Comparing.strEqual((String)DetectedJavaChangeInfo.this.getNewReturnType().getTypeText(), (String)this.newReturnType.getTypeText()) : this.newReturnType != null);
                            }
                            catch (IncorrectOperationException e) {
                                this.isReturnTypeChanged = true;
                            }
                        }
                        int length = Math.min(this.newParms.length, this.oldParameterNames.length);
                        for (int i2 = 0; i2 < length; ++i2) {
                            ParameterInfoImpl parm = this.newParms[i2];
                            if (!parm.getName().equals(this.oldParameterNames[i2]) || !parm.getTypeText().equals(this.oldParameterTypes[i2])) continue;
                            parm.oldParameterIndex = i2;
                        }
                    }
                };
                javaChangeInfo.setSuperMethod(this.getSuperMethod());
                return javaChangeInfo;
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        }
        return this;
    }

    ChangeSignatureProcessor createChangeSignatureProcessor(final PsiMethod method) {
        return new ChangeSignatureProcessor(method.getProject(), new DetectedJavaChangeInfo(this.getNewVisibility(), this.getSuperMethod(), this.getNewReturnType(), (ParameterInfoImpl[])this.getNewParameters(), this.getNewExceptions(), this.getNewName(), method.getName(), this.isGenerateDelegate()){

            @Override
            protected void fillOldParams(PsiMethod method) {
                super.fillOldParams(method);
                this.oldParameterNames = DetectedJavaChangeInfo.this.getOldParameterNames();
                this.oldParameterTypes = DetectedJavaChangeInfo.this.getOldParameterTypes();
            }
        }){

            @Override
            protected void performRefactoring(@NotNull UsageInfo[] usages) {
                if (usages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/changeSignature/DetectedJavaChangeInfo$3", "performRefactoring"));
                }
                super.performRefactoring(usages);
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                for (int i2 = 0; i2 < DetectedJavaChangeInfo.this.getModifiers().length; ++i2) {
                    PsiModifierList newModifierList;
                    String modifier = DetectedJavaChangeInfo.this.getModifiers()[i2];
                    PsiModifierList modifierList = parameters2[i2].getModifierList();
                    if (modifierList == null || Comparing.strEqual((String)modifier, (String)modifierList.getText()) || (newModifierList = elementFactory.createParameterFromText((modifier.isEmpty() ? "" : modifier + " ") + "type name", (PsiElement)method).getModifierList()) == null) continue;
                    modifierList.replace((PsiElement)newModifierList);
                }
            }
        };
    }

    private boolean createParametersInfo(ParameterInfoImpl[] parameterInfos) {
        JavaParameterInfo oldParameter;
        ParameterInfoImpl parameterInfo;
        int i2;
        JavaParameterInfo[] oldParameters = this.getNewParameters();
        String[] oldParameterNames = this.getOldParameterNames();
        String[] oldParameterTypes = this.getOldParameterTypes();
        HashMap<ParameterInfoImpl, Integer> untouchedParams = new HashMap<ParameterInfoImpl, Integer>();
        for (i2 = 0; i2 < parameterInfos.length; ++i2) {
            parameterInfo = parameterInfos[i2];
            oldParameter = null;
            for (JavaParameterInfo parameter : oldParameters) {
                if (!Comparing.strEqual((String)parameter.getName(), (String)parameterInfo.getName()) || !Comparing.strEqual((String)parameter.getTypeText(), (String)parameterInfo.getTypeText())) continue;
                oldParameter = parameter;
                break;
            }
            if (oldParameter == null) continue;
            parameterInfos[i2] = new ParameterInfoImpl(oldParameter.getOldIndex(), oldParameter.getName(), oldParameter.getTypeWrapper(), null);
            untouchedParams.put(parameterInfos[i2], oldParameter.getOldIndex());
        }
        for (i2 = 0; i2 < parameterInfos.length; ++i2) {
            CanonicalTypes.Type typeWrapper;
            parameterInfo = parameterInfos[i2];
            if (untouchedParams.containsKey(parameterInfo)) continue;
            oldParameter = null;
            if (oldParameters.length > i2 && oldParameterNames.length > i2 && (Comparing.strEqual((String)oldParameterNames[i2], (String)parameterInfo.getName()) || Comparing.strEqual((String)oldParameterTypes[i2], (String)parameterInfo.getTypeText())) && !untouchedParams.containsValue(oldParameters[i2].getOldIndex())) {
                oldParameter = oldParameters[i2];
            }
            if (!(typeWrapper = parameterInfo.getTypeWrapper()).isValid()) {
                return false;
            }
            parameterInfos[i2] = new ParameterInfoImpl(oldParameter != null ? oldParameter.getOldIndex() : -1, parameterInfo.getName(), typeWrapper, null);
        }
        return true;
    }

    void perform(final String oldText, Editor editor, boolean silently) {
        final PsiMethod method = this.getSuperMethod();
        final Project project2 = this.getMethod().getProject();
        final PsiMethod currentMethod = this.getMethod();
        TextRange signatureRange = JavaChangeSignatureDetector.getSignatureRange(currentMethod);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        final Document document = documentManager.getDocument(currentMethod.getContainingFile());
        if (silently || ApplicationManager.getApplication().isUnitTestMode()) {
            PsiMethod prototype;
            String currentSignature = currentMethod.getContainingFile().getText().substring(signatureRange.getStartOffset(), signatureRange.getEndOffset());
            InplaceChangeSignature.temporallyRevertChanges(JavaChangeSignatureDetector.getSignatureRange(currentMethod), document, oldText, project2);
            if (this.isGenerateDelegate()) {
                for (JavaParameterInfo info : this.getNewParameters()) {
                    if (info.getOldIndex() != -1) continue;
                    ((ParameterInfoImpl)info).setDefaultValue("null");
                }
                prototype = JavaChangeSignatureUsageProcessor.generateDelegatePrototype(this);
            } else {
                prototype = null;
            }
            this.createChangeSignatureProcessor(method).run();
            InplaceChangeSignature.temporallyRevertChanges(JavaChangeSignatureDetector.getSignatureRange(currentMethod), document, currentSignature, project2);
            if (prototype != null) {
                WriteCommandAction.runWriteCommandAction((Project)project2, (String)"Delegate", null, () -> {
                    PsiExpression expression2;
                    PsiMethod delegate = currentMethod.getContainingClass().findMethodBySignature(prototype, false);
                    PsiExpression psiExpression = expression2 = delegate != null ? LambdaUtil.extractSingleExpressionFromBody((PsiElement)delegate.getBody()) : null;
                    if (expression2 instanceof PsiMethodCallExpression) {
                        PsiExpression[] expressions2 = ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions();
                        JavaParameterInfo[] parameters2 = this.getNewParameters();
                        PsiExpression[] toBeDefault = (PsiExpression[])Arrays.stream(parameters2).filter(param -> param.getOldIndex() == -1).map(info -> {
                            int i2 = ArrayUtil.find((Object[])parameters2, (Object)info);
                            return expressions2[i2];
                        }).toArray(PsiExpression[]::new);
                        DefineParamsDefaultValueAction.startTemplate(project2, editor, toBeDefault, delegate);
                    }
                }, (PsiFile[])new PsiFile[0]);
            }
            return;
        }
        JavaMethodDescriptor descriptor = new JavaMethodDescriptor(currentMethod){

            @Override
            public String getReturnTypeText() {
                return DetectedJavaChangeInfo.this.getNewReturnType().getTypeText();
            }
        };
        JavaChangeSignatureDialog dialog2 = new JavaChangeSignatureDialog(method.getProject(), descriptor, true, (PsiElement)method){

            @Override
            protected BaseRefactoringProcessor createRefactoringProcessor() {
                return DetectedJavaChangeInfo.this.createChangeSignatureProcessor(method);
            }

            @Override
            protected void invokeRefactoring(BaseRefactoringProcessor processor2) {
                CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                    InplaceChangeSignature.temporallyRevertChanges(JavaChangeSignatureDetector.getSignatureRange(currentMethod), document, oldText, project2);
                    this.doRefactor(processor2);
                }, RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)currentMethod)}), null);
            }

            private void doRefactor(BaseRefactoringProcessor processor2) {
                super.invokeRefactoring(processor2);
            }
        };
        dialog2.showAndGet();
    }
}

