/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyClassDialog;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyClassesHandler
extends CopyHandlerDelegateBase {
    private static final Logger LOG = Logger.getInstance(CopyClassesHandler.class);

    @Override
    public boolean forbidToClone(PsiElement[] elements, boolean fromUpdate) {
        Map<PsiFile, PsiClass[]> fileMap = CopyClassesHandler.convertToTopLevelClasses(elements, fromUpdate, null, null);
        if (fileMap != null && fileMap.size() == 1) {
            PsiClass[] psiClasses = fileMap.values().iterator().next();
            return psiClasses != null && psiClasses.length > 1;
        }
        return true;
    }

    @Override
    public boolean canCopy(PsiElement[] elements, boolean fromUpdate) {
        return CopyClassesHandler.canCopyClass(fromUpdate, elements);
    }

    public static boolean canCopyClass(PsiElement ... elements) {
        return CopyClassesHandler.canCopyClass(false, elements);
    }

    public static boolean canCopyClass(boolean fromUpdate, PsiElement ... elements) {
        if (fromUpdate && elements.length > 0 && elements[0] instanceof PsiDirectory) {
            return true;
        }
        return CopyClassesHandler.convertToTopLevelClasses(elements, fromUpdate, null, null) != null;
    }

    @Nullable
    private static Map<PsiFile, PsiClass[]> convertToTopLevelClasses(PsiElement[] elements, boolean fromUpdate, String relativePath, Map<PsiFile, String> relativeMap) {
        HashMap<PsiFile, PsiClass[]> result2 = new HashMap<PsiFile, PsiClass[]>();
        for (PsiElement element : elements) {
            PsiElement navigationElement = element.getNavigationElement();
            LOG.assertTrue(navigationElement != null, (Object)element);
            PsiFile containingFile = navigationElement.getContainingFile();
            if (containingFile instanceof PsiClassOwner && JavaProjectRootsUtil.isOutsideJavaSourceRoot(containingFile)) continue;
            PsiClass[] topLevelClasses = CopyClassesHandler.getTopLevelClasses(element);
            if (topLevelClasses == null) {
                if (element instanceof PsiDirectory) {
                    if (fromUpdate) continue;
                    String name2 = ((PsiDirectory)element).getName();
                    String path = relativePath != null ? (relativePath.length() > 0 ? relativePath + "/" : "") + name2 : null;
                    Map<PsiFile, PsiClass[]> map2 = CopyClassesHandler.convertToTopLevelClasses(element.getChildren(), fromUpdate, path, relativeMap);
                    if (map2 == null) {
                        return null;
                    }
                    for (Map.Entry<PsiFile, PsiClass[]> entry : map2.entrySet()) {
                        CopyClassesHandler.fillResultsMap(result2, entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                if (!(element instanceof PsiFileSystemItem)) {
                    return null;
                }
            }
            CopyClassesHandler.fillResultsMap(result2, containingFile, topLevelClasses);
            if (relativeMap == null) continue;
            relativeMap.put(containingFile, relativePath);
        }
        if (result2.isEmpty()) {
            return null;
        }
        boolean hasClasses = false;
        for (PsiClass[] classes2 : result2.values()) {
            if (classes2 == null) continue;
            hasClasses = true;
            break;
        }
        return hasClasses ? result2 : null;
    }

    @Nullable
    private static String normalizeRelativeMap(Map<PsiFile, String> relativeMap) {
        String vector = null;
        for (String relativePath : relativeMap.values()) {
            if (vector == null) {
                vector = relativePath;
                continue;
            }
            if (vector.startsWith(relativePath + "/")) {
                vector = relativePath;
                continue;
            }
            if (relativePath.startsWith(vector + "/") || relativePath.equals(vector)) continue;
            return null;
        }
        if (vector != null) {
            Iterator<String> iterator = relativeMap.keySet().iterator();
            while (iterator.hasNext()) {
                PsiFile psiFile;
                String path = relativeMap.get(psiFile = (PsiFile)iterator.next());
                relativeMap.put(psiFile, path.equals(vector) ? "" : path.substring(vector.length() + 1));
            }
        }
        return vector;
    }

    private static void fillResultsMap(Map<PsiFile, PsiClass[]> result2, PsiFile containingFile, PsiClass[] topLevelClasses) {
        Object[] classes2 = result2.get(containingFile);
        if (topLevelClasses != null) {
            if (classes2 != null) {
                topLevelClasses = (PsiClass[])ArrayUtil.mergeArrays((Object[])classes2, (Object[])topLevelClasses, (ArrayFactory)PsiClass.ARRAY_FACTORY);
            }
            result2.put(containingFile, topLevelClasses);
        } else {
            result2.put(containingFile, (PsiClass[])classes2);
        }
    }

    @Override
    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        Project project2;
        VirtualFile sourceRootForFile;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.copyClass");
        HashMap<PsiFile, String> relativePathsMap = new HashMap<PsiFile, String>();
        Map<PsiFile, PsiClass[]> classes2 = CopyClassesHandler.convertToTopLevelClasses(elements, false, "", relativePathsMap);
        assert (classes2 != null);
        if (defaultTargetDirectory == null) {
            PsiFile psiFile = classes2.keySet().iterator().next();
            defaultTargetDirectory = psiFile.getContainingDirectory();
            LOG.assertTrue(defaultTargetDirectory != null, (Object)psiFile);
        }
        if ((sourceRootForFile = ProjectRootManager.getInstance((Project)(project2 = defaultTargetDirectory.getProject())).getFileIndex().getSourceRootForFile(defaultTargetDirectory.getVirtualFile())) == null) {
            ArrayList<Object> files = new ArrayList<Object>();
            for (PsiElement element : elements) {
                PsiFile containingFile = element.getContainingFile();
                if (containingFile != null) {
                    files.add(containingFile);
                    continue;
                }
                if (!(element instanceof PsiDirectory)) continue;
                files.add(element);
            }
            CopyFilesOrDirectoriesHandler.copyAsFiles(files.toArray(new PsiElement[files.size()]), defaultTargetDirectory, project2);
            return;
        }
        PsiDirectory targetDirectory = null;
        String className = null;
        boolean openInEditor = true;
        if (CopyClassesHandler.copyOneClass(classes2)) {
            final String commonPath = ArrayUtilRt.find((Object[])elements, (Object)classes2.values().iterator().next()) == -1 ? CopyClassesHandler.normalizeRelativeMap(relativePathsMap) : null;
            CopyClassDialog dialog2 = new CopyClassDialog(classes2.values().iterator().next()[0], defaultTargetDirectory, project2, false){

                @Override
                protected String getQualifiedName() {
                    String qualifiedName = super.getQualifiedName();
                    if (commonPath != null && !commonPath.isEmpty() && !qualifiedName.endsWith(commonPath)) {
                        return StringUtil.getQualifiedName((String)qualifiedName, (String)commonPath.replaceAll("/", "."));
                    }
                    return qualifiedName;
                }
            };
            dialog2.setTitle(RefactoringBundle.message((String)"copy.handler.copy.class"));
            if (dialog2.showAndGet()) {
                openInEditor = dialog2.openInEditor();
                targetDirectory = dialog2.getTargetDirectory();
                className = dialog2.getClassName();
                if (className == null || className.length() == 0) {
                    return;
                }
            }
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            targetDirectory = defaultTargetDirectory;
        } else {
            if ((defaultTargetDirectory = CopyFilesOrDirectoriesHandler.resolveDirectory(defaultTargetDirectory)) == null) {
                return;
            }
            final PsiFile[] files = PsiUtilCore.toPsiFileArray(classes2.keySet());
            CopyFilesOrDirectoriesDialog dialog3 = new CopyFilesOrDirectoriesDialog((PsiElement[])files, defaultTargetDirectory, project2, false){

                @Override
                public JComponent getPreferredFocusedComponent() {
                    return files.length == 1 ? this.getTargetDirectoryComponent() : super.getPreferredFocusedComponent();
                }
            };
            if (dialog3.showAndGet()) {
                targetDirectory = dialog3.getTargetDirectory();
                String newName = dialog3.getNewName();
                if (files.length == 1) {
                    className = StringUtil.trimEnd((String)newName, (String)("." + CopyClassesHandler.getFileExtension(files[0])));
                }
                openInEditor = dialog3.openInEditor();
            }
        }
        if (targetDirectory != null) {
            CopyClassesHandler.copyClassesImpl(className, project2, classes2, relativePathsMap, targetDirectory, defaultTargetDirectory, RefactoringBundle.message((String)"copy.handler.copy.class"), false, openInEditor);
        }
    }

    private static boolean copyOneClass(Map<PsiFile, PsiClass[]> classes2) {
        if (classes2.size() == 1) {
            PsiClass[] psiClasses = classes2.values().iterator().next();
            return psiClasses != null && psiClasses.length == 1;
        }
        return false;
    }

    @Override
    public void doClone(PsiElement element) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.copyClass");
        PsiClass[] classes2 = CopyClassesHandler.getTopLevelClasses(element);
        if (classes2 == null) {
            CopyFilesOrDirectoriesHandler.doCloneFile(element);
            return;
        }
        Project project2 = element.getProject();
        CopyClassDialog dialog2 = new CopyClassDialog(classes2[0], null, project2, true);
        dialog2.setTitle(RefactoringBundle.message((String)"copy.handler.clone.class"));
        if (dialog2.showAndGet()) {
            String className = dialog2.getClassName();
            PsiDirectory targetDirectory = element.getContainingFile().getContainingDirectory();
            CopyClassesHandler.copyClassesImpl(className, project2, Collections.singletonMap(classes2[0].getContainingFile(), classes2), null, targetDirectory, targetDirectory, RefactoringBundle.message((String)"copy.handler.clone.class"), true, true);
        }
    }

    private static void copyClassesImpl(String copyClassName, Project project2, Map<PsiFile, PsiClass[]> classes2, HashMap<PsiFile, String> map2, Object targetDirectory, PsiDirectory defaultTargetDirectory, String commandName, boolean selectInActivePanel, boolean openInEditor) {
        boolean[] result2 = new boolean[]{false};
        Runnable command = () -> {
            PsiDirectory target2 = targetDirectory instanceof PsiDirectory ? (PsiDirectory)targetDirectory : (PsiDirectory)WriteAction.compute(() -> ((MoveDestination)targetDirectory).getTargetDirectory(defaultTargetDirectory));
            try {
                Collection<PsiFile> files = CopyClassesHandler.doCopyClasses(classes2, map2, copyClassName, target2, project2);
                if (files != null && openInEditor) {
                    for (PsiFile file2 : files) {
                        CopyHandler.updateSelectionInActiveProjectView((PsiElement)file2, project2, selectInActivePanel);
                    }
                    EditorHelper.openFilesInEditor((PsiElement[])((PsiElement[])files.toArray(new PsiFile[files.size()])));
                }
            }
            catch (IncorrectOperationException ex) {
                Messages.showMessageDialog((Project)project2, (String)ex.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
            }
        };
        CommandProcessor processor2 = CommandProcessor.getInstance();
        processor2.executeCommand(project2, command, commandName, null);
        if (result2[0]) {
            ToolWindowManager.getInstance((Project)project2).invokeLater(() -> ToolWindowManager.getInstance((Project)project2).activateEditorComponent());
        }
    }

    @Nullable
    public static Collection<PsiFile> doCopyClasses(Map<PsiFile, PsiClass[]> fileToClasses, String copyClassName, PsiDirectory targetDirectory, Project project2) throws IncorrectOperationException {
        return CopyClassesHandler.doCopyClasses(fileToClasses, null, copyClassName, targetDirectory, project2);
    }

    @Nullable
    public static Collection<PsiFile> doCopyClasses(Map<PsiFile, PsiClass[]> fileToClasses, @Nullable HashMap<PsiFile, String> map2, String copyClassName, PsiDirectory targetDirectory, Project project2) throws IncorrectOperationException {
        int[] nArray;
        PsiElement newElement = null;
        HashMap<PsiClass, PsiElement> oldToNewMap = new HashMap<PsiClass, PsiElement>();
        for (PsiClass[] psiClasses : fileToClasses.values()) {
            if (psiClasses == null) continue;
            for (PsiClass aClass : psiClasses) {
                if (CopyClassesHandler.isSynthetic(aClass)) continue;
                oldToNewMap.put(aClass, null);
            }
        }
        ArrayList<PsiFile> createdFiles = new ArrayList<PsiFile>(fileToClasses.size());
        if (fileToClasses.size() > 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = -1;
        } else {
            nArray = null;
        }
        int[] choice = nArray;
        ArrayList<PsiFile> files = new ArrayList<PsiFile>();
        for (Map.Entry<PsiFile, PsiClass[]> entry : fileToClasses.entrySet()) {
            PsiFile psiFile = entry.getKey();
            PsiClass[] sources = entry.getValue();
            if (psiFile instanceof PsiClassOwner && sources != null) {
                PsiClass[] classes2;
                PsiFile createdFile = CopyClassesHandler.copy(psiFile, targetDirectory, copyClassName, map2 == null ? null : map2.get(psiFile), choice);
                if (createdFile == null) {
                    for (PsiClass aClass : ((PsiClassOwner)psiFile).getClasses()) {
                        oldToNewMap.remove(aClass);
                    }
                    continue;
                }
                for (PsiClass destination : classes2 = ((PsiClassOwner)createdFile).getClasses()) {
                    if (CopyClassesHandler.isSynthetic(destination)) continue;
                    PsiClass source = CopyClassesHandler.findByName(sources, destination.getName());
                    if (source != null) {
                        PsiClass copy = CopyClassesHandler.copy(source, classes2.length > 1 ? null : copyClassName);
                        newElement = (PsiElement)WriteAction.compute(() -> destination.replace((PsiElement)copy));
                        oldToNewMap.put(source, newElement);
                        continue;
                    }
                    WriteAction.run(() -> destination.delete());
                }
                createdFiles.add(createdFile);
                continue;
            }
            files.add(psiFile);
        }
        for (PsiFile file2 : files) {
            try {
                PsiFile fileCopy;
                String relativePath;
                PsiDirectory finalTarget = targetDirectory;
                String string = relativePath = map2 != null ? map2.get(file2) : null;
                if (relativePath != null && !relativePath.isEmpty()) {
                    finalTarget = (PsiDirectory)WriteAction.compute(() -> CopyClassesHandler.buildRelativeDir(targetDirectory, relativePath).findOrCreateTargetDirectory());
                }
                if ((fileCopy = CopyFilesOrDirectoriesHandler.copyToDirectory((PsiFileSystemItem)file2, CopyClassesHandler.getNewFileName(file2, copyClassName), finalTarget, choice, null)) == null) continue;
                createdFiles.add(fileCopy);
            }
            catch (IOException e) {
                throw new IncorrectOperationException(e.getMessage());
            }
        }
        WriteAction.run(() -> {
            HashSet<PsiElement> rebindExpressions = new HashSet<PsiElement>();
            for (PsiElement element : oldToNewMap.values()) {
                if (element == null) {
                    LOG.error(oldToNewMap.keySet());
                    continue;
                }
                CopyClassesHandler.decodeRefs(element, oldToNewMap, rebindExpressions);
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            for (PsiFile psiFile : createdFiles) {
                if (!(psiFile instanceof PsiJavaFile)) continue;
                codeStyleManager.removeRedundantImports((PsiJavaFile)psiFile);
            }
            for (PsiElement expression2 : rebindExpressions) {
                if (!expression2.isValid()) continue;
                codeStyleManager.shortenClassReferences(expression2);
            }
        });
        new OptimizeImportsProcessor(project2, createdFiles.toArray(new PsiFile[createdFiles.size()]), null).run();
        return createdFiles;
    }

    protected static boolean isSynthetic(PsiClass aClass) {
        return aClass instanceof SyntheticElement || !aClass.isPhysical();
    }

    private static PsiFile copy(@NotNull PsiFile file2, PsiDirectory directory, String name2, String relativePath, int[] choice) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/copy/CopyClassesHandler", "copy"));
        }
        String fileName = CopyClassesHandler.getNewFileName(file2, name2);
        if (relativePath != null && !relativePath.isEmpty()) {
            return (PsiFile)WriteAction.compute(() -> {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/copy/CopyClassesHandler", "lambda$copy$7"));
                }
                return CopyClassesHandler.buildRelativeDir(directory, relativePath).findOrCreateTargetDirectory().copyFileFrom(fileName, file2);
            });
        }
        if (CopyFilesOrDirectoriesHandler.checkFileExist(directory, choice, file2, fileName, "Copy")) {
            return null;
        }
        return (PsiFile)WriteAction.compute(() -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/copy/CopyClassesHandler", "lambda$copy$8"));
            }
            return directory.copyFileFrom(fileName, file2);
        });
    }

    private static String getNewFileName(PsiFile file2, String name2) {
        if (name2 != null) {
            String fileExtension = CopyClassesHandler.getFileExtension(file2);
            return fileExtension.isEmpty() ? name2 : StringUtil.getQualifiedName((String)name2, (String)fileExtension);
        }
        return file2.getName();
    }

    private static String getFileExtension(PsiFile file2) {
        if (file2 instanceof PsiClassOwner) {
            for (PsiClass psiClass : ((PsiClassOwner)file2).getClasses()) {
                if (CopyClassesHandler.isSynthetic(psiClass)) continue;
                return file2.getViewProvider().getVirtualFile().getExtension();
            }
        }
        return "";
    }

    @NotNull
    private static MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper buildRelativeDir(@NotNull PsiDirectory directory, @NotNull String relativePath) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/refactoring/copy/CopyClassesHandler", "buildRelativeDir"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/refactoring/copy/CopyClassesHandler", "buildRelativeDir"));
        }
        MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper current = null;
        for (String pathElement : relativePath.split("/")) {
            current = current == null ? new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(directory, pathElement) : new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(current, pathElement);
        }
        LOG.assertTrue(current != null);
        MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper targetDirectoryWrapper = current;
        if (targetDirectoryWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/copy/CopyClassesHandler", "buildRelativeDir"));
        }
        return targetDirectoryWrapper;
    }

    private static PsiClass copy(PsiClass aClass, String name2) {
        PsiClass classNavigationElement = (PsiClass)aClass.getNavigationElement();
        PsiClass classCopy = (PsiClass)classNavigationElement.copy();
        if (name2 != null) {
            classCopy.setName(name2);
        }
        return classCopy;
    }

    @Nullable
    private static PsiClass findByName(PsiClass[] classes2, String name2) {
        if (name2 != null) {
            for (PsiClass aClass : classes2) {
                if (!name2.equals(aClass.getName())) continue;
                return aClass;
            }
        }
        return null;
    }

    private static void rebindExternalReferences(PsiElement element, Map<PsiClass, PsiElement> oldToNewMap, Set<PsiElement> rebindExpressions) {
        LocalSearchScope searchScope = new LocalSearchScope(element);
        for (PsiClass aClass : oldToNewMap.keySet()) {
            PsiElement newClass = oldToNewMap.get(aClass);
            for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope)) {
                rebindExpressions.add(reference.bindToElement(newClass));
            }
        }
    }

    private static void decodeRefs(@NotNull PsiElement element, final Map<PsiClass, PsiElement> oldToNewMap, Set<PsiElement> rebindExpressions) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/copy/CopyClassesHandler", "decodeRefs"));
        }
        final LinkedHashMap rebindMap = new LinkedHashMap();
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                CopyClassesHandler.decodeRef(reference, oldToNewMap, rebindMap);
            }
        });
        for (Map.Entry entry : rebindMap.entrySet()) {
            rebindExpressions.add(((PsiJavaCodeReferenceElement)entry.getKey()).bindToElement((PsiElement)entry.getValue()));
        }
        CopyClassesHandler.rebindExternalReferences(element, oldToNewMap, rebindExpressions);
    }

    private static void decodeRef(PsiJavaCodeReferenceElement expression2, Map<PsiClass, PsiElement> oldToNewMap, Map<PsiJavaCodeReferenceElement, PsiElement> rebindExpressions) {
        PsiClass psiClass;
        PsiElement resolved = expression2.resolve();
        if (resolved instanceof PsiClass && oldToNewMap.containsKey(psiClass = (PsiClass)resolved)) {
            rebindExpressions.put(expression2, oldToNewMap.get(psiClass));
        }
    }

    @Nullable
    private static PsiClass[] getTopLevelClasses(PsiElement element) {
        PsiClass[] psiClassArray;
        while (!(element == null || element instanceof PsiFile || element instanceof PsiClass && element.getParent() != null && ((PsiClass)element).getContainingClass() == null && !(element instanceof PsiAnonymousClass))) {
            element = element.getParent();
        }
        if (element instanceof PsiClassOwner) {
            PsiClass[] classes2 = ((PsiClassOwner)element).getClasses();
            ArrayList<PsiClass> buffer = new ArrayList<PsiClass>();
            for (PsiClass aClass : classes2) {
                if (CopyClassesHandler.isSynthetic(aClass)) {
                    return null;
                }
                buffer.add(aClass);
            }
            return buffer.toArray(new PsiClass[buffer.size()]);
        }
        if (element instanceof PsiClass) {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = (PsiClass)element;
        } else {
            psiClassArray = null;
        }
        return psiClassArray;
    }
}

