/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.CommonBundle;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyFilesOrDirectoriesHandler
extends CopyHandlerDelegateBase {
    private static Logger LOG = Logger.getInstance((String)"com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler");

    @Override
    public boolean canCopy(PsiElement[] elements, boolean fromUpdate) {
        HashSet<String> names = new HashSet<String>();
        for (PsiElement element : elements) {
            if (!(element instanceof PsiDirectory) && !(element instanceof PsiFile)) {
                return false;
            }
            if (!element.isValid()) {
                return false;
            }
            if (element instanceof PsiCompiledFile) {
                return false;
            }
            String name2 = ((PsiFileSystemItem)element).getName();
            if (names.contains(name2)) {
                return false;
            }
            names.add(name2);
        }
        PsiElement[] filteredElements = PsiTreeUtil.filterAncestors((PsiElement[])elements);
        return filteredElements.length == elements.length;
    }

    @Override
    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        Project project2;
        if (defaultTargetDirectory == null) {
            defaultTargetDirectory = CopyFilesOrDirectoriesHandler.getCommonParentDirectory(elements);
        }
        Project project3 = project2 = defaultTargetDirectory != null ? defaultTargetDirectory.getProject() : elements[0].getProject();
        if (defaultTargetDirectory != null && (defaultTargetDirectory = CopyFilesOrDirectoriesHandler.resolveDirectory(defaultTargetDirectory)) == null) {
            return;
        }
        defaultTargetDirectory = CopyFilesOrDirectoriesHandler.tryNotNullizeDirectory(project2, defaultTargetDirectory);
        CopyFilesOrDirectoriesHandler.copyAsFiles(elements, defaultTargetDirectory, project2);
    }

    @Nullable
    private static PsiDirectory tryNotNullizeDirectory(@NotNull Project project2, @Nullable PsiDirectory defaultTargetDirectory) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "tryNotNullizeDirectory"));
        }
        if (defaultTargetDirectory == null) {
            VirtualFile root = (VirtualFile)ArrayUtil.getFirstElement((Object[])ProjectRootManager.getInstance((Project)project2).getContentRoots());
            if (root == null) {
                root = project2.getBaseDir();
            }
            if (root == null) {
                root = VfsUtil.getUserHomeDir();
            }
            PsiDirectory psiDirectory = defaultTargetDirectory = root != null ? PsiManager.getInstance((Project)project2).findDirectory(root) : null;
            if (defaultTargetDirectory == null) {
                LOG.warn("No directory found for project: " + project2.getName() + ", root: " + root);
            }
        }
        return defaultTargetDirectory;
    }

    public static void copyAsFiles(PsiElement[] elements, @Nullable PsiDirectory defaultTargetDirectory, Project project2) {
        CopyFilesOrDirectoriesHandler.doCopyAsFiles(elements, defaultTargetDirectory, project2);
    }

    private static void doCopyAsFiles(PsiElement[] elements, @Nullable PsiDirectory defaultTargetDirectory, Project project2) {
        boolean openInEditor;
        String newName;
        PsiDirectory targetDirectory;
        VirtualFile[] files = (VirtualFile[])Arrays.stream(elements).map(el -> ((PsiFileSystemItem)el).getVirtualFile()).toArray(VirtualFile[]::new);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            targetDirectory = defaultTargetDirectory;
            newName = null;
            openInEditor = true;
        } else {
            CopyFilesOrDirectoriesDialog dialog2 = new CopyFilesOrDirectoriesDialog(elements, defaultTargetDirectory, project2, false);
            if (dialog2.showAndGet()) {
                newName = elements.length == 1 ? dialog2.getNewName() : null;
                targetDirectory = dialog2.getTargetDirectory();
                openInEditor = dialog2.openInEditor();
            } else {
                return;
            }
        }
        if (targetDirectory != null) {
            PsiManager manager = PsiManager.getInstance((Project)project2);
            try {
                for (VirtualFile file2 : files) {
                    if (!file2.isDirectory()) continue;
                    PsiDirectory psiElement = manager.findDirectory(file2);
                    MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf((PsiElement)psiElement, (PsiElement)targetDirectory);
                }
            }
            catch (IncorrectOperationException e) {
                CommonRefactoringUtil.showErrorHint((Project)project2, null, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), null);
                return;
            }
            CommandProcessor.getInstance().executeCommand(project2, () -> CopyFilesOrDirectoriesHandler.copyImpl(files, newName, targetDirectory, false, openInEditor), RefactoringBundle.message((String)"copy.handler.copy.files.directories"), null);
        }
    }

    @Override
    public void doClone(PsiElement element) {
        CopyFilesOrDirectoriesHandler.doCloneFile(element);
    }

    public static void doCloneFile(PsiElement element) {
        PsiDirectory targetDirectory = element instanceof PsiDirectory ? ((PsiDirectory)element).getParentDirectory() : PlatformPackageUtil.getDirectory(element);
        targetDirectory = CopyFilesOrDirectoriesHandler.tryNotNullizeDirectory(element.getProject(), targetDirectory);
        if (targetDirectory == null) {
            return;
        }
        PsiElement[] elements = new PsiElement[]{element};
        VirtualFile file2 = ((PsiFileSystemItem)element).getVirtualFile();
        CopyFilesOrDirectoriesDialog dialog2 = new CopyFilesOrDirectoriesDialog(elements, null, element.getProject(), true);
        if (dialog2.showAndGet()) {
            String newName = dialog2.getNewName();
            CopyFilesOrDirectoriesHandler.copyImpl(new VirtualFile[]{file2}, newName, targetDirectory, true, true);
        }
    }

    @Nullable
    private static PsiDirectory getCommonParentDirectory(PsiElement[] elements) {
        PsiDirectory result2 = null;
        for (PsiElement element : elements) {
            PsiDirectory directory;
            if (element instanceof PsiDirectory) {
                directory = (PsiDirectory)element;
                directory = directory.getParentDirectory();
            } else if (element instanceof PsiFile) {
                directory = PlatformPackageUtil.getDirectory(element);
            } else {
                throw new IllegalArgumentException("unexpected element " + element);
            }
            if (directory == null) continue;
            if (result2 == null) {
                result2 = directory;
                continue;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)directory, (PsiElement)result2, (boolean)true)) continue;
            result2 = directory;
        }
        return result2;
    }

    private static void copyImpl(@NotNull VirtualFile[] files, @Nullable String newName, @NotNull PsiDirectory targetDirectory, boolean doClone, boolean openInEditor) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "copyImpl"));
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirectory", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "copyImpl"));
        }
        if (doClone && files.length != 1) {
            throw new IllegalArgumentException("invalid number of elements to clone:" + files.length);
        }
        if (newName != null && files.length != 1) {
            throw new IllegalArgumentException("no new name should be set; number of elements is: " + files.length);
        }
        Project project2 = targetDirectory.getProject();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, Collections.singleton(targetDirectory), (boolean)false)) {
            return;
        }
        String title = RefactoringBundle.message((String)(doClone ? "copy,handler.clone.files.directories" : "copy.handler.copy.files.directories"));
        try {
            int[] nArray;
            PsiFile firstFile = null;
            if (files.length > 1 || files[0].isDirectory()) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = -1;
            } else {
                nArray = null;
            }
            int[] choice = nArray;
            PsiManager manager = PsiManager.getInstance((Project)project2);
            for (VirtualFile file2 : files) {
                PsiDirectory psiElement;
                Object object = psiElement = file2.isDirectory() ? manager.findDirectory(file2) : manager.findFile(file2);
                if (psiElement == null) {
                    LOG.info("invalid file: " + file2.getExtension());
                    continue;
                }
                PsiFile f = CopyFilesOrDirectoriesHandler.copyToDirectory((PsiFileSystemItem)psiElement, newName, targetDirectory, choice, title);
                if (firstFile != null) continue;
                firstFile = f;
            }
            if (firstFile != null && openInEditor) {
                CopyHandler.updateSelectionInActiveProjectView(firstFile, project2, doClone);
                if (!(firstFile instanceof PsiBinaryFile)) {
                    EditorHelper.openInEditor(firstFile);
                    ToolWindowManager.getInstance((Project)project2).activateEditorComponent();
                }
            }
        }
        catch (IncorrectOperationException | IOException ex) {
            Messages.showErrorDialog((Project)project2, (String)ex.getMessage(), (String)RefactoringBundle.message((String)"error.title"));
        }
    }

    @Nullable
    public static PsiFile copyToDirectory(@NotNull PsiFileSystemItem elementToCopy, @Nullable String newName, @NotNull PsiDirectory targetDirectory) throws IncorrectOperationException, IOException {
        if (elementToCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToCopy", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "copyToDirectory"));
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirectory", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "copyToDirectory"));
        }
        return CopyFilesOrDirectoriesHandler.copyToDirectory(elementToCopy, newName, targetDirectory, null, null);
    }

    @Nullable
    public static PsiFile copyToDirectory(@NotNull PsiFileSystemItem elementToCopy, @Nullable String newName, final @NotNull PsiDirectory targetDirectory, @Nullable int[] choice, @Nullable String title) throws IncorrectOperationException, IOException {
        if (elementToCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToCopy", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "copyToDirectory"));
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirectory", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "copyToDirectory"));
        }
        if (elementToCopy instanceof PsiFile) {
            String name2;
            final PsiFile file2 = (PsiFile)elementToCopy;
            String string = name2 = newName == null ? file2.getName() : newName;
            if (CopyFilesOrDirectoriesHandler.checkFileExist(targetDirectory, choice, file2, name2, "Copy")) {
                return null;
            }
            return (PsiFile)new WriteCommandAction<PsiFile>(targetDirectory.getProject(), title, new PsiFile[0]){

                protected void run(@NotNull Result<PsiFile> result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler$1", "run"));
                    }
                    result2.setResult((Object)targetDirectory.copyFileFrom(name2, file2));
                }
            }.execute().getResultObject();
        }
        if (elementToCopy instanceof PsiDirectory) {
            VirtualFile[] children2;
            PsiDirectory subdirectory;
            PsiDirectory existing;
            PsiDirectory directory = (PsiDirectory)elementToCopy;
            if (directory.equals(targetDirectory)) {
                return null;
            }
            if (newName == null) {
                newName = directory.getName();
            }
            if ((existing = targetDirectory.findSubdirectory(newName)) == null) {
                final String finalNewName = newName;
                subdirectory = (PsiDirectory)new WriteCommandAction<PsiDirectory>(targetDirectory.getProject(), title, new PsiFile[0]){

                    protected void run(@NotNull Result<PsiDirectory> result2) throws Throwable {
                        if (result2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler$2", "run"));
                        }
                        result2.setResult((Object)targetDirectory.createSubdirectory(finalNewName));
                    }
                }.execute().getResultObject();
            } else {
                subdirectory = existing;
            }
            EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)directory.getVirtualFile(), () -> subdirectory.getVirtualFile());
            PsiFile firstFile = null;
            Project project2 = directory.getProject();
            PsiManager manager = PsiManager.getInstance((Project)project2);
            for (VirtualFile file3 : children2 = directory.getVirtualFile().getChildren()) {
                PsiDirectory item;
                Object object = item = file3.isDirectory() ? manager.findDirectory(file3) : manager.findFile(file3);
                if (item == null) {
                    LOG.info("Invalidated item: " + file3.getExtension());
                    continue;
                }
                PsiFile f = CopyFilesOrDirectoriesHandler.copyToDirectory((PsiFileSystemItem)item, item.getName(), subdirectory, choice, title);
                if (firstFile != null) continue;
                firstFile = f;
            }
            return firstFile;
        }
        throw new IllegalArgumentException("unexpected elementToCopy: " + elementToCopy);
    }

    public static boolean checkFileExist(@Nullable PsiDirectory targetDirectory, int[] choice, PsiFile file2, String name2, String title) {
        if (targetDirectory == null) {
            return false;
        }
        PsiFile existing = targetDirectory.findFile(name2);
        if (existing != null && !existing.equals(file2)) {
            int selection;
            if (choice == null || choice[0] == -1) {
                String[] stringArray;
                String message2 = String.format("File '%s' already exists in directory '%s'", name2, targetDirectory.getVirtualFile().getPath());
                if (choice == null) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "Overwrite";
                    stringArray = stringArray2;
                    stringArray2[1] = "Skip";
                } else {
                    String[] stringArray3 = new String[4];
                    stringArray3[0] = "Overwrite";
                    stringArray3[1] = "Skip";
                    stringArray3[2] = "Overwrite for all";
                    stringArray = stringArray3;
                    stringArray3[3] = "Skip for all";
                }
                String[] options = stringArray;
                selection = Messages.showDialog((String)message2, (String)title, (String[])options, (int)0, (Icon)Messages.getQuestionIcon());
            } else {
                selection = choice[0];
            }
            if (choice != null && selection > 1) {
                choice[0] = selection % 2;
                selection = choice[0];
            }
            if (selection == 0 && file2 != existing) {
                WriteCommandAction.writeCommandAction((Project)targetDirectory.getProject()).withName(title).run(() -> existing.delete());
            } else {
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected static PsiDirectory resolveDirectory(@NotNull PsiDirectory defaultTargetDirectory) {
        if (defaultTargetDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultTargetDirectory", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesHandler", "resolveDirectory"));
        }
        Project project2 = defaultTargetDirectory.getProject();
        Boolean showDirsChooser = (Boolean)defaultTargetDirectory.getCopyableUserData(CopyPasteDelegator.SHOW_CHOOSER_KEY);
        if (showDirsChooser != null && showDirsChooser.booleanValue()) {
            PsiDirectoryContainer directoryContainer = PsiDirectoryFactory.getInstance(project2).getDirectoryContainer(defaultTargetDirectory);
            if (directoryContainer == null) {
                return defaultTargetDirectory;
            }
            return MoveFilesOrDirectoriesUtil.resolveToDirectory(project2, (PsiElement)directoryContainer);
        }
        return defaultTargetDirectory;
    }
}

