/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.ParametersFolder;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ExtractMethodSignatureSuggester {
    private static final Logger LOG = Logger.getInstance(ExtractMethodSignatureSuggester.class);
    private static final TObjectHashingStrategy<PsiExpression> ourEquivalenceStrategy = new TObjectHashingStrategy<PsiExpression>(){

        public int computeHashCode(PsiExpression object) {
            return RefactoringUtil.unparenthesizeExpression(object).getClass().hashCode();
        }

        public boolean equals(PsiExpression o1, PsiExpression o2) {
            return JavaPsiEquivalenceUtil.areExpressionsEquivalent(RefactoringUtil.unparenthesizeExpression(o1), RefactoringUtil.unparenthesizeExpression(o2));
        }
    };
    private final Project myProject;
    private final PsiElementFactory myElementFactory;
    private PsiMethod myExtractedMethod;
    private PsiMethodCallExpression myMethodCall;
    private VariableData[] myVariableData;

    public ExtractMethodSignatureSuggester(Project project2, PsiMethod extractedMethod, PsiMethodCallExpression methodCall, VariableData[] variableDatum) {
        this.myProject = project2;
        this.myElementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiClass containingClass = extractedMethod.getContainingClass();
        LOG.assertTrue(containingClass != null);
        this.myExtractedMethod = this.myElementFactory.createMethodFromText(extractedMethod.getText(), containingClass.getLBrace());
        this.myMethodCall = methodCall;
        this.myVariableData = variableDatum;
    }

    public List<Match> getDuplicates(PsiMethod method, PsiMethodCallExpression methodCall, ParametersFolder folder) {
        List<Match> duplicates = this.findDuplicatesSignature(method, folder);
        if (duplicates != null && !duplicates.isEmpty() && (ApplicationManager.getApplication().isUnitTestMode() || new PreviewDialog(method, this.myExtractedMethod, methodCall, this.myMethodCall, duplicates.size()).showAndGet())) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
                this.myMethodCall = (PsiMethodCallExpression)methodCall.replace((PsiElement)this.myMethodCall);
                this.myExtractedMethod = (PsiMethod)method.replace((PsiElement)this.myExtractedMethod);
            });
            DuplicatesFinder finder = MethodDuplicatesHandler.createDuplicatesFinder((PsiMember)this.myExtractedMethod);
            if (finder != null) {
                List<VariableData> datas = finder.getParameters().getInputVariables();
                this.myVariableData = datas.toArray(new VariableData[datas.size()]);
                return finder.findDuplicates((PsiElement)this.myExtractedMethod.getContainingClass());
            }
        }
        return null;
    }

    public PsiMethod getExtractedMethod() {
        return this.myExtractedMethod;
    }

    public PsiMethodCallExpression getMethodCall() {
        return this.myMethodCall;
    }

    public VariableData[] getVariableData() {
        return this.myVariableData;
    }

    @Nullable
    public List<Match> findDuplicatesSignature(final PsiMethod method, ParametersFolder folder) {
        ArrayList<PsiExpression> copies = new ArrayList<PsiExpression>();
        InputVariables variables = this.detectTopLevelExpressionsToReplaceWithParameters(copies);
        if (variables == null) {
            return null;
        }
        DuplicatesFinder defaultFinder = MethodDuplicatesHandler.createDuplicatesFinder((PsiMember)this.myExtractedMethod);
        if (defaultFinder == null) {
            return null;
        }
        DuplicatesFinder finder = new DuplicatesFinder(defaultFinder.getPattern(), variables, defaultFinder.getReturnValue(), new ArrayList()){

            @Override
            protected boolean isSelf(PsiElement candidate) {
                return PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)candidate, (boolean)true);
            }
        };
        List<Match> duplicates = finder.findDuplicates((PsiElement)method.getContainingClass());
        if (duplicates != null && !duplicates.isEmpty()) {
            this.restoreRenamedParams(copies, folder);
            if (!this.myMethodCall.isValid()) {
                return null;
            }
            this.myMethodCall = (PsiMethodCallExpression)this.myMethodCall.copy();
            this.inlineSameArguments(method, copies, variables, duplicates);
            for (PsiExpression expression2 : copies) {
                this.myMethodCall.getArgumentList().add((PsiElement)expression2);
            }
            return duplicates;
        }
        return null;
    }

    private void inlineSameArguments(PsiMethod method, List<PsiExpression> copies, InputVariables variables, List<Match> duplicates) {
        int strongParamsCound;
        List<VariableData> variableDatum = variables.getInputVariables();
        HashMap<PsiVariable, PsiExpression> toInline = new HashMap<PsiVariable, PsiExpression>();
        for (int i2 = strongParamsCound = method.getParameterList().getParametersCount(); i2 < variableDatum.size(); ++i2) {
            THashSet map2;
            VariableData variableData = variableDatum.get(i2);
            if (!ExtractMethodSignatureSuggester.collectParamValues(duplicates, variableData, (THashSet<PsiExpression>)(map2 = new THashSet(ourEquivalenceStrategy)))) continue;
            PsiExpression currentExpression = copies.get(i2 - strongParamsCound);
            map2.add((Object)currentExpression);
            if (map2.size() != 1) continue;
            toInline.put(variableData.variable, currentExpression);
        }
        if (!toInline.isEmpty()) {
            copies.removeAll(toInline.values());
            this.inlineArgumentsInMethodBody(toInline);
            this.removeRedundantParametersFromMethodSignature(toInline);
        }
        this.removeUnusedStongParams(strongParamsCound);
    }

    private void removeUnusedStongParams(int strongParamsCound) {
        PsiExpression[] expressions2 = this.myMethodCall.getArgumentList().getExpressions();
        PsiParameter[] parameters2 = this.myExtractedMethod.getParameterList().getParameters();
        PsiCodeBlock body2 = this.myExtractedMethod.getBody();
        if (body2 != null) {
            LocalSearchScope scope = new LocalSearchScope((PsiElement)body2);
            for (int i2 = strongParamsCound - 1; i2 >= 0; --i2) {
                PsiParameter parameter = parameters2[i2];
                if (ReferencesSearch.search((PsiElement)parameter, (SearchScope)scope).findFirst() != null) continue;
                parameter.delete();
                expressions2[i2].delete();
            }
        }
    }

    private void removeRedundantParametersFromMethodSignature(Map<PsiVariable, PsiExpression> param2ExprMap) {
        for (PsiParameter parameter : this.myExtractedMethod.getParameterList().getParameters()) {
            if (!param2ExprMap.containsKey(parameter)) continue;
            parameter.delete();
        }
    }

    private void inlineArgumentsInMethodBody(final Map<PsiVariable, PsiExpression> param2ExprMap) {
        final HashMap replacement = new HashMap();
        this.myExtractedMethod.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                PsiExpression toInlineExpr;
                super.visitReferenceExpression(expression2);
                PsiElement resolve2 = expression2.resolve();
                if (resolve2 instanceof PsiVariable && (toInlineExpr = (PsiExpression)param2ExprMap.get((PsiVariable)resolve2)) != null) {
                    replacement.put(expression2, toInlineExpr);
                }
            }
        });
        for (PsiExpression expression2 : replacement.keySet()) {
            expression2.replace((PsiElement)replacement.get(expression2));
        }
    }

    private static boolean collectParamValues(List<Match> duplicates, VariableData variableData, THashSet<PsiExpression> map2) {
        for (Match duplicate : duplicates) {
            List<PsiElement> values = duplicate.getParameterValues(variableData.variable);
            if (values == null || values.isEmpty()) {
                return false;
            }
            boolean found = false;
            for (PsiElement value2 : values) {
                if (!(value2 instanceof PsiExpression)) continue;
                map2.add((Object)((PsiExpression)value2));
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void restoreRenamedParams(List<PsiExpression> copies, ParametersFolder folder) {
        final HashMap<String, String> renameMap = new HashMap<String, String>();
        for (VariableData data : this.myVariableData) {
            String replacement = folder.getGeneratedCallArgument(data);
            if (data.name.equals(replacement)) continue;
            renameMap.put(data.name, replacement);
        }
        if (!renameMap.isEmpty()) {
            for (PsiExpression currentExpression : copies) {
                final HashMap params = new HashMap();
                currentExpression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression2) {
                        super.visitReferenceExpression(expression2);
                        PsiElement resolve2 = expression2.resolve();
                        if (resolve2 instanceof PsiParameter && ExtractMethodSignatureSuggester.this.myExtractedMethod.equals(((PsiParameter)resolve2).getDeclarationScope())) {
                            String name2 = ((PsiParameter)resolve2).getName();
                            String variable = (String)renameMap.get(name2);
                            if (renameMap.containsKey(name2)) {
                                params.put(expression2, variable);
                            }
                        }
                    }
                });
                for (PsiReferenceExpression expression2 : params.keySet()) {
                    String var = (String)params.get(expression2);
                    expression2.replace((PsiElement)this.myElementFactory.createExpressionFromText(var, (PsiElement)expression2));
                }
            }
        }
    }

    @Nullable
    private InputVariables detectTopLevelExpressionsToReplaceWithParameters(List<PsiExpression> copies) {
        PsiParameter[] parameters2 = this.myExtractedMethod.getParameterList().getParameters();
        ArrayList<PsiParameter> inputVariables = new ArrayList<PsiParameter>(Arrays.asList(parameters2));
        PsiCodeBlock body2 = this.myExtractedMethod.getBody();
        LOG.assertTrue(body2 != null);
        PsiStatement[] pattern = body2.getStatements();
        final ArrayList exprs = new ArrayList();
        for (PsiStatement statement2 : pattern) {
            PsiExpression expression2;
            if (statement2 instanceof PsiExpressionStatement && ((expression2 = ((PsiExpressionStatement)statement2).getExpression()) instanceof PsiIfStatement || expression2 instanceof PsiLoopStatement)) continue;
            statement2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitCallExpression(PsiCallExpression callExpression) {
                    PsiExpressionList list2 = callExpression.getArgumentList();
                    if (list2 != null) {
                        for (PsiExpression expression2 : list2.getExpressions()) {
                            if (expression2 instanceof PsiReferenceExpression) {
                                PsiElement resolve2 = ((PsiReferenceExpression)expression2).resolve();
                                if (!(resolve2 instanceof PsiField)) continue;
                                exprs.add(expression2);
                                continue;
                            }
                            exprs.add(expression2);
                        }
                    }
                }
            });
        }
        if (exprs.isEmpty()) {
            return null;
        }
        UniqueNameGenerator uniqueNameGenerator = new UniqueNameGenerator();
        for (PsiParameter parameter : parameters2) {
            uniqueNameGenerator.addExistingName(parameter.getName());
        }
        ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)this.myExtractedMethod.getBody())).filter(element -> element instanceof PsiVariable)).forEach(element -> uniqueNameGenerator.addExistingName(((PsiVariable)element).getName()));
        THashMap unique = new THashMap(ourEquivalenceStrategy);
        HashMap<PsiExpression, String> replacement = new HashMap<PsiExpression, String>();
        for (PsiExpression expr : exprs) {
            String name2 = (String)unique.get((Object)expr);
            if (name2 == null) {
                PsiType type2 = GenericsUtil.getVariableTypeByExpressionType((PsiType)expr.getType());
                if (type2 == null || type2 == PsiType.NULL || PsiUtil.resolveClassInType((PsiType)type2) instanceof PsiAnonymousClass || LambdaUtil.notInferredType((PsiType)type2)) {
                    return null;
                }
                copies.add(this.myElementFactory.createExpressionFromText(expr.getText(), (PsiElement)body2));
                SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)this.myProject).suggestVariableName(VariableKind.PARAMETER, null, expr, null);
                String paramName = info.names.length > 0 ? info.names[0] : "p";
                name2 = uniqueNameGenerator.generateUniqueName(paramName);
                PsiParameter parameter = (PsiParameter)this.myExtractedMethod.getParameterList().add((PsiElement)this.myElementFactory.createParameter(name2, type2));
                inputVariables.add(parameter);
                unique.put((Object)expr, (Object)name2);
            }
            replacement.put(expr, name2);
        }
        for (PsiExpression expression2 : replacement.keySet()) {
            expression2.replace((PsiElement)this.myElementFactory.createExpressionFromText((String)replacement.get(expression2), null));
        }
        return new InputVariables(inputVariables, this.myExtractedMethod.getProject(), new LocalSearchScope((PsiElement)this.myExtractedMethod), false);
    }

    private static class PreviewDialog
    extends DialogWrapper {
        private final PsiMethod myOldMethod;
        private final PsiMethod myNewMethod;
        private final PsiMethodCallExpression myOldCall;
        private final PsiMethodCallExpression myNewCall;
        private final int myDuplicatesNumber;

        public PreviewDialog(PsiMethod oldMethod, PsiMethod newMethod, PsiMethodCallExpression oldMethodCall, PsiMethodCallExpression newMethodCall, int duplicatesNumber) {
            super(oldMethod.getProject());
            this.myOldMethod = oldMethod;
            this.myNewMethod = newMethod;
            this.myOldCall = oldMethodCall;
            this.myNewCall = newMethodCall;
            this.myDuplicatesNumber = duplicatesNumber;
            this.setTitle("Extract Parameters to Replace Duplicates");
            this.setOKButtonText("Accept Signature Change");
            this.setCancelButtonText("Keep Original Signature");
            this.init();
        }

        @Nullable
        protected JComponent createNorthPanel() {
            return new JLabel("<html><b>No exact method duplicates were found</b>, though changed method as shown below has " + this.myDuplicatesNumber + " duplicate" + (this.myDuplicatesNumber > 1 ? "s" : "") + " </html>");
        }

        @Nullable
        protected JComponent createCenterPanel() {
            Project project2 = this.myOldMethod.getProject();
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)this.myOldMethod);
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            DocumentContent oldContent = contentFactory.create(this.myOldMethod.getText() + "\n\n\nmethod call:\n " + this.myOldCall.getText(), file2);
            DocumentContent newContent = contentFactory.create(this.myNewMethod.getText() + "\n\n\nmethod call:\n " + this.myNewCall.getText(), file2);
            SimpleDiffRequest request = new SimpleDiffRequest(null, (DiffContent)oldContent, (DiffContent)newContent, "Before", "After");
            DiffRequestPanel diffPanel = DiffManager.getInstance().createRequestPanel(project2, this.getDisposable(), null);
            diffPanel.putContextHints(DiffUserDataKeys.PLACE, (Object)"ExtractSignature");
            diffPanel.setRequest((DiffRequest)request);
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)diffPanel.getComponent(), "Center");
            panel2.setBorder(IdeBorderFactory.createEmptyBorder((Insets)JBUI.insetsTop((int)5)));
            return panel2;
        }
    }
}

