/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.makeStatic;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.makeStatic.AbstractMakeStaticDialog;
import com.intellij.refactoring.makeStatic.InternalUsageInfo;
import com.intellij.refactoring.makeStatic.MakeStaticUtil;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.refactoring.util.VariableData;
import com.intellij.ui.DocumentAdapter;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MakeParameterizedStaticDialog
extends AbstractMakeStaticDialog {
    private final Project myProject;
    private final String[] myNameSuggestions;
    private final JCheckBox myMakeClassParameter = new JCheckBox();
    private JComponent myClassParameterNameInputField;
    private final JCheckBox myMakeFieldParameters = new JCheckBox();
    private ParameterTablePanel myParameterPanel;
    private VariableData[] myVariableData;
    private final boolean myAnyNonFieldMembersUsed;
    private JCheckBox myGenerateDelegateCb;

    public MakeParameterizedStaticDialog(Project project2, PsiTypeParameterListOwner member, String[] nameSuggestions, InternalUsageInfo[] internalUsages) {
        super(project2, member);
        this.myProject = project2;
        this.myNameSuggestions = nameSuggestions;
        String type2 = UsageViewUtil.getType((PsiElement)this.myMember);
        this.setTitle(RefactoringBundle.message((String)"make.0.static", (Object[])new Object[]{StringUtil.capitalize((String)type2)}));
        this.myAnyNonFieldMembersUsed = this.buildVariableData(internalUsages);
        this.init();
    }

    private boolean buildVariableData(InternalUsageInfo[] internalUsages) {
        ArrayList<VariableData> variableDatum = new ArrayList<VariableData>();
        boolean nonFieldUsages = MakeStaticUtil.collectVariableData((PsiMember)this.myMember, internalUsages, variableDatum);
        this.myVariableData = variableDatum.toArray(new VariableData[0]);
        return nonFieldUsages;
    }

    @Override
    public boolean isReplaceUsages() {
        return true;
    }

    @Override
    public boolean isMakeClassParameter() {
        if (this.myMakeClassParameter != null) {
            return this.myMakeClassParameter.isSelected();
        }
        return false;
    }

    @Override
    public String getClassParameterName() {
        if (this.isMakeClassParameter()) {
            if (this.myClassParameterNameInputField instanceof JTextField) {
                return ((JTextField)this.myClassParameterNameInputField).getText();
            }
            if (this.myClassParameterNameInputField instanceof JComboBox) {
                return (String)((JComboBox)this.myClassParameterNameInputField).getEditor().getItem();
            }
            return null;
        }
        return null;
    }

    @Override
    public VariableData[] getVariableData() {
        if (this.myMakeFieldParameters != null && this.myMakeFieldParameters.isSelected()) {
            return this.myVariableData;
        }
        return null;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.makeMethodStatic");
    }

    protected JComponent createCenterPanel() {
        GridBagConstraints gbConstraints = new GridBagConstraints();
        JPanel panel2 = new JPanel(new GridBagLayout());
        gbConstraints.insets = JBUI.insets((int)4, (int)8);
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = -1;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 0;
        gbConstraints.anchor = 17;
        panel2.add((Component)this.createDescriptionLabel(), gbConstraints);
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 0;
        gbConstraints.anchor = 17;
        String text2 = this.myMember instanceof PsiMethod ? RefactoringBundle.message((String)"add.object.as.a.parameter.with.name") : RefactoringBundle.message((String)"add.object.as.a.parameter.to.constructors.with.name");
        this.myMakeClassParameter.setText(text2);
        panel2.add((Component)this.myMakeClassParameter, gbConstraints);
        this.myMakeClassParameter.setSelected(this.myAnyNonFieldMembersUsed);
        gbConstraints.insets = JBUI.insets((int)0, (int)8, (int)4, (int)8);
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 2;
        gbConstraints.fill = 2;
        gbConstraints.anchor = 18;
        if (this.myNameSuggestions.length > 1) {
            this.myClassParameterNameInputField = this.createComboBoxForName();
        } else {
            JTextField textField = new JTextField();
            textField.setText(this.myNameSuggestions[0]);
            textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(DocumentEvent event) {
                    MakeParameterizedStaticDialog.this.updateControls();
                }
            });
            this.myClassParameterNameInputField = textField;
        }
        panel2.add((Component)this.myClassParameterNameInputField, gbConstraints);
        gbConstraints.gridwidth = 0;
        if (this.myVariableData.length > 0) {
            gbConstraints.insets = JBUI.insets((int)4, (int)8);
            gbConstraints.weighty = 0.0;
            gbConstraints.weightx = 0.0;
            gbConstraints.gridheight = 1;
            gbConstraints.fill = 0;
            gbConstraints.anchor = 17;
            text2 = this.myMember instanceof PsiMethod ? RefactoringBundle.message((String)"add.parameters.for.fields") : RefactoringBundle.message((String)"add.parameters.for.fields.to.constructors");
            this.myMakeFieldParameters.setText(text2);
            panel2.add((Component)this.myMakeFieldParameters, gbConstraints);
            this.myMakeFieldParameters.setSelected(!this.myAnyNonFieldMembersUsed);
            this.myParameterPanel = new ParameterTablePanel(this.myProject, this.myVariableData, new PsiElement[]{this.myMember}){

                @Override
                protected void updateSignature() {
                }

                @Override
                protected void doEnterAction() {
                    MakeParameterizedStaticDialog.this.clickDefaultButton();
                }

                @Override
                protected void doCancelAction() {
                }
            };
            gbConstraints.insets = JBUI.insets((int)0, (int)8, (int)4, (int)8);
            gbConstraints.gridwidth = 2;
            gbConstraints.fill = 1;
            gbConstraints.weighty = 1.0;
            panel2.add((Component)this.myParameterPanel, gbConstraints);
        }
        ActionListener inputFieldValidator = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MakeParameterizedStaticDialog.this.updateControls();
            }
        };
        this.myMakeClassParameter.addActionListener(inputFieldValidator);
        this.myMakeFieldParameters.addActionListener(inputFieldValidator);
        if (this.myMember instanceof PsiMethod) {
            this.myGenerateDelegateCb = new JCheckBox(RefactoringBundle.message((String)"delegation.panel.delegate.via.overloading.method"));
            panel2.add((Component)this.myGenerateDelegateCb, gbConstraints);
        }
        this.updateControls();
        return panel2;
    }

    @Override
    protected boolean isGenerateDelegate() {
        return this.myGenerateDelegateCb != null && this.myGenerateDelegateCb.isSelected();
    }

    @Override
    protected boolean validateData() {
        PsiMethod methodWithParameter;
        int ret = 0;
        if (this.isMakeClassParameter() && (methodWithParameter = this.checkParameterDoesNotExist()) != null) {
            String who = methodWithParameter == this.myMember ? RefactoringBundle.message((String)"this.method") : DescriptiveNameUtil.getDescriptiveName((PsiElement)methodWithParameter);
            String message2 = RefactoringBundle.message((String)"0.already.has.parameter.named.1.use.this.name.anyway", (Object[])new Object[]{who, this.getClassParameterName()});
            ret = Messages.showYesNoDialog((Project)this.myProject, (String)message2, (String)RefactoringBundle.message((String)"warning.title"), (Icon)Messages.getWarningIcon());
            this.myClassParameterNameInputField.requestFocusInWindow();
        }
        return ret == 0;
    }

    private PsiMethod checkParameterDoesNotExist() {
        PsiMethod[] methods;
        PsiMethod[] psiMethodArray;
        String parameterName = this.getClassParameterName();
        if (parameterName == null) {
            return null;
        }
        if (this.myMember instanceof PsiMethod) {
            PsiMethod[] psiMethodArray2 = new PsiMethod[1];
            psiMethodArray = psiMethodArray2;
            psiMethodArray2[0] = (PsiMethod)this.myMember;
        } else {
            psiMethodArray = ((PsiClass)this.myMember).getConstructors();
        }
        for (PsiMethod method : methods = psiMethodArray) {
            PsiParameter[] parameters2;
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList == null) continue;
            for (PsiParameter parameter : parameters2 = parameterList.getParameters()) {
                if (!parameterName.equals(parameter.getName())) continue;
                return method;
            }
        }
        return null;
    }

    private void updateControls() {
        if (this.isMakeClassParameter()) {
            String classParameterName = this.getClassParameterName();
            if (classParameterName == null) {
                this.setOKActionEnabled(false);
            } else {
                this.setOKActionEnabled(PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(classParameterName.trim()));
            }
        } else {
            this.setOKActionEnabled(true);
        }
        if (this.myClassParameterNameInputField != null) {
            this.myClassParameterNameInputField.setEnabled(this.isMakeClassParameter());
        }
        if (this.myParameterPanel != null) {
            this.myParameterPanel.setEnabled(this.myMakeFieldParameters.isSelected());
        }
    }

    private JComboBox createComboBoxForName() {
        ComboBox combobox = new ComboBox((Object[])this.myNameSuggestions);
        combobox.setEditable(true);
        combobox.setSelectedIndex(0);
        combobox.setMaximumRowCount(8);
        combobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MakeParameterizedStaticDialog.this.updateControls();
            }
        });
        combobox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                MakeParameterizedStaticDialog.this.updateControls();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                MakeParameterizedStaticDialog.this.updateControls();
            }

            @Override
            public void keyTyped(KeyEvent e) {
                MakeParameterizedStaticDialog.this.updateControls();
            }
        });
        return combobox;
    }
}

