/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.memberPushDown.NewSubClassData;
import com.intellij.refactoring.memberPushDown.PushDownData;
import com.intellij.refactoring.memberPushDown.PushDownDelegate;
import com.intellij.refactoring.memberPushDown.PushDownUsageViewDescriptor;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushDownProcessor<MemberInfo extends MemberInfoBase<Member>, Member extends PsiElement, Klass extends PsiElement>
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(PushDownProcessor.class);
    private NewSubClassData mySubClassData;
    private PushDownDelegate<MemberInfo, Member> myDelegate;
    private PushDownData<MemberInfo, Member> myPushDownData;

    public PushDownProcessor(@NotNull Klass sourceClass, @NotNull List<MemberInfo> memberInfos, @NotNull DocCommentPolicy javaDocPolicy) {
        if (sourceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceClass", "com/intellij/refactoring/memberPushDown/PushDownProcessor", "<init>"));
        }
        if (memberInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberInfos", "com/intellij/refactoring/memberPushDown/PushDownProcessor", "<init>"));
        }
        if (javaDocPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaDocPolicy", "com/intellij/refactoring/memberPushDown/PushDownProcessor", "<init>"));
        }
        super(sourceClass.getProject());
        this.myDelegate = PushDownDelegate.findDelegate(sourceClass);
        LOG.assertTrue(this.myDelegate != null);
        this.myPushDownData = new PushDownData((PsiElement)sourceClass, memberInfos, javaDocPolicy);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/memberPushDown/PushDownProcessor", "createUsageViewDescriptor"));
        }
        PushDownUsageViewDescriptor pushDownUsageViewDescriptor = new PushDownUsageViewDescriptor(this.myPushDownData.getSourceClass(), this.myPushDownData.getMembersToMove());
        if (pushDownUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/memberPushDown/PushDownProcessor", "createUsageViewDescriptor"));
        }
        return pushDownUsageViewDescriptor;
    }

    @Override
    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/refactoring/memberPushDown/PushDownProcessor", "getElementsToWrite"));
        }
        List<PsiElement> list2 = Collections.singletonList(this.myPushDownData.getSourceClass());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/memberPushDown/PushDownProcessor", "getElementsToWrite"));
        }
        return list2;
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.myPushDownData.getSourceClass());
        data.addElements((Collection)ContainerUtil.map(this.myPushDownData.getMembersToMove(), MemberInfoBase::getMember));
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/memberPushDown/PushDownProcessor", "getAfterData"));
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (UsageInfo usage : usages) {
            elements.add(usage.getElement());
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(elements);
        return data;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        List<PsiElement> inheritors = this.myDelegate.findInheritors(this.myPushDownData);
        UsageInfo[] usageInfoArray = (UsageInfo[])ContainerUtil.map2Array(inheritors, (Object[])UsageInfo.EMPTY_ARRAY, this.myDelegate::createUsageInfo);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/memberPushDown/PushDownProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/memberPushDown/PushDownProcessor", "preprocessUsages"));
        }
        MultiMap conflicts = new MultiMap();
        this.myDelegate.checkSourceClassConflicts(this.myPushDownData, (MultiMap<PsiElement, String>)conflicts);
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        if (usagesIn.length == 0) {
            this.mySubClassData = this.myDelegate.preprocessNoInheritorsFound(this.myPushDownData.getSourceClass(), this.getCommandName());
            if (this.mySubClassData == NewSubClassData.ABORT_REFACTORING) {
                return false;
            }
        }
        Runnable runnable2 = () -> ApplicationManager.getApplication().runReadAction(() -> {
            if (this.mySubClassData != null) {
                this.myDelegate.checkTargetClassConflicts(null, this.myPushDownData, (MultiMap<PsiElement, String>)conflicts, this.mySubClassData);
            } else {
                for (UsageInfo usage : usagesIn) {
                    PsiElement element = usage.getElement();
                    if (element == null) continue;
                    PushDownDelegate delegate = PushDownDelegate.findDelegateForTarget(this.myPushDownData.getSourceClass(), element);
                    if (delegate != null) {
                        delegate.checkTargetClassConflicts(element, this.myPushDownData, (MultiMap<PsiElement, String>)conflicts, null);
                        continue;
                    }
                    conflicts.putValue((Object)element, (Object)"Not supported source/target pair detected");
                }
            }
        });
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable2, RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, usagesIn);
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/memberPushDown/PushDownProcessor", "refreshElements"));
        }
        if (elements.length == 1) {
            this.myPushDownData.setSourceClass(elements[0]);
        } else {
            LOG.assertTrue(false);
        }
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/memberPushDown/PushDownProcessor", "performRefactoring"));
        }
        try {
            this.pushDownToClasses(usages);
            this.myDelegate.removeFromSourceClass(this.myPushDownData);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public void pushDownToClasses(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/memberPushDown/PushDownProcessor", "pushDownToClasses"));
        }
        this.myDelegate.prepareToPush(this.myPushDownData);
        PsiElement sourceClass = this.myPushDownData.getSourceClass();
        if (this.mySubClassData != null) {
            PsiElement subClass = this.myDelegate.createSubClass(sourceClass, this.mySubClassData);
            if (subClass != null) {
                this.myDelegate.pushDownToClass(subClass, this.myPushDownData);
            }
        } else {
            for (UsageInfo usage : usages) {
                PushDownDelegate targetDelegate;
                PsiElement element = usage.getElement();
                if (element == null || (targetDelegate = PushDownDelegate.findDelegateForTarget(sourceClass, element)) == null) continue;
                targetDelegate.pushDownToClass(element, this.myPushDownData);
            }
        }
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"push.members.down.title");
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.push.down";
    }
}

