/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.ide.util.DirectoryChooser;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MultipleRootsMoveDestination;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public abstract class DestinationFolderComboBox
extends ComboboxWithBrowseButton {
    private static final String LEAVE_IN_SAME_SOURCE_ROOT = "Leave in same source root";
    private static final DirectoryChooser.ItemWrapper NULL_WRAPPER = new DirectoryChooser.ItemWrapper(null, null);
    private PsiDirectory myInitialTargetDirectory;
    private List<VirtualFile> mySourceRoots;

    public DestinationFolderComboBox() {
        super((JComboBox)new ComboBoxWithWidePopup());
    }

    public abstract String getTargetPackage();

    protected boolean reportBaseInTestSelectionInSource() {
        return false;
    }

    protected boolean reportBaseInSourceSelectionInTest() {
        return false;
    }

    public void setData(Project project2, PsiDirectory initialTargetDirectory, EditorComboBox editorComboBox) {
        this.setData(project2, initialTargetDirectory, new Pass<String>(){

            public void pass(String s) {
            }
        }, editorComboBox);
    }

    public void setData(final Project project2, final PsiDirectory initialTargetDirectory, final Pass<String> errorMessageUpdater, EditorComboBox editorComboBox) {
        this.myInitialTargetDirectory = initialTargetDirectory;
        this.mySourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots(project2);
        new ComboboxSpeedSearch(this.getComboBox()){

            @Override
            protected String getElementText(Object element) {
                VirtualFile virtualFile;
                Module module2;
                if (element == NULL_WRAPPER) {
                    return DestinationFolderComboBox.LEAVE_IN_SAME_SOURCE_ROOT;
                }
                if (element instanceof DirectoryChooser.ItemWrapper && (module2 = ModuleUtil.findModuleForFile((VirtualFile)(virtualFile = ((DirectoryChooser.ItemWrapper)element).getDirectory().getVirtualFile()), (Project)project2)) != null) {
                    return module2.getName();
                }
                return super.getElementText(element);
            }
        };
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        this.getComboBox().setRenderer(new ListCellRendererWrapper<DirectoryChooser.ItemWrapper>(){

            public void customize(JList list2, DirectoryChooser.ItemWrapper itemWrapper, int index, boolean selected, boolean hasFocus) {
                if (itemWrapper != NULL_WRAPPER && itemWrapper != null) {
                    this.setIcon(itemWrapper.getIcon((FileIndex)fileIndex));
                    this.setText(itemWrapper.getRelativeToProjectPath());
                } else {
                    this.setText(DestinationFolderComboBox.LEAVE_IN_SAME_SOURCE_ROOT);
                }
            }
        });
        final VirtualFile initialSourceRoot = initialTargetDirectory != null ? fileIndex.getSourceRootForFile(initialTargetDirectory.getVirtualFile()) : null;
        final VirtualFile[] selection = new VirtualFile[]{initialSourceRoot};
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile root = MoveClassesOrPackagesUtil.chooseSourceRoot(new PackageWrapper(PsiManager.getInstance((Project)project2), DestinationFolderComboBox.this.getTargetPackage()), DestinationFolderComboBox.this.mySourceRoots, initialTargetDirectory);
                if (root == null) {
                    return;
                }
                ComboBoxModel model = DestinationFolderComboBox.this.getComboBox().getModel();
                for (int i2 = 0; i2 < model.getSize(); ++i2) {
                    DirectoryChooser.ItemWrapper item = (DirectoryChooser.ItemWrapper)model.getElementAt(i2);
                    if (item == NULL_WRAPPER || !Comparing.equal((Object)fileIndex.getSourceRootForFile(item.getDirectory().getVirtualFile()), (Object)root)) continue;
                    DestinationFolderComboBox.this.getComboBox().setSelectedItem(item);
                    DestinationFolderComboBox.this.getComboBox().repaint();
                    return;
                }
                DestinationFolderComboBox.this.setComboboxModel(DestinationFolderComboBox.this.getComboBox(), root, root, fileIndex, DestinationFolderComboBox.this.mySourceRoots, project2, true, (Pass<String>)errorMessageUpdater);
            }
        });
        editorComboBox.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                JComboBox comboBox;
                DirectoryChooser.ItemWrapper selectedItem = (DirectoryChooser.ItemWrapper)(comboBox = DestinationFolderComboBox.this.getComboBox()).getSelectedItem();
                DestinationFolderComboBox.this.setComboboxModel(comboBox, selectedItem != null && selectedItem != NULL_WRAPPER ? fileIndex.getSourceRootForFile(selectedItem.getDirectory().getVirtualFile()) : initialSourceRoot, selection[0], fileIndex, DestinationFolderComboBox.this.mySourceRoots, project2, false, (Pass<String>)errorMessageUpdater);
            }
        });
        this.setComboboxModel(this.getComboBox(), initialSourceRoot, selection[0], fileIndex, this.mySourceRoots, project2, false, errorMessageUpdater);
        this.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PsiDirectory directory;
                Object selectedItem = DestinationFolderComboBox.this.getComboBox().getSelectedItem();
                DestinationFolderComboBox.this.updateErrorMessage((Pass<String>)errorMessageUpdater, fileIndex, selectedItem);
                if (selectedItem instanceof DirectoryChooser.ItemWrapper && selectedItem != NULL_WRAPPER && (directory = ((DirectoryChooser.ItemWrapper)selectedItem).getDirectory()) != null) {
                    selection[0] = fileIndex.getSourceRootForFile(directory.getVirtualFile());
                }
            }
        });
    }

    @Nullable
    public MoveDestination selectDirectory(PackageWrapper targetPackage, boolean showChooserWhenDefault) {
        DirectoryChooser.ItemWrapper selectedItem = (DirectoryChooser.ItemWrapper)this.getComboBox().getSelectedItem();
        if (selectedItem == null || selectedItem == NULL_WRAPPER) {
            return new MultipleRootsMoveDestination(targetPackage);
        }
        PsiDirectory selectedPsiDirectory = selectedItem.getDirectory();
        VirtualFile selectedDestination = selectedPsiDirectory.getVirtualFile();
        if (showChooserWhenDefault && this.myInitialTargetDirectory != null && Comparing.equal((Object)selectedDestination, (Object)this.myInitialTargetDirectory.getVirtualFile()) && this.mySourceRoots.size() > 1) {
            selectedDestination = MoveClassesOrPackagesUtil.chooseSourceRoot(targetPackage, this.mySourceRoots, this.myInitialTargetDirectory);
        }
        if (selectedDestination == null) {
            return null;
        }
        return new AutocreatingSingleSourceRootMoveDestination(targetPackage, selectedDestination);
    }

    private void updateErrorMessage(Pass<String> updateErrorMessage, ProjectFileIndex fileIndex, Object selectedItem) {
        boolean inTestSourceContent;
        PsiDirectory directory;
        boolean isSelectionInTestSourceContent;
        updateErrorMessage.pass(null);
        if (this.myInitialTargetDirectory != null && selectedItem instanceof DirectoryChooser.ItemWrapper && selectedItem != NULL_WRAPPER && (isSelectionInTestSourceContent = fileIndex.isInTestSourceContent((directory = ((DirectoryChooser.ItemWrapper)selectedItem).getDirectory()).getVirtualFile())) != (inTestSourceContent = fileIndex.isInTestSourceContent(this.myInitialTargetDirectory.getVirtualFile()))) {
            if (inTestSourceContent && this.reportBaseInTestSelectionInSource()) {
                updateErrorMessage.pass((Object)"Source root is selected while the test root is expected");
            }
            if (isSelectionInTestSourceContent && this.reportBaseInSourceSelectionInTest()) {
                updateErrorMessage.pass((Object)"Test root is selected while the source root is expected");
            }
        }
    }

    private void setComboboxModel(JComboBox comboBox, VirtualFile initialTargetDirectorySourceRoot, VirtualFile oldSelection, ProjectFileIndex fileIndex, List<VirtualFile> sourceRoots, Project project2, boolean forceIncludeAll, Pass<String> updateErrorMessage) {
        Dimension preferredSize;
        LinkedHashSet<PsiDirectory> targetDirectories = new LinkedHashSet<PsiDirectory>();
        HashMap<PsiDirectory, String> pathsToCreate = new HashMap<PsiDirectory, String>();
        MoveClassesOrPackagesUtil.buildDirectoryList(new PackageWrapper(PsiManager.getInstance((Project)project2), this.getTargetPackage()), sourceRoots, targetDirectories, pathsToCreate);
        if (!forceIncludeAll && targetDirectories.size() > pathsToCreate.size()) {
            targetDirectories.removeAll(pathsToCreate.keySet());
        }
        ArrayList<DirectoryChooser.ItemWrapper> items = new ArrayList<DirectoryChooser.ItemWrapper>();
        DirectoryChooser.ItemWrapper initial = null;
        DirectoryChooser.ItemWrapper oldOne = null;
        for (PsiDirectory targetDirectory : targetDirectories) {
            DirectoryChooser.ItemWrapper itemWrapper = new DirectoryChooser.ItemWrapper(targetDirectory, pathsToCreate.get(targetDirectory));
            items.add(itemWrapper);
            VirtualFile sourceRootForFile = fileIndex.getSourceRootForFile(targetDirectory.getVirtualFile());
            if (Comparing.equal((Object)sourceRootForFile, (Object)initialTargetDirectorySourceRoot)) {
                initial = itemWrapper;
                continue;
            }
            if (!Comparing.equal((Object)sourceRootForFile, (Object)oldSelection)) continue;
            oldOne = itemWrapper;
        }
        if (oldSelection == null || !fileIndex.isInLibrarySource(oldSelection)) {
            items.add(NULL_WRAPPER);
        }
        DirectoryChooser.ItemWrapper selection = DestinationFolderComboBox.chooseSelection(initialTargetDirectorySourceRoot, fileIndex, items, initial, oldOne);
        ComboBoxModel model = comboBox.getModel();
        if (model instanceof CollectionComboBoxModel) {
            boolean sameModel;
            boolean bl = sameModel = model.getSize() == items.size();
            if (sameModel) {
                for (int i2 = 0; i2 < items.size(); ++i2) {
                    DirectoryChooser.ItemWrapper itemWrapper;
                    DirectoryChooser.ItemWrapper oldItem = (DirectoryChooser.ItemWrapper)model.getElementAt(i2);
                    if (DestinationFolderComboBox.areItemsEquivalent(oldItem, itemWrapper = items.get(i2))) continue;
                    sameModel = false;
                    break;
                }
            }
            if (sameModel && DestinationFolderComboBox.areItemsEquivalent((DirectoryChooser.ItemWrapper)comboBox.getSelectedItem(), selection)) {
                return;
            }
        }
        this.updateErrorMessage(updateErrorMessage, fileIndex, selection);
        Collections.sort(items, (o1, o2) -> {
            if (o1 == NULL_WRAPPER) {
                return -1;
            }
            if (o2 == NULL_WRAPPER) {
                return 1;
            }
            return o1.getRelativeToProjectPath().compareToIgnoreCase(o2.getRelativeToProjectPath());
        });
        comboBox.setModel(new CollectionComboBoxModel(items, (Object)selection));
        Component root = SwingUtilities.getRoot(comboBox);
        if (root instanceof Window && (preferredSize = root.getPreferredSize()).getWidth() > root.getSize().getWidth()) {
            root.setSize(preferredSize);
        }
    }

    @Nullable
    private static DirectoryChooser.ItemWrapper chooseSelection(VirtualFile initialTargetDirectorySourceRoot, ProjectFileIndex fileIndex, ArrayList<DirectoryChooser.ItemWrapper> items, DirectoryChooser.ItemWrapper initial, DirectoryChooser.ItemWrapper oldOne) {
        if (initial != null || (initialTargetDirectorySourceRoot == null || items.size() > 2) && items.contains(NULL_WRAPPER) || items.isEmpty()) {
            return initial;
        }
        if (oldOne != null) {
            return oldOne;
        }
        if (initialTargetDirectorySourceRoot != null) {
            boolean inTest = fileIndex.isInTestSourceContent(initialTargetDirectorySourceRoot);
            for (DirectoryChooser.ItemWrapper item : items) {
                VirtualFile virtualFile;
                PsiDirectory directory = item.getDirectory();
                if (directory == null || fileIndex.isInTestSourceContent(virtualFile = directory.getVirtualFile()) != inTest) continue;
                return item;
            }
        }
        return items.get(0);
    }

    private static boolean areItemsEquivalent(DirectoryChooser.ItemWrapper oItem, DirectoryChooser.ItemWrapper itemWrapper) {
        if (oItem == NULL_WRAPPER || itemWrapper == NULL_WRAPPER) {
            return oItem == itemWrapper;
        }
        if (oItem == null) {
            return itemWrapper == null;
        }
        if (itemWrapper == null) {
            return false;
        }
        return oItem.getDirectory() == itemWrapper.getDirectory();
    }

    public static boolean isAccessible(Project project2, VirtualFile virtualFile, VirtualFile targetVirtualFile) {
        boolean inTestSourceContent = ProjectRootManager.getInstance((Project)project2).getFileIndex().isInTestSourceContent(virtualFile);
        Module module2 = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project2);
        return targetVirtualFile == null || module2 == null || GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2, (boolean)inTestSourceContent).contains(targetVirtualFile);
    }
}

