/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.refactoring.openapi.impl.JavaRenameRefactoringImpl;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BeanPropertyRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        return false;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.getProperty(dataContext) != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/rename/BeanPropertyRenameHandler", "invoke"));
        }
        this.performInvoke(editor, dataContext);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/rename/BeanPropertyRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/rename/BeanPropertyRenameHandler", "invoke"));
        }
        this.performInvoke(null, dataContext);
    }

    private void performInvoke(@Nullable Editor editor, DataContext dataContext) {
        BeanProperty property = this.getProperty(dataContext);
        assert (property != null);
        PsiNamedElement element = property.getPsiElement();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String newName = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
            assert (newName != null);
            BeanPropertyRenameHandler.doRename(property, newName, editor, false, false);
            return;
        }
        if (PsiElementRenameHandler.canRename(element.getProject(), editor, (PsiElement)element)) {
            new PropertyRenameDialog(property, editor).show();
        }
    }

    @Deprecated
    public static void doRename(@NotNull BeanProperty property, String newName, boolean searchInComments, boolean isPreview) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/refactoring/rename/BeanPropertyRenameHandler", "doRename"));
        }
        BeanPropertyRenameHandler.doRename(property, newName, null, searchInComments, isPreview);
    }

    public static void doRename(@NotNull BeanProperty property, String newName, @Nullable Editor editor, boolean searchInComments, boolean isPreview) {
        PsiMethod getter;
        PsiElement getterSubstitutor;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/refactoring/rename/BeanPropertyRenameHandler", "doRename"));
        }
        PsiNamedElement psiElement = property.getPsiElement();
        JavaRenameRefactoringImpl rename = new JavaRenameRefactoringImpl(psiElement.getProject(), (PsiElement)psiElement, newName, searchInComments, false);
        rename.setPreviewUsages(isPreview);
        PsiMethod setter = property.getSetter();
        PsiElement setterSubstitutor = BeanPropertyRenameHandler.substituteElementToRename((PsiElement)setter, editor);
        if (setterSubstitutor != null) {
            JavaCodeStyleManager manager;
            String suggestedParameterName;
            if (setterSubstitutor == setter) {
                rename.addElement(setterSubstitutor, PropertyUtil.suggestSetterName((String)newName));
            } else {
                rename.addElement(setterSubstitutor, newName);
            }
            PsiParameter[] setterParameters = setter.getParameterList().getParameters();
            if (setterParameters.length == 1 && (suggestedParameterName = (manager = JavaCodeStyleManager.getInstance((Project)psiElement.getProject())).propertyNameToVariableName(property.getName(), VariableKind.PARAMETER)).equals(setterParameters[0].getName())) {
                rename.addElement((PsiElement)setterParameters[0], manager.propertyNameToVariableName(newName, VariableKind.PARAMETER));
            }
        }
        if ((getterSubstitutor = BeanPropertyRenameHandler.substituteElementToRename((PsiElement)(getter = property.getGetter()), editor)) != null) {
            if (getterSubstitutor == getter) {
                rename.addElement(getterSubstitutor, PropertyUtil.suggestGetterName((String)newName, (PsiType)getter.getReturnType()));
            } else {
                rename.addElement(getterSubstitutor, newName);
            }
        }
        rename.run();
    }

    @Contract(value="null, _ -> null")
    private static PsiElement substituteElementToRename(@Nullable PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            return null;
        }
        RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement(element);
        PsiElement substituted = processor2.substituteElementToRename(element, editor);
        if (substituted == null || !PsiElementRenameHandler.canRename(element.getProject(), editor, substituted)) {
            return null;
        }
        return substituted;
    }

    @Nullable
    protected abstract BeanProperty getProperty(DataContext var1);

    private static class PropertyRenameDialog
    extends RenameDialog {
        private final BeanProperty myProperty;
        private final Editor myEditor;

        protected PropertyRenameDialog(BeanProperty property, Editor editor) {
            super(property.getMethod().getProject(), (PsiElement)property.getPsiElement(), null, editor);
            this.myEditor = editor;
            this.myProperty = property;
        }

        @Override
        protected void doAction() {
            String newName = this.getNewName();
            boolean searchInComments = this.isSearchInComments();
            BeanPropertyRenameHandler.doRename(this.myProperty, newName, this.myEditor, searchInComments, this.isPreviewUsages());
            this.close(0);
        }
    }
}

