/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.PreferrableNameSuggestionProvider;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class MyLookupExpression
extends Expression {
    protected final String myName;
    protected final LookupElement[] myLookupItems;
    private final String myAdvertisementText;

    public MyLookupExpression(String name2, LinkedHashSet<String> names, PsiNamedElement elementToRename, PsiElement nameSuggestionContext, boolean shouldSelectAll, String advertisement) {
        this.myName = name2;
        this.myAdvertisementText = advertisement;
        this.myLookupItems = MyLookupExpression.initLookupItems(names, elementToRename, nameSuggestionContext, shouldSelectAll);
    }

    private static LookupElement[] initLookupItems(LinkedHashSet<String> names, PsiNamedElement elementToRename, PsiElement nameSuggestionContext, final boolean shouldSelectAll) {
        if (names == null) {
            NameSuggestionProvider provider;
            SuggestedNameInfo suggestedNameInfo;
            names = new LinkedHashSet();
            NameSuggestionProvider[] nameSuggestionProviderArray = (NameSuggestionProvider[])Extensions.getExtensions((ExtensionPointName)NameSuggestionProvider.EP_NAME);
            int n = nameSuggestionProviderArray.length;
            for (int j = 0; j < n && ((suggestedNameInfo = (provider = nameSuggestionProviderArray[j]).getSuggestedNames((PsiElement)elementToRename, nameSuggestionContext, names)) == null || !(provider instanceof PreferrableNameSuggestionProvider) || ((PreferrableNameSuggestionProvider)provider).shouldCheckOthers()); ++j) {
            }
        }
        LookupElement[] lookupElements = new LookupElement[names.size()];
        Iterator iterator = names.iterator();
        for (int i2 = 0; i2 < lookupElements.length; ++i2) {
            final String suggestion = (String)iterator.next();
            lookupElements[i2] = LookupElementBuilder.create((String)suggestion).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    TextRange range;
                    if (shouldSelectAll) {
                        return;
                    }
                    Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(context.getEditor());
                    TemplateState templateState = TemplateManagerImpl.getTemplateState(topLevelEditor);
                    if (templateState != null && (range = templateState.getCurrentVariableRange()) != null) {
                        topLevelEditor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)suggestion);
                    }
                }
            });
        }
        return lookupElements;
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        return this.myLookupItems;
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    public Result calculateResult(ExpressionContext context) {
        TextResult insertedValue;
        TemplateState templateState = TemplateManagerImpl.getTemplateState(context.getEditor());
        TextResult textResult = insertedValue = templateState != null ? templateState.getVariableValue("PrimaryVariable") : null;
        if (insertedValue != null && !insertedValue.getText().isEmpty()) {
            return insertedValue;
        }
        return new TextResult(this.myName);
    }

    public String getAdvertisingText() {
        return this.myAdvertisementText;
    }
}

