/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithBuilder.usageInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.refactoring.replaceConstructorWithBuilder.ParameterData;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;

public class ReplaceConstructorWithSettersChainInfo
extends FixableUsageInfo {
    private final String myBuilderClass;
    private final Map<String, ParameterData> myParametersMap;

    public ReplaceConstructorWithSettersChainInfo(PsiNewExpression constructorReference, String builderClass, Map<String, ParameterData> parametersMap) {
        super((PsiElement)constructorReference);
        this.myBuilderClass = builderClass;
        this.myParametersMap = parametersMap;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        PsiNewExpression expr = (PsiNewExpression)this.getElement();
        if (expr != null) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory();
            PsiMethod constructor = expr.resolveConstructor();
            if (constructor != null) {
                StringBuffer buf = new StringBuffer();
                PsiExpressionList argumentList = expr.getArgumentList();
                if (argumentList != null) {
                    PsiExpression[] args = argumentList.getExpressions();
                    PsiParameter[] parameters2 = constructor.getParameterList().getParameters();
                    JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)constructor.getProject());
                    for (int i2 = 0; i2 < Math.min(constructor.getParameterList().getParametersCount(), args.length); ++i2) {
                        String pureParamName;
                        ParameterData data;
                        String arg = args[i2].getText();
                        if (parameters2[i2].isVarArgs()) {
                            for (int ia = i2 + 1; ia < args.length; ++ia) {
                                arg = arg + ", " + args[ia].getText();
                            }
                        }
                        if (Comparing.strEqual((String)arg, (String)(data = this.myParametersMap.get(pureParamName = styleManager.variableNameToPropertyName(parameters2[i2].getName(), VariableKind.PARAMETER))).getDefaultValue()) && !data.isInsertSetter()) continue;
                        buf.append(data.getSetterName()).append("(").append(arg).append(").");
                    }
                    PsiExpression settersChain = elementFactory.createExpressionFromText("new " + this.myBuilderClass + "()." + buf.toString() + "create" + StringUtil.capitalize((String)constructor.getName()) + "()", null);
                    styleManager.shortenClassReferences(expr.replace((PsiElement)settersChain));
                }
            }
        }
    }
}

