/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.util.containers.ContainerUtil;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongAdderConversionRule
extends TypeConversionRule {
    public static final String JAVA_UTIL_CONCURRENT_ATOMIC_LONG_ADDER = "java.util.concurrent.atomic.LongAdder";
    private static final Set<String> IDENTICAL_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"longValue", "intValue", "doubleValue", "floatValue", "toString"});
    private static final Set<String> INCREMENT_DECREMENT_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"incrementAndGet", "getAndIncrement", "decrementAndGet", "getAndDecrement"});

    @Override
    @Nullable
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        byte parametersCount;
        if (!(from instanceof PsiClassType) || !from.getCanonicalText().equals(AtomicInteger.class.getName()) && !from.getCanonicalText().equals(AtomicLong.class.getName())) {
            return null;
        }
        if (!(to instanceof PsiClassType) || !to.getCanonicalText().equals(JAVA_UTIL_CONCURRENT_ATOMIC_LONG_ADDER)) {
            return null;
        }
        if (member != null) {
            String name2 = member.getName();
            if (INCREMENT_DECREMENT_METHODS.contains(name2)) {
                if (LongAdderConversionRule.isMethodCallWithIgnoredReturnValue(context)) {
                    return null;
                }
                assert (name2 != null);
                String replacementMethodName = name2.toLowerCase(Locale.ROOT).contains("increment") ? "increment" : "decrement";
                return new TypeConversionDescriptor("$v$.$method$()", "$v$." + replacementMethodName + "()");
            }
            if ("getAndAdd".equals(name2) || "addAndGet".equals(name2)) {
                if (LongAdderConversionRule.isMethodCallWithIgnoredReturnValue(context)) {
                    return null;
                }
                return new TypeConversionDescriptor("$v$.$method$($toAdd$)", "$v$.add($toAdd$)");
            }
            if ("set".equals(name2) || "lazySet".equals(name2) || "getAndSet".equals(name2)) {
                if ("getAndSet".equals(name2) && LongAdderConversionRule.isMethodCallWithIgnoredReturnValue(context)) {
                    return null;
                }
                String template = LongAdderConversionRule.getParametersCount((PsiCallExpression)context.getParent()) == 1 ? "$l$.reset()" : "$l$.add($v$ - $l$.sum())";
                return new TypeConversionDescriptor("$l$.$setMethodName$($v$)", template);
            }
            if ("get".equals(name2)) {
                return new TypeConversionDescriptor("$l$.get()", "$l$.sum()");
            }
            if (IDENTICAL_METHODS.contains(name2)) {
                return new TypeConversionDescriptorBase();
            }
        } else if (context instanceof PsiNewExpression && (parametersCount = LongAdderConversionRule.getParametersCount((PsiCallExpression)context)) != -1) {
            return new TypeConversionDescriptor("new $className$(" + (parametersCount == 1 ? "$p$" : "") + ")", "new java.util.concurrent.atomic.LongAdder()");
        }
        return null;
    }

    private static boolean isMethodCallWithIgnoredReturnValue(PsiExpression context) {
        PsiElement methodCall = context.getParent();
        if (!(methodCall instanceof PsiMethodCallExpression)) {
            return true;
        }
        PsiElement expressionStatement = methodCall.getParent();
        return !(expressionStatement instanceof PsiExpressionStatement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte getParametersCount(@NotNull PsiCallExpression context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/refactoring/typeMigration/rules/LongAdderConversionRule", "getParametersCount"));
        }
        PsiExpressionList list2 = context.getArgumentList();
        if (list2 == null) {
            return -1;
        }
        PsiExpression[] arguments = list2.getExpressions();
        if (arguments.length == 1) {
            PsiExpression argument = arguments[0];
            if (!(argument instanceof PsiLiteralExpression)) return -1;
            Object value2 = ((PsiLiteralExpression)argument).getValue();
            if (value2 instanceof Long && value2.equals(0L)) {
                return 1;
            }
            if (!(value2 instanceof Integer) || !value2.equals(0)) return -1;
            return 1;
        }
        if (arguments.length != 0) return -1;
        return 0;
    }
}

