/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.inspections.GuavaConversionSettings;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.reference.SoftLazyValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGuavaTypeConversionRule
extends TypeConversionRule {
    private final SoftLazyValue<Map<String, TypeConversionDescriptorBase>> mySimpleDescriptors = new SoftLazyValue<Map<String, TypeConversionDescriptorBase>>(){

        @NotNull
        protected Map<String, TypeConversionDescriptorBase> compute() {
            HashMap map2 = new HashMap();
            BaseGuavaTypeConversionRule.this.fillSimpleDescriptors((Map<String, TypeConversionDescriptorBase>)map2);
            HashMap hashMap = map2;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule$1", "compute"));
            }
            return hashMap;
        }
    };

    protected void fillSimpleDescriptors(Map<String, TypeConversionDescriptorBase> descriptorsMap) {
    }

    @Nullable
    protected TypeConversionDescriptorBase findConversionForMethod(PsiType from, PsiType to, @NotNull PsiMethod method, @NotNull String methodName, PsiExpression context, TypeMigrationLabeler labeler) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule", "findConversionForMethod"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule", "findConversionForMethod"));
        }
        return null;
    }

    @Nullable
    protected TypeConversionDescriptorBase findConversionForVariableReference(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable psiVariable, @Nullable PsiExpression context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule", "findConversionForVariableReference"));
        }
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule", "findConversionForVariableReference"));
        }
        return null;
    }

    @NotNull
    public abstract String ruleFromClass();

    @NotNull
    public abstract String ruleToClass();

    @NotNull
    protected Set<String> getAdditionalUtilityClasses() {
        Set<String> set2 = Collections.emptySet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule", "getAdditionalUtilityClasses"));
        }
        return set2;
    }

    @Override
    @Nullable
    public final TypeConversionDescriptorBase findConversion(@Nullable PsiType from, @Nullable PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        PsiElement resolvedElement;
        if (from != null && to != null && !BaseGuavaTypeConversionRule.canConvert(from, to, this.ruleFromClass(), this.ruleToClass())) {
            return null;
        }
        if (member instanceof PsiMethod) {
            TypeConversionDescriptorBase descriptor;
            PsiMethod method = (PsiMethod)member;
            String methodName = method.getName();
            PsiClass aClass = method.getContainingClass();
            if (this.isValidMethodQualifierToConvert(aClass) && (descriptor = (TypeConversionDescriptorBase)((Map)this.mySimpleDescriptors.getValue()).get(methodName)) != null) {
                return descriptor;
            }
            return this.findConversionForMethod(from, to, method, methodName, context, labeler);
        }
        if (context instanceof PsiNewExpression) {
            PsiAnonymousClass anonymousClass = ((PsiNewExpression)context).getAnonymousClass();
            return anonymousClass == null ? null : this.findConversionForAnonymous(anonymousClass, labeler.getSettings(GuavaConversionSettings.class));
        }
        if (context instanceof PsiMethodReferenceExpression) {
            PsiType methodReferenceType = context.getType();
            if (methodReferenceType != null && to != null && to.isAssignableFrom(methodReferenceType)) {
                return new TypeConversionDescriptorBase();
            }
        } else if (context instanceof PsiReferenceExpression && (resolvedElement = ((PsiReferenceExpression)context).resolve()) instanceof PsiVariable) {
            return this.findConversionForVariableReference((PsiReferenceExpression)context, (PsiVariable)resolvedElement, context);
        }
        return null;
    }

    @Nullable
    protected TypeConversionDescriptorBase findConversionForAnonymous(@NotNull PsiAnonymousClass anonymousClass, @Nullable GuavaConversionSettings settings) {
        Set<String> ignoredAnnotations;
        if (anonymousClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousClass", "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule", "findConversionForAnonymous"));
        }
        Set<String> set2 = ignoredAnnotations = settings != null ? settings.getIgnoredAnnotations() : Collections.emptySet();
        if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(anonymousClass, false, ignoredAnnotations)) {
            return new TypeConversionDescriptorBase(){

                @Override
                public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
                    if (evaluator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule$2", "replace"));
                    }
                    return AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)expression2, false, true);
                }
            };
        }
        return null;
    }

    protected boolean isValidMethodQualifierToConvert(PsiClass aClass) {
        return aClass != null && (this.ruleFromClass().equals(aClass.getQualifiedName()) || this.getAdditionalUtilityClasses().contains(aClass.getQualifiedName()));
    }

    static boolean canConvert(@Nullable PsiType from, @Nullable PsiType to, @NotNull String fromClassName, @NotNull String toClassName) {
        if (fromClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromClassName", "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule", "canConvert"));
        }
        if (toClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toClassName", "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule", "canConvert"));
        }
        if (!(from instanceof PsiClassType)) {
            return false;
        }
        if (!(to instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult fromResolveResult = ((PsiClassType)from).resolveGenerics();
        PsiClass fromClass = fromResolveResult.getElement();
        if (fromClass instanceof PsiAnonymousClass) {
            fromClass = ((PsiAnonymousClass)fromClass).getBaseClassType().resolve();
        }
        if (fromClass == null || !fromClassName.equals(fromClass.getQualifiedName())) {
            return false;
        }
        PsiClassType.ClassResolveResult toResolveResult = ((PsiClassType)to).resolveGenerics();
        PsiClass toClass = toResolveResult.getElement();
        return toClass != null && toClassName.equals(toClass.getQualifiedName());
    }
}

