/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.inspections.GuavaConversionSettings;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaConversionUtil {
    private static final Logger LOG = Logger.getInstance(GuavaConversionUtil.class);

    @Nullable
    public static PsiType getFunctionReturnType(PsiExpression functionExpression) {
        if (functionExpression instanceof PsiFunctionalExpression) {
            return LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiFunctionalExpression)functionExpression));
        }
        PsiType currentType = functionExpression.getType();
        if (currentType == null) {
            return null;
        }
        block0: do {
            if (LambdaUtil.isFunctionalType((PsiType)currentType)) {
                return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)currentType);
            }
            PsiType[] superTypes = currentType.getSuperTypes();
            currentType = null;
            for (PsiType type2 : superTypes) {
                PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type2);
                if (aClass == null || !InheritanceUtil.isInheritor((PsiClass)aClass, (String)GuavaLambda.FUNCTION.getClassQName())) continue;
                currentType = type2;
                continue block0;
            }
        } while (currentType != null);
        return null;
    }

    @NotNull
    public static PsiType addTypeParameters(@NotNull String baseClassQualifiedName, @Nullable PsiType type2, @NotNull PsiElement context) {
        String canonicalText;
        if (baseClassQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassQualifiedName", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "addTypeParameters"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "addTypeParameters"));
        }
        String parameterText = "";
        if (type2 != null && (canonicalText = type2.getCanonicalText(false)).contains("<")) {
            parameterText = canonicalText.substring(canonicalText.indexOf(60));
        }
        PsiType psiType = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText(baseClassQualifiedName + parameterText, context);
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "addTypeParameters"));
        }
        return psiType;
    }

    public static boolean isJavaLambda(PsiElement element, TypeEvaluator evaluator) {
        PsiElement parent;
        if (element instanceof PsiLocalVariable) {
            return GuavaLambda.findJavaAnalogueFor(evaluator.getType(element)) != null;
        }
        if (element instanceof PsiReturnStatement) {
            PsiElement methodOrLambda = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            PsiType methodReturnType = null;
            if (methodOrLambda instanceof PsiMethod) {
                methodReturnType = evaluator.getType(methodOrLambda);
            }
            return GuavaLambda.findJavaAnalogueFor(methodReturnType) != null;
        }
        if (element instanceof PsiExpressionList && (parent = element.getParent()) instanceof PsiMethodCallExpression) {
            return evaluator.getType(parent) != null;
        }
        return false;
    }

    public static PsiExpression adjustLambdaContainingExpression(PsiExpression expression2, boolean insertTypeCase, PsiType targetType, @NotNull TypeEvaluator evaluator) {
        GuavaLambda lambda2;
        PsiExpression qualifier;
        PsiType evaluatedType;
        GuavaLambda lambda3;
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "adjustLambdaContainingExpression"));
        }
        if (expression2 instanceof PsiNewExpression) {
            PsiAnonymousClass anonymousClass = ((PsiNewExpression)expression2).getAnonymousClass();
            if (anonymousClass != null) {
                return GuavaConversionUtil.convertAnonymousClass((PsiNewExpression)expression2, anonymousClass, evaluator);
            }
            GuavaLambda lambda4 = GuavaLambda.findFor(evaluator.evaluateType(expression2));
            if (lambda4 == null) {
                return expression2;
            }
            PsiExpression expressionWithMethodReference = GuavaConversionUtil.addMethodReference(expression2, lambda4);
            if (insertTypeCase) {
                return GuavaConversionUtil.adjustLambdaContainingExpression(expressionWithMethodReference, true, targetType, evaluator);
            }
            return expressionWithMethodReference;
        }
        if (expression2 instanceof PsiMethodReferenceExpression && (lambda3 = GuavaLambda.findJavaAnalogueFor(evaluatedType = evaluator.evaluateType(qualifier = ((PsiMethodReferenceExpression)expression2).getQualifierExpression()))) != null) {
            return GuavaConversionUtil.adjustLambdaContainingExpression((PsiExpression)expression2.replace((PsiElement)qualifier), insertTypeCase, targetType, evaluator);
        }
        if (expression2 instanceof PsiFunctionalExpression) {
            if (insertTypeCase) {
                return JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText("((" + targetType.getCanonicalText() + ")" + expression2.getText() + ")", (PsiElement)expression2);
            }
        } else if ((expression2 instanceof PsiMethodCallExpression || expression2 instanceof PsiReferenceExpression) && (lambda2 = GuavaLambda.findFor(evaluator.evaluateType(expression2))) != null) {
            expression2 = GuavaConversionUtil.addMethodReference(expression2, lambda2);
            return GuavaConversionUtil.adjustLambdaContainingExpression(expression2, insertTypeCase, targetType, evaluator);
        }
        return expression2;
    }

    public static PsiExpression convertAnonymousClass(@NotNull PsiNewExpression expression2, @NotNull PsiAnonymousClass anonymousClass, @NotNull TypeEvaluator typeEvaluator) {
        Set<String> ignoredAnnotations;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "convertAnonymousClass"));
        }
        if (anonymousClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousClass", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "convertAnonymousClass"));
        }
        if (typeEvaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeEvaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "convertAnonymousClass"));
        }
        GuavaConversionSettings settings = typeEvaluator.getSettings(GuavaConversionSettings.class);
        Set<String> set2 = ignoredAnnotations = settings != null ? settings.getIgnoredAnnotations() : Collections.emptySet();
        if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(anonymousClass, true, ignoredAnnotations)) {
            return AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)expression2, true, true);
        }
        return GuavaConversionUtil.tryConvertClassAndSamNameToJava(expression2);
    }

    public static PsiExpression tryConvertClassAndSamNameToJava(PsiNewExpression expression2) {
        PsiElement currentClassName;
        GuavaLambda lambda2 = GuavaLambda.findFor(expression2.getType());
        if (lambda2 == null) {
            return expression2;
        }
        PsiAnonymousClass aClass = expression2.getAnonymousClass();
        LOG.assertTrue(aClass != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
        if (!lambda2.getSamName().equals(lambda2.getJavaAnalogueSamName())) {
            boolean isFound = false;
            for (PsiMethod method : aClass.findMethodsByName(lambda2.getSamName(), false)) {
                if (method.getParameterList().getParametersCount() == lambda2.getParametersCount()) {
                    for (PsiMethod psiMethod : method.findSuperMethods()) {
                        PsiClass superMethodContainingClass = psiMethod.getContainingClass();
                        if (superMethodContainingClass == null || !lambda2.getClassQName().equals(superMethodContainingClass.getQualifiedName())) continue;
                        PsiIdentifier methodNameIdentifier = method.getNameIdentifier();
                        LOG.assertTrue(methodNameIdentifier != null);
                        methodNameIdentifier.replace((PsiElement)factory.createIdentifier(lambda2.getJavaAnalogueSamName()));
                        isFound = true;
                        break;
                    }
                }
                if (isFound) break;
            }
        }
        if ((currentClassName = aClass.getBaseClassReference().getReferenceNameElement()) != null) {
            PsiJavaCodeReferenceElement newNameElement = factory.createReferenceFromText(lambda2.getJavaAnalogueClassQName(), null);
            currentClassName.replace((PsiElement)newNameElement);
        }
        return (PsiExpression)expression2.replace((PsiElement)factory.createExpressionFromText(expression2.getText(), null));
    }

    private static PsiExpression addMethodReference(@NotNull PsiExpression expression2, @NotNull GuavaLambda lambda2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "addMethodReference"));
        }
        if (lambda2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil", "addMethodReference"));
        }
        return (PsiExpression)expression2.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText(expression2.getText() + "::" + lambda2.getSamName(), (PsiElement)expression2));
    }
}

