/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class WrapReturnValue
extends FixableUsageInfo {
    private final PsiReturnStatement myStatement;
    private final String myType;

    public WrapReturnValue(@NotNull PsiReturnStatement statement2, @NotNull String type2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/refactoring/wrapreturnvalue/usageInfo/WrapReturnValue", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/refactoring/wrapreturnvalue/usageInfo/WrapReturnValue", "<init>"));
        }
        super((PsiElement)statement2);
        this.myStatement = statement2;
        this.myType = type2;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        PsiExpression returnValue = this.myStatement.getReturnValue();
        assert (returnValue != null);
        String newExpression = "new " + this.myType + '(' + returnValue.getText() + ')';
        MutationUtils.replaceExpression(newExpression, returnValue);
    }
}

