/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebDeploymentCredentialsHolder {
    private static final String SFTP_DEPLOYMENT_PREFIX = "sftp://";
    public static final String WEB_SERVER_CREDENTIALS_ID = "WEB_SERVER_CREDENTIALS_ID";
    public static final String WEB_SERVER_CONFIG_ID = "WEB_SERVER_CONFIG_ID";
    public static final String WEB_SERVER_CONFIG_NAME = "WEB_SERVER_CONFIG_NAME";
    private String myCredentialsId;
    private String myWebServerConfigId;
    private String myWebServerConfigName;

    public WebDeploymentCredentialsHolder() {
    }

    public WebDeploymentCredentialsHolder(@NotNull String webServerConfigId, String name2, @NotNull RemoteCredentials remoteCredentials) {
        if (webServerConfigId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webServerConfigId", "com/intellij/remote/WebDeploymentCredentialsHolder", "<init>"));
        }
        if (remoteCredentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteCredentials", "com/intellij/remote/WebDeploymentCredentialsHolder", "<init>"));
        }
        this.myWebServerConfigId = webServerConfigId;
        this.myWebServerConfigName = name2;
        this.myCredentialsId = WebDeploymentCredentialsHolder.constructSftpCredentialsFullPath(remoteCredentials);
    }

    public String getCredentialsId() {
        return this.myCredentialsId;
    }

    @Nullable
    public String getWebServerConfigId() {
        return this.myWebServerConfigId;
    }

    public void setWebServerConfigId(@NotNull String webServerConfigId) {
        if (webServerConfigId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webServerConfigId", "com/intellij/remote/WebDeploymentCredentialsHolder", "setWebServerConfigId"));
        }
        this.myWebServerConfigId = webServerConfigId;
    }

    public String getWebServerConfigName() {
        return this.myWebServerConfigName;
    }

    public void setWebServerConfigName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/remote/WebDeploymentCredentialsHolder", "setWebServerConfigName"));
        }
        this.myWebServerConfigName = name2;
    }

    public void load(Element element) {
        this.setWebServerConfigId(element.getAttributeValue(WEB_SERVER_CONFIG_ID));
        this.setWebServerConfigName(StringUtil.notNullize((String)element.getAttributeValue(WEB_SERVER_CONFIG_NAME)));
        this.myCredentialsId = StringUtil.notNullize((String)element.getAttributeValue(WEB_SERVER_CREDENTIALS_ID));
        if (StringUtil.isEmpty((String)this.myCredentialsId)) {
            RemoteCredentialsHolder credentials = new RemoteCredentialsHolder();
            credentials.load(element);
            this.myCredentialsId = WebDeploymentCredentialsHolder.constructSftpCredentialsFullPath(credentials);
        }
    }

    public void save(Element element) {
        element.setAttribute(WEB_SERVER_CONFIG_ID, this.getWebServerConfigId());
        element.setAttribute(WEB_SERVER_CONFIG_NAME, this.getWebServerConfigName());
        element.setAttribute(WEB_SERVER_CREDENTIALS_ID, StringUtil.notNullize((String)this.getCredentialsId()));
    }

    @NotNull
    public WebDeploymentCredentialsHolder copyFrom(@NotNull WebDeploymentCredentialsHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/remote/WebDeploymentCredentialsHolder", "copyFrom"));
        }
        this.setWebServerConfigId(holder.getWebServerConfigId());
        this.setWebServerConfigName(holder.getWebServerConfigName());
        this.myCredentialsId = holder.getCredentialsId();
        WebDeploymentCredentialsHolder webDeploymentCredentialsHolder = this;
        if (webDeploymentCredentialsHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/WebDeploymentCredentialsHolder", "copyFrom"));
        }
        return webDeploymentCredentialsHolder;
    }

    @NotNull
    private static String constructSftpCredentialsFullPath(@NotNull RemoteCredentials cred) {
        if (cred == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/intellij/remote/WebDeploymentCredentialsHolder", "constructSftpCredentialsFullPath"));
        }
        String string = SFTP_DEPLOYMENT_PREFIX + cred.getUserName() + "@" + cred.getHost() + ":" + cred.getLiteralPort();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/WebDeploymentCredentialsHolder", "constructSftpCredentialsFullPath"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebDeploymentCredentialsHolder holder = (WebDeploymentCredentialsHolder)o;
        return this.myWebServerConfigId.equals(holder.myWebServerConfigId);
    }

    public int hashCode() {
        return this.myWebServerConfigId.hashCode();
    }
}

