/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationType;
import org.jetbrains.annotations.NotNull;

public class DeployToServerConfigurationTypesRegistrar
implements ApplicationComponent {
    public void initComponent() {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint(ConfigurationType.CONFIGURATION_TYPE_EP);
        for (ServerType serverType : (ServerType[])ServerType.EP_NAME.getExtensions()) {
            point.registerExtension((Object)new DeployToServerConfigurationType(serverType));
        }
    }

    @NotNull
    public static DeployToServerConfigurationType getDeployConfigurationType(@NotNull ServerType<?> serverType) {
        if (serverType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverType", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationTypesRegistrar", "getDeployConfigurationType"));
        }
        for (ConfigurationType type2 : (ConfigurationType[])ConfigurationType.CONFIGURATION_TYPE_EP.getExtensions()) {
            DeployToServerConfigurationType configurationType;
            if (!(type2 instanceof DeployToServerConfigurationType) || !(configurationType = (DeployToServerConfigurationType)type2).getServerType().equals(serverType)) continue;
            DeployToServerConfigurationType deployToServerConfigurationType = configurationType;
            if (deployToServerConfigurationType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerConfigurationTypesRegistrar", "getDeployConfigurationType"));
            }
            return deployToServerConfigurationType;
        }
        throw new IllegalArgumentException("Cannot find run configuration type for " + serverType.getClass());
    }
}

